/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.camera.clips.misc.Subtitle;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.graphics.Framebuffer;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class UISubtitleRenderer {
    private static Framebuffer getTextFramebuffer() {
        return BBSModClient.getFramebuffers().getFramebuffer(Link.bbs("camera_subtitles"), f -> {
            Texture texture = BBSModClient.getTextures().createTexture(Link.bbs("test"));
            texture.setFilter(9728);
            texture.setWrap(33071);
            f.deleteTextures();
            f.attach(texture, 36064);
            f.unbind();
        });
    }

    public static void renderSubtitles(class_4587 stack, Batcher2D batcher, List<Subtitle> subtitles) {
        if (subtitles.isEmpty()) {
            return;
        }
        class_5944 program = BBSShaders.getSubtitlesProgram();
        class_284 blur = program.method_34582("Blur");
        class_284 textureSize = program.method_34582("TextureSize");
        Supplier<class_5944> supplier = () -> program;
        class_276 fb = class_310.method_1551().method_1522();
        int width = fb.field_1482;
        int height = fb.field_1481;
        Matrix4f cache = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Framebuffer framebuffer = UISubtitleRenderer.getTextFramebuffer();
        Texture texture = framebuffer.getMainTexture();
        Matrix4f ortho = new Matrix4f().ortho(0.0f, (float)(width /= 2), (float)(height /= 2), 0.0f, -100.0f, 100.0f);
        FontRenderer font = Batcher2D.getDefaultTextRenderer();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableCull();
        for (Subtitle subtitle : subtitles) {
            float alpha = Colors.getA(subtitle.color);
            if (alpha <= 0.0f) continue;
            String label = StringUtils.processColoredText(subtitle.label);
            int w = 0;
            int h = 0;
            int x = (int)((float)width * subtitle.windowX + (float)subtitle.x);
            int y = (int)((float)height * subtitle.windowY + (float)subtitle.y);
            float scale = subtitle.size;
            int subColor = subtitle.color;
            List<String> strings = subtitle.maxWidth <= 10 ? Arrays.asList(label) : font.wrap(label, subtitle.maxWidth);
            for (String string : strings) {
                w = Math.max(w, font.getWidth(string.trim()));
            }
            h = (strings.size() - 1) * subtitle.lineHeight + font.getHeight();
            int fw = (int)((float)(w + 10) * scale);
            int fh = (int)((float)(h + 10) * scale);
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(0.0f, (float)(w + 10), 0.0f, (float)(h + 10), -100.0f, 100.0f), (class_8251)class_8251.field_43361);
            framebuffer.resize(fw, fh);
            framebuffer.applyClear();
            int yy = 5;
            for (String string : strings) {
                string = string.trim();
                int xx = 5 + (w - font.getWidth(string)) / 2;
                if (Colors.getA(subtitle.backgroundColor) > 0.0f) {
                    batcher.textCard(string, xx, yy, Colors.setA(subColor, 1.0f), Colors.mulA(subtitle.backgroundColor, alpha), subtitle.backgroundOffset, subtitle.textShadow);
                } else {
                    batcher.text(string, xx, yy, Colors.setA(subColor, 1.0f), subtitle.textShadow);
                }
                yy += subtitle.lineHeight;
            }
            fb.method_1235(true);
            RenderSystem.setProjectionMatrix((Matrix4f)ortho, (class_8251)class_8251.field_43361);
            Transform transform = new Transform();
            transform.lerp(subtitle.transform, 1.0f - subtitle.factor);
            stack.method_22903();
            stack.method_46416((float)x, (float)y, 0.0f);
            MatrixStackUtils.applyTransform(stack, transform);
            if (blur != null) {
                blur.method_1255(subtitle.shadow, subtitle.shadowOpaque ? 1.0f : 0.0f);
            }
            if (textureSize != null) {
                textureSize.method_1255((float)texture.width, (float)texture.height);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            batcher.texturedBox(supplier, texture.id, Colors.setA(-1, alpha), (float)(-fw) * subtitle.anchorX, (float)(-fh) * subtitle.anchorY, texture.width, texture.height, 0.0f, 0.0f, texture.width, texture.height, texture.width, texture.height);
            stack.method_22909();
        }
        RenderSystem.setProjectionMatrix((Matrix4f)cache, (class_8251)class_8251.field_43361);
        RenderSystem.enableCull();
    }
}

