/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIBitToggle
extends UIElement {
    public static final IKey PLUS = IKey.constant(" + ");
    private int value;
    public List<Bit> bits = new ArrayList<Bit>();
    public Consumer<Integer> callback;

    public UIBitToggle(Consumer<Integer> callback) {
        this.callback = callback;
        this.h(20);
    }

    public UIBitToggle all() {
        return this.point().angles();
    }

    public UIBitToggle point() {
        this.bits.add(new Bit(UIKeys.GENERAL_X, 0xFF3333));
        this.bits.add(new Bit(UIKeys.GENERAL_Y, 0x33FF33));
        this.bits.add(new Bit(UIKeys.GENERAL_Z, 0x3366FF));
        return this;
    }

    public UIBitToggle angles() {
        this.bits.add(new Bit(UIKeys.CAMERA_PANELS_YAW, 0xFFFF33));
        this.bits.add(new Bit(UIKeys.CAMERA_PANELS_PITCH, 0x33FFFF));
        this.bits.add(new Bit(UIKeys.CAMERA_PANELS_ROLL, 0xFF66FF));
        this.bits.add(new Bit(UIKeys.CAMERA_PANELS_FOV, -2013265920));
        return this;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.updateTooltip();
    }

    private void updateTooltip() {
        ArrayList<IKey> keys = new ArrayList<IKey>();
        for (int i = 0; i < this.bits.size(); ++i) {
            Bit bit = this.bits.get(i);
            if ((this.value >> i & 1) != 1) continue;
            keys.add(bit.label);
            keys.add(PLUS);
        }
        if (keys.isEmpty()) {
            this.removeTooltip();
        } else {
            keys.remove(keys.size() - 1);
            this.tooltip(IKey.comp(keys));
        }
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.area.isInside(context.mouseX, context.mouseY) && context.mouseButton == 0) {
            int index = (context.mouseX - this.area.x) / (this.area.w / this.bits.size());
            this.value ^= 1 << index;
            if (this.callback != null) {
                this.callback.accept(this.value);
            }
            this.updateTooltip();
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    public void render(UIContext context) {
        super.render(context);
        this.area.render(context.batcher, -2013265920);
        int size = this.bits.size();
        int w = this.area.w / size;
        int hovered = -1;
        for (int i = 0; i < size; ++i) {
            int right;
            int x = this.area.x + w * i;
            boolean isSelected = (this.value >> i & 1) == 1;
            boolean isHover = this.area.isInside(context.mouseX, context.mouseY) && (context.mouseX - this.area.x) / w == i;
            int n = right = i == size - 1 ? this.area.ex() : x + w;
            if (isHover) {
                hovered = i;
            }
            Bit bit = this.bits.get(i);
            if (isSelected) {
                context.batcher.box(x, this.area.y, right, this.area.y + this.area.h, Colors.mulRGB(bit.color, isHover ? 0.8f : 1.0f));
            } else if (isHover) {
                context.batcher.box(x, this.area.y, right, this.area.y + this.area.h, Colors.mulRGB(bit.color, 0.2f));
            }
            if (isSelected || i == 6) continue;
            context.batcher.box(right - 1, this.area.y, right, this.area.y + this.area.h, -2013265920);
        }
        context.batcher.outline(this.area.x, this.area.y, this.area.ex(), this.area.ey(), -2013265920);
        if (hovered >= 0) {
            FontRenderer font = context.batcher.getFont();
            Bit bit = this.bits.get(hovered);
            String label = bit.label.get();
            context.batcher.textCard(label, this.area.mx(font.getWidth(label)), this.area.my(font.getHeight()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Bit {
        public IKey label;
        public int color;

        public Bit(IKey label, int color) {
            this.label = label;
            this.color = 0xFF000000 | color;
        }
    }
}

