/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.screenplay;

import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.audio.ColorCode;
import mchorse.bbs_mod.audio.SoundBuffer;
import mchorse.bbs_mod.audio.SoundPlayer;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.audio.Waveform;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.IUITreeEventListener;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIAudioPlayer
extends UIElement
implements IUITreeEventListener {
    public static final float PIXELS = 40.0f;
    public UIIcon play = new UIIcon(() -> this.player == null || this.player.isPlaying() ? Icons.PAUSE : Icons.PLAY, b -> this.togglePlaying());
    private Wave wave;
    private Waveform waveform;
    private SoundBuffer buffer;
    private SoundPlayer player;
    private boolean wasPlaying;

    public UIAudioPlayer() {
        this.play.relative(this).h(1.0f);
        this.add((IUIElement)this.play);
    }

    public Wave getWave() {
        return this.wave;
    }

    public SoundPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void onAddedToTree(UIElement element) {
    }

    @Override
    public void onRemovedFromTree(UIElement element) {
        this.delete();
    }

    public void delete() {
        if (this.waveform != null) {
            this.waveform.delete();
        }
        if (this.buffer != null) {
            this.buffer.delete();
        }
        if (this.player != null) {
            this.player.delete();
        }
        this.wave = null;
        this.waveform = null;
        this.buffer = null;
        this.player = null;
    }

    public void loadAudio(Wave wave, List<ColorCode> colorCodes) {
        this.wave = wave;
        this.waveform = new Waveform();
        this.waveform.generate(this.wave, colorCodes, 40, 20);
        this.buffer = new SoundBuffer(null, this.wave, this.waveform);
        this.player = new SoundPlayer(this.buffer);
        this.player.setRelative(true);
        this.player.stop();
    }

    public void togglePlaying() {
        if (this.player != null) {
            if (this.player.isPlaying()) {
                this.player.pause();
            } else {
                this.player.play();
            }
            this.wasPlaying = this.player.isPlaying();
        }
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        Area.SHARED.set(this.area.x + 20, this.area.y, this.area.w - 20, this.area.h);
        if (this.player != null && Area.SHARED.isInside(context) && context.mouseButton == 0) {
            float playback = this.player.getPlaybackPosition();
            float offset = playback > 2.0f ? playback - 2.0f : 0.0f;
            float newPlayback = (float)(context.mouseX - (this.area.x + 20)) / 40.0f;
            this.player.setPlaybackPosition(newPlayback + offset);
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    public void render(UIContext context) {
        this.area.render(context.batcher, -1157627904);
        if (this.waveform != null) {
            int w = this.area.w - 20;
            float playback = this.player.getPlaybackPosition();
            float offset = playback > 2.0f ? playback - 2.0f : 0.0f;
            this.waveform.render(context.batcher, -1, this.area.x + 20, this.area.y, w, this.area.h, offset, offset + (float)w / 40.0f);
            int x = this.area.x + 20 + (int)(playback * (float)this.waveform.getPixelsPerSecond() - offset * 40.0f);
            context.batcher.box(x, this.area.y, x + 1, this.area.ey(), -11012822);
            int color = BBSSettings.primaryColor(-2013265920);
            String label = String.format("%.1f/%.1f", Float.valueOf(this.player.getPlaybackPosition()), Float.valueOf(this.player.getBuffer().getDuration()));
            FontRenderer font = context.batcher.getFont();
            context.batcher.textCard(label, this.area.ex() - 5 - font.getWidth(label), this.area.y + (this.area.h - font.getHeight()) / 2, -1, color);
        }
        if (this.player != null && this.wasPlaying != this.player.isPlaying()) {
            this.wasPlaying = this.player.isPlaying();
        }
        super.render(context);
    }
}

