/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.gizmos.BoneGizmoSystem;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.forms.editors.UIFormEditor;
import mchorse.bbs_mod.ui.forms.editors.forms.UIModelForm;
import mchorse.bbs_mod.ui.forms.editors.utils.UIFormRenderer;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIPoseKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UITransformKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.ui.utils.StencilFormFramebuffer;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class UIPickableFormRenderer
extends UIFormRenderer {
    public UIFormEditor formEditor;
    private boolean update;
    private StencilFormFramebuffer stencil = new StencilFormFramebuffer();
    private StencilMap stencilMap = new StencilMap();
    private IEntity target;
    private Supplier<Boolean> renderForm;

    public UIPickableFormRenderer(UIFormEditor formEditor) {
        this.formEditor = formEditor;
    }

    public void updatable() {
        this.update = true;
    }

    public StencilFormFramebuffer getStencil() {
        return this.stencil;
    }

    public void setRenderForm(Supplier<Boolean> renderForm) {
        this.renderForm = renderForm;
    }

    public IEntity getTargetEntity() {
        return this.target == null ? this.entity : this.target;
    }

    public void setTarget(IEntity target) {
        this.target = target;
    }

    private void ensureFramebuffer() {
        this.stencil.setup(Link.bbs("stencil_form"));
        this.stencil.resizeGUI(this.area.w, this.area.h);
    }

    @Override
    public void resize() {
        super.resize();
        this.ensureFramebuffer();
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue() && this.area.isInside(context) && BoneGizmoSystem.get().isHoveringHandle() && (context.mouseButton == 0 || context.mouseButton == 1 || context.mouseButton == 2)) {
            return true;
        }
        if (this.formEditor.clickViewport(context, this.stencil)) {
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    protected void renderUserModel(UIContext context) {
        if (this.form == null) {
            return;
        }
        this.formEditor.preFormRender(context, this.form);
        FormRenderingContext formContext = new FormRenderingContext().set(FormRenderType.PREVIEW, this.target == null ? this.entity : this.target, context.batcher.getContext().method_51448(), class_765.method_23687((int)15, (int)15), class_4608.field_21444, context.getTransition()).camera(this.camera).modelRenderer();
        if (this.renderForm == null || this.renderForm.get().booleanValue()) {
            FormUtilsClient.render(this.form, formContext);
            if (((Boolean)this.form.hitbox.get()).booleanValue()) {
                this.renderFormHitbox(context);
            }
        }
        this.renderAxes(context);
        Matrix4f originRaw = this.formEditor.getOrigin(context.getTransition());
        Matrix4f origin = originRaw != null ? MatrixStackUtils.stripScale(originRaw) : null;
        UIPropTransform activeTransform = null;
        if (this.formEditor.statesEditor.isVisible() && this.formEditor.statesKeyframes != null && this.formEditor.statesKeyframes.keyframeEditor != null) {
            factory = this.formEditor.statesKeyframes.keyframeEditor.editor;
            if (factory instanceof UIPoseKeyframeFactory) {
                UIPoseKeyframeFactory poseFactory = (UIPoseKeyframeFactory)factory;
                activeTransform = poseFactory.poseEditor.transform;
            } else if (factory instanceof UITransformKeyframeFactory) {
                UITransformKeyframeFactory transformFactory = (UITransformKeyframeFactory)factory;
                activeTransform = transformFactory.getTransform();
            }
        } else {
            factory = this.formEditor.editor;
            if (factory instanceof UIModelForm) {
                UIModelForm uiModelForm = (UIModelForm)factory;
                activeTransform = uiModelForm.modelPanel.poseEditor.transform;
            }
        }
        Matrix4f viewWithTranslation = new Matrix4f((Matrix4fc)this.camera.view).translate(-((float)this.camera.position.x), -((float)this.camera.position.y), -((float)this.camera.position.z));
        if (((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
            BoneGizmoSystem.get().update(context, this.area, origin, this.camera.projection, viewWithTranslation, activeTransform);
        }
        if (this.area.isInside(context)) {
            boolean blockPicking;
            GlStateManager._disableScissorTest();
            this.stencilMap.setup();
            this.stencil.apply();
            FormUtilsClient.render(this.form, formContext.stencilMap(this.stencilMap));
            boolean bl = blockPicking = (Boolean)BBSSettings.modelBlockGizmosEnabled.get() != false && BoneGizmoSystem.get().isHoveringHandle();
            if (!blockPicking) {
                this.stencil.pickGUI(context, this.area);
            } else {
                this.stencil.clearPicking();
            }
            this.stencil.unbind(this.stencilMap);
            class_310.method_1551().method_1522().method_1235(true);
            GlStateManager._enableScissorTest();
        } else {
            this.stencil.clearPicking();
        }
    }

    private void renderAxes(UIContext context) {
        Matrix4f matrixRaw = this.formEditor.getOrigin(context.getTransition());
        Matrix4f matrix = matrixRaw != null ? MatrixStackUtils.stripScale(matrixRaw) : null;
        class_4587 stack = context.render.batcher.getContext().method_51448();
        stack.method_22903();
        if (matrix != null) {
            MatrixStackUtils.multiply(stack, matrix);
        }
        if (UIBaseMenu.renderAxes && !((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
            RenderSystem.disableDepthTest();
            Draw.coolerAxes(stack, 0.25f, 0.01f, 0.26f, 0.02f);
            RenderSystem.enableDepthTest();
        }
        if (((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
            BoneGizmoSystem.get().render3D(stack);
        }
        stack.method_22909();
    }

    private void renderFormHitbox(UIContext context) {
        float hitboxW = ((Float)this.form.hitboxWidth.get()).floatValue();
        float hitboxH = ((Float)this.form.hitboxHeight.get()).floatValue();
        float eyeHeight = hitboxH * ((Float)this.form.hitboxEyeHeight.get()).floatValue();
        float thickness = 0.01f;
        Draw.renderBox(context.batcher.getContext().method_51448(), -0.01f, -0.01f + eyeHeight, -0.01f, 0.01f, 0.01f, 2.0, 1.0f, 0.0f, 0.0f);
        Draw.renderBox(context.batcher.getContext().method_51448(), -hitboxW / 2.0f, 0.0, -hitboxW / 2.0f, hitboxW, hitboxH, hitboxW);
    }

    @Override
    protected void update() {
        super.update();
        if (this.update && this.target != null) {
            this.form.update(this.entity);
        }
    }

    @Override
    public void render(UIContext context) {
        super.render(context);
        if (((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
            BoneGizmoSystem.get().renderOverlay(context.render, this.area);
        }
        if (!this.stencil.hasPicked()) {
            return;
        }
        int index = this.stencil.getIndex();
        Texture texture = this.stencil.getFramebuffer().getMainTexture();
        Pair<Form, String> pair = this.stencil.getPicked();
        int w = texture.width;
        int h = texture.height;
        class_5944 previewProgram = BBSShaders.getPickerPreviewProgram();
        class_284 target = previewProgram.method_34582("Target");
        if (target != null) {
            target.method_35649(index);
        }
        RenderSystem.enableBlend();
        context.batcher.texturedBox(BBSShaders::getPickerPreviewProgram, texture.id, -1, this.area.x, this.area.y, this.area.w, this.area.h, 0.0f, h, w, 0.0f, w, h);
        if (pair != null) {
            Object label = ((Form)pair.a).getFormIdOrName();
            if (!((String)pair.b).isEmpty()) {
                label = (String)label + " - " + (String)pair.b;
            }
            context.batcher.textCard((String)label, context.mouseX + 12, context.mouseY + 8);
        }
    }

    @Override
    protected void renderGrid(UIContext context) {
        if (this.renderForm == null || this.renderForm.get().booleanValue()) {
            super.renderGrid(context);
        }
    }
}

