/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import java.util.function.Consumer;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class UITransformKeyframeFactory
extends UIKeyframeFactory<Transform> {
    private UIPropTransform transform = new UIPoseTransforms(this);

    public UITransformKeyframeFactory(Keyframe<Transform> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        this.transform.enableHotkeys();
        this.transform.setTransform(keyframe.getValue());
        this.scroll.add((IUIElement)this.transform);
    }

    public UIPropTransform getTransform() {
        return this.transform;
    }

    @Environment(value=EnvType.CLIENT)
    public static class UIPoseTransforms
    extends UIPropTransform {
        private UITransformKeyframeFactory editor;

        public UIPoseTransforms(UITransformKeyframeFactory editor) {
            this.editor = editor;
        }

        public static void apply(UIKeyframes editor, Keyframe keyframe, Consumer<Transform> consumer) {
            for (UIKeyframeSheet sheet : editor.getGraph().getSheets()) {
                if (sheet.channel.getFactory() != keyframe.getFactory()) continue;
                for (Keyframe kf : sheet.selection.getSelected()) {
                    Object t = kf.getValue();
                    if (!(t instanceof Transform)) continue;
                    Transform transform = (Transform)t;
                    kf.preNotify();
                    consumer.accept(transform);
                    kf.postNotify();
                }
            }
        }

        @Override
        public void pasteTranslation(Vector3d translation) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.translate.set((Vector3dc)translation));
            this.refillTransform();
        }

        @Override
        public void pasteScale(Vector3d scale) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.scale.set((Vector3dc)scale));
            this.refillTransform();
        }

        @Override
        public void pasteRotation(Vector3d rotation) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.rotate.set((Vector3dc)Vectors.toRad(rotation)));
            this.refillTransform();
        }

        @Override
        public void pasteRotation2(Vector3d rotation) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.rotate2.set((Vector3dc)Vectors.toRad(rotation)));
            this.refillTransform();
        }

        @Override
        public void pastePivot(Vector3d pivot) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.pivot.set((float)pivot.x, (float)pivot.y, (float)pivot.z));
            this.refillTransform();
        }

        @Override
        public void setT(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)(x - (double)transform.translate.x);
            float dy = (float)(y - (double)transform.translate.y);
            float dz = (float)(z - (double)transform.translate.z);
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.translate.x += dx;
                poseT.translate.y += dy;
                poseT.translate.z += dz;
            });
        }

        @Override
        public void setS(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)(x - (double)transform.scale.x);
            float dy = (float)(y - (double)transform.scale.y);
            float dz = (float)(z - (double)transform.scale.z);
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.scale.x += dx;
                poseT.scale.y += dy;
                poseT.scale.z += dz;
            });
        }

        @Override
        public void setR(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = MathUtils.toRad((float)x) - transform.rotate.x;
            float dy = MathUtils.toRad((float)y) - transform.rotate.y;
            float dz = MathUtils.toRad((float)z) - transform.rotate.z;
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.rotate.x += dx;
                poseT.rotate.y += dy;
                poseT.rotate.z += dz;
            });
        }

        @Override
        public void setR2(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = MathUtils.toRad((float)x) - transform.rotate2.x;
            float dy = MathUtils.toRad((float)y) - transform.rotate2.y;
            float dz = MathUtils.toRad((float)z) - transform.rotate2.z;
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.rotate2.x += dx;
                poseT.rotate2.y += dy;
                poseT.rotate2.z += dz;
            });
        }

        @Override
        public void setP(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)x - transform.pivot.x;
            float dy = (float)y - transform.pivot.y;
            float dz = (float)z - transform.pivot.z;
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.pivot.x += dx;
                poseT.pivot.y += dy;
                poseT.pivot.z += dz;
            });
        }
    }
}

