/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.sections;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.particles.components.rate.ParticleComponentRate;
import mchorse.bbs_mod.particles.components.rate.ParticleComponentRateInstant;
import mchorse.bbs_mod.particles.components.rate.ParticleComponentRateSteady;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UICirculate;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeModeSection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemeRateSection
extends UIParticleSchemeModeSection<ParticleComponentRate> {
    public UIButton rate = new UIButton(UIKeys.SNOWSTORM_RATE_RATE, b -> {
        ParticleComponentRateSteady comp = (ParticleComponentRateSteady)this.component;
        this.editMoLang("rate.rate", str -> {
            comp.spawnRate = this.parse((String)str, comp.spawnRate);
        }, comp.spawnRate);
    });
    public UIButton particles;

    public UIParticleSchemeRateSection(UIParticleSchemePanel parent) {
        super(parent);
        this.rate.tooltip(UIKeys.SNOWSTORM_RATE_SPAWN_RATE);
        this.particles = new UIButton(UIKeys.SNOWSTORM_RATE_AMOUNT, b -> this.editMoLang("rate.particles", str -> {
            ((ParticleComponentRate)this.component).particles = this.parse((String)str, ((ParticleComponentRate)this.component).particles);
        }, ((ParticleComponentRate)this.component).particles));
        this.fields.add((IUIElement)this.particles);
    }

    @Override
    public IKey getTitle() {
        return UIKeys.SNOWSTORM_RATE_TITLE;
    }

    @Override
    protected void fillModes(UICirculate button) {
        button.addLabel(UIKeys.SNOWSTORM_RATE_INSTANT);
        button.addLabel(UIKeys.SNOWSTORM_RATE_STEADY);
    }

    @Override
    protected void restoreInfo(ParticleComponentRate component, ParticleComponentRate old) {
        component.particles = old.particles;
    }

    @Override
    protected Class<ParticleComponentRate> getBaseClass() {
        return ParticleComponentRate.class;
    }

    @Override
    protected Class getDefaultClass() {
        return ParticleComponentRateInstant.class;
    }

    @Override
    protected Class getModeClass(int value) {
        return value == 0 ? ParticleComponentRateInstant.class : ParticleComponentRateSteady.class;
    }

    @Override
    protected void fillData() {
        super.fillData();
        this.updateVisibility();
        this.particles.tooltip(this.isInstant() ? UIKeys.SNOWSTORM_RATE_PARTICLES : UIKeys.SNOWSTORM_RATE_MAX_PARTICLES);
    }

    private void updateVisibility() {
        if (this.isInstant()) {
            this.rate.removeFromParent();
        } else if (!this.rate.hasParent()) {
            this.fields.add((IUIElement)this.rate);
        }
        this.resizeParent();
    }

    private boolean isInstant() {
        return this.component instanceof ParticleComponentRateInstant;
    }
}

