/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.selectors;

import com.mojang.brigadier.StringReader;
import java.util.List;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.selectors.EntitySelector;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.UIFormPalette;
import mchorse.bbs_mod.ui.forms.UINestedEdit;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextarea;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.input.text.utils.TextLine;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.selectors.UISelectorList;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2522;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class UISelectorsOverlayPanel
extends UIOverlayPanel {
    public UISelectorList selectors = new UISelectorList(l -> this.setSelector((EntitySelector)l.get(0), false));
    public UIElement column;
    public UIToggle enabled;
    public UINestedEdit form;
    public UITextbox entity;
    public UITextbox name;
    public UITextarea<TextLine> nbt;
    private EntitySelector current;

    public UISelectorsOverlayPanel() {
        super(UIKeys.SELECTORS_TITLE);
        this.selectors.setList(BBSModClient.getSelectors().selectors);
        this.selectors.update();
        this.enabled = new UIToggle(UIKeys.CAMERA_PANELS_ENABLED, b -> {
            this.current.enabled = b.getValue();
            BBSModClient.getSelectors().update();
        });
        this.form = new UINestedEdit(editing -> UIFormPalette.open(this.getParent(UIOverlay.class), editing, this.current.form, true, form -> {
            this.current.form = FormUtils.copy(form);
            BBSModClient.getSelectors().update();
        }));
        this.entity = new UITextbox(100, t -> {
            String id = t.trim();
            try {
                this.current.entity = id.isEmpty() ? null : new class_2960(id);
            }
            catch (Exception e) {
                this.current.entity = null;
            }
            BBSModClient.getSelectors().update();
        });
        this.name = new UITextbox(100, t -> {
            this.current.name = t;
            BBSModClient.getSelectors().update();
        });
        this.nbt = new UITextarea(t -> {
            try {
                this.current.nbt = t.trim().isEmpty() ? null : new class_2522(new StringReader(t)).method_10727();
                BBSModClient.getSelectors().update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.nbt.background().wrap().h(80);
        this.selectors.context((ContextMenuManager menu) -> {
            menu.action(Icons.ADD, UIKeys.SELECTORS_CONTEXT_ADD, () -> {
                EntitySelector element = new EntitySelector();
                this.selectors.add(element);
                this.setSelector(element, true);
                BBSModClient.getSelectors().update();
            });
            if (this.current != null) {
                menu.action(Icons.REMOVE, UIKeys.SELECTORS_CONTEXT_REMOVE, () -> {
                    List list = this.selectors.getList();
                    list.remove(this.current);
                    this.setSelector(list.isEmpty() ? null : (EntitySelector)list.get(0), true);
                    BBSModClient.getSelectors().update();
                });
            }
        });
        this.column = UI.column(5, 10, this.enabled, this.form, UI.label(UIKeys.SELECTORS_ENTITY_ID).marginTop(6), this.entity, UI.label(UIKeys.SELECTORS_NAME_TAG).marginTop(6), this.name, UI.label(UIKeys.SELECTORS_NBT).marginTop(6), this.nbt);
        this.selectors.relative(this.content).w(1.0f).hTo(this.column.area);
        this.column.relative(this.content).y(1.0f).w(1.0f).anchor(0.0f, 1.0f);
        this.add(this.column, this.selectors);
        this.onClose(e -> BBSModClient.getSelectors().save());
        this.setSelector(this.selectors.getList().isEmpty() ? null : (EntitySelector)this.selectors.getList().get(0), true);
    }

    private void setSelector(EntitySelector selector, boolean select) {
        this.current = selector;
        this.column.setVisible(selector != null);
        if (selector != null) {
            this.enabled.setValue(selector.enabled);
            this.form.setForm(selector.form);
            this.entity.setText(selector.entity == null ? "" : selector.entity.toString());
            this.name.setText(selector.name);
            this.nbt.setText(selector.nbt == null ? "" : selector.nbt.toString());
        }
        if (select) {
            this.selectors.setCurrentScroll(selector);
        }
    }

    @Override
    protected void renderBackground(UIContext context) {
        super.renderBackground(context);
        this.content.area.render(context.batcher, -16777216);
    }
}

