/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.graphics.Framebuffer;
import mchorse.bbs_mod.graphics.Renderbuffer;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.utils.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

@Environment(value=EnvType.CLIENT)
public class StencilFormFramebuffer {
    private Framebuffer framebuffer;
    private int index;
    private Map<Integer, Pair<Form, String>> indexMap = new HashMap<Integer, Pair<Form, String>>();

    public Framebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<Integer, Pair<Form, String>> getIndexMap() {
        return this.indexMap;
    }

    public Pair<Form, String> getPicked() {
        return this.indexMap.get(this.index);
    }

    public void setup(Link id) {
        if (this.framebuffer != null) {
            return;
        }
        this.framebuffer = BBSModClient.getFramebuffers().getFramebuffer(id, framebuffer -> {
            Texture texture = new Texture();
            texture.setSize(2, 2);
            texture.setFilter(9728);
            texture.setWrap(33071);
            Renderbuffer renderbuffer = new Renderbuffer();
            renderbuffer.resize(2, 2);
            framebuffer.deleteTextures().attach(texture, 36064);
            framebuffer.attach(renderbuffer);
            framebuffer.unbind();
        });
    }

    public void resizeGUI(int w, int h) {
        this.resize(w, h, BBSModClient.getGUIScale());
    }

    public void resize(int w, int h, int scale) {
        this.resize(w * scale, h * scale);
    }

    public void resize(int w, int h) {
        if (this.framebuffer != null) {
            this.framebuffer.resize(w, h);
        }
    }

    public void apply() {
        this.framebuffer.applyClear();
    }

    public void pickGUI(UIContext context, Area area) {
        this.pickGUI(context.mouseX - area.x, area.h - context.mouseY + area.y);
    }

    public void pickGUI(int x, int y) {
        int scale = BBSModClient.getGUIScale();
        this.pick(x * scale, y * scale);
    }

    public void pick(int x, int y) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer floats = stack.mallocFloat(4);
            GL11.glReadPixels((int)x, (int)y, (int)1, (int)1, (int)6408, (int)5126, (FloatBuffer)floats);
            int r = (int)(floats.get() * 255.0f);
            int g = (int)(floats.get() * 255.0f);
            int b = (int)(floats.get() * 255.0f);
            int a = (int)(floats.get() * 255.0f);
            this.index = (float)a < 1.0f ? 0 : r;
        }
    }

    public void unbind(StencilMap map) {
        this.unbind();
        this.indexMap.clear();
        this.indexMap.putAll(map.indexMap);
    }

    public void unbind() {
        this.framebuffer.unbind();
    }

    public void clearPicking() {
        this.index = 0;
        this.indexMap.clear();
    }

    public boolean hasPicked() {
        return this.index > 0;
    }
}

