/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.pose;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.cubic.IModel;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.l10n.L10n;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.UITexturePicker;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UISearchList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIConfirmOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIPromptOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.pose.BoneCategoriesManager;
import mchorse.bbs_mod.ui.utils.presets.UIDataContextMenu;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.PoseManager;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import mchorse.bbs_mod.utils.pose.Transform;
import mchorse.bbs_mod.utils.resources.LinkUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIPoseEditor
extends UIElement {
    private static String lastLimb = "";
    public UIStringList groups;
    public UIStringList categories;
    public UITrackpad fix;
    public UIButton pickTexture;
    public UIColor color;
    public UIToggle lighting;
    public UIPropTransform transform;
    private String group = "";
    private Pose pose;
    protected IModel model;
    protected Map<String, String> flippedParts;
    protected Supplier<Link> defaultTextureSupplier;
    protected BoneCategoriesManager boneCategories = new BoneCategoriesManager();

    public UIPoseEditor() {
        boolean categoriesEnabled;
        this.groups = new UIStringList(l -> this.pickBone((String)l.get(0)));
        this.groups.background().h(120);
        this.groups.scroll.cancelScrolling();
        this.groups.context(() -> {
            UIDataContextMenu menu = new UIDataContextMenu(PoseManager.INSTANCE, this.group, () -> this.pose.toData(), this::pastePose);
            UIIcon flip = new UIIcon(Icons.CONVERT, b -> this.flipPose());
            flip.tooltip(UIKeys.POSE_CONTEXT_FLIP_POSE);
            menu.row.addBefore(menu.save, flip);
            return menu;
        });
        this.categories = new UIStringList(l -> {});
        this.categories.background().h(120);
        this.categories.scroll.cancelScrolling();
        this.categories.context((ContextMenuManager menu) -> {
            String selectedCategory = (String)this.categories.getCurrentFirst();
            menu.action(Icons.ADD, L10n.lang("bbs.ui.forms.categories.context.add_category"), () -> {
                UIPromptOverlayPanel panel = new UIPromptOverlayPanel(L10n.lang("bbs.ui.pose.categories.manage_title"), L10n.lang("bbs.ui.pose.categories.manage_category_name"), str -> {
                    if (str != null && !str.isEmpty()) {
                        this.boneCategories.addCategory(this.group, (String)str);
                        this.refreshCategories();
                    }
                });
                UIOverlay.addOverlay(this.getContext(), panel);
            });
            if (selectedCategory != null && !selectedCategory.isEmpty()) {
                menu.action(Icons.EDIT, L10n.lang("bbs.ui.forms.categories.context.rename_category"), () -> {
                    UIPromptOverlayPanel panel = new UIPromptOverlayPanel(L10n.lang("bbs.ui.pose.categories.manage_title"), L10n.lang("bbs.ui.pose.categories.manage_new_name"), str -> {
                        if (str != null && !str.isEmpty()) {
                            this.boneCategories.renameCategory(this.group, selectedCategory, (String)str);
                            this.refreshCategories();
                        }
                    });
                    UIOverlay.addOverlay(this.getContext(), panel);
                });
                menu.action(Icons.TRASH, L10n.lang("bbs.ui.forms.categories.context.remove_category"), 0xFF3333, () -> {
                    this.boneCategories.removeCategory(this.group, selectedCategory);
                    this.refreshCategories();
                });
                menu.action(Icons.LIST, L10n.lang("bbs.ui.pose.categories.context.view_bones"), () -> {
                    String group = this.group;
                    List<String> bones = this.boneCategories.getBones(group, selectedCategory);
                    UISearchList<String> search = new UISearchList<String>(new UIStringList(null));
                    UIList<String> list = search.list;
                    for (String g : bones) {
                        list.add(g);
                    }
                    UIConfirmOverlayPanel panel = new UIConfirmOverlayPanel(L10n.lang("bbs.ui.pose.categories.view_bones_title"), L10n.lang("bbs.ui.pose.categories.view_bones_description"), confirm -> {
                        int index;
                        String bone;
                        if (confirm.booleanValue() && (bone = (String)CollectionUtils.getSafe(bones, index = list.getIndex())) != null) {
                            this.selectBone(bone);
                        }
                    });
                    list.background();
                    search.relative(panel.confirm).y(-5).w(1.0f).h(212).anchor(0.0f, 1.0f);
                    list.context((ContextMenuManager ctx) -> {
                        ctx.action(Icons.TRASH, IKey.constant("Eliminar hueso"), 0xFF3333, () -> {
                            int idx = list.getIndex();
                            String bone = (String)CollectionUtils.getSafe(bones, idx);
                            if (bone != null) {
                                this.boneCategories.removeBone(group, selectedCategory, bone);
                                list.remove(bone);
                            }
                        });
                        ctx.autoKeys();
                    });
                    panel.content.add((IUIElement)search);
                    UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 340, 360);
                });
                String selectedBone = (String)this.groups.getCurrentFirst();
                if (selectedBone != null && !selectedBone.isEmpty()) {
                    menu.action(Icons.ADD, IKey.constant("A\u00f1adir hueso seleccionado"), () -> this.boneCategories.addBone(this.group, selectedCategory, selectedBone));
                    menu.action(Icons.REMOVE, IKey.constant("Quitar hueso seleccionado"), () -> this.boneCategories.removeBone(this.group, selectedCategory, selectedBone));
                }
            }
            menu.autoKeys();
        });
        this.fix = new UITrackpad(v -> {
            String selectedCategory;
            String string = selectedCategory = this.categories != null ? (String)this.categories.getCurrentFirst() : null;
            if (selectedCategory != null && !selectedCategory.isEmpty()) {
                this.applyCategory(p -> this.setFix((PoseTransform)p, v.floatValue()));
            } else {
                Transform patt9463$temp = this.transform.getTransform();
                if (patt9463$temp instanceof PoseTransform) {
                    PoseTransform poseTransform = (PoseTransform)patt9463$temp;
                    this.setFix(poseTransform, v.floatValue());
                }
            }
        });
        this.fix.limit(0.0, 1.0).increment(1.0).values(0.1, 0.05, 0.2);
        this.fix.tooltip(UIKeys.POSE_CONTEXT_FIX_TOOLTIP);
        this.fix.context((ContextMenuManager menu) -> {
            menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> this.applyChildren(p -> this.setFix((PoseTransform)p, (float)this.fix.getValue())));
            menu.action(Icons.DOWNLOAD, IKey.constant("Aplicar a categor\u00eda"), () -> this.applyCategory(p -> this.setFix((PoseTransform)p, (float)this.fix.getValue())));
        });
        this.pickTexture = new UIButton(UIKeys.TEXTURE_PICK_BONE_TEXTURE, b -> {
            PoseTransform poseTransform = (PoseTransform)this.transform.getTransform();
            Link current = null;
            if (poseTransform != null && poseTransform.texture != null) {
                current = poseTransform.texture;
            } else if (this.defaultTextureSupplier != null) {
                current = this.defaultTextureSupplier.get();
            }
            UITexturePicker.open(this.getContext(), current, l -> {
                String selectedCategory;
                String string = selectedCategory = this.categories != null ? (String)this.categories.getCurrentFirst() : null;
                if (selectedCategory != null && !selectedCategory.isEmpty()) {
                    this.applyCategory(p -> this.setTexture((PoseTransform)p, (Link)l));
                } else {
                    Transform patt11237$temp = this.transform.getTransform();
                    if (patt11237$temp instanceof PoseTransform) {
                        PoseTransform pt = (PoseTransform)patt11237$temp;
                        this.setTexture(pt, (Link)l);
                    }
                }
            });
        });
        this.pickTexture.context((ContextMenuManager menu) -> {
            menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> {
                PoseTransform t = (PoseTransform)this.transform.getTransform();
                Link chosen = t != null ? t.texture : null;
                this.applyChildren(p -> this.setTexture((PoseTransform)p, chosen));
            });
            menu.action(Icons.DOWNLOAD, IKey.constant("Aplicar a categor\u00eda"), () -> {
                PoseTransform t = (PoseTransform)this.transform.getTransform();
                Link chosen = t != null ? t.texture : null;
                this.applyCategory(p -> this.setTexture((PoseTransform)p, chosen));
            });
            menu.action(Icons.CLOSE, UIKeys.GENERAL_NONE, () -> {
                PoseTransform t = (PoseTransform)this.transform.getTransform();
                if (t != null) {
                    this.setTexture(t, null);
                }
            });
        });
        this.color = new UIColor(c -> {
            String selectedCategory;
            String string = selectedCategory = this.categories != null ? (String)this.categories.getCurrentFirst() : null;
            if (selectedCategory != null && !selectedCategory.isEmpty()) {
                this.applyCategory(p -> this.setColor((PoseTransform)p, (int)c));
            } else {
                Transform patt12778$temp = this.transform.getTransform();
                if (patt12778$temp instanceof PoseTransform) {
                    PoseTransform poseTransform = (PoseTransform)patt12778$temp;
                    this.setColor(poseTransform, (int)c);
                }
            }
        });
        this.color.withAlpha();
        this.color.context((ContextMenuManager menu) -> {
            menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> this.applyChildren(p -> this.setColor((PoseTransform)p, this.color.picker.color.getARGBColor())));
            menu.action(Icons.DOWNLOAD, IKey.constant("Aplicar a categor\u00eda"), () -> this.applyCategory(p -> this.setColor((PoseTransform)p, this.color.picker.color.getARGBColor())));
        });
        this.lighting = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_LIGHTING, b -> {
            String selectedCategory;
            String string = selectedCategory = this.categories != null ? (String)this.categories.getCurrentFirst() : null;
            if (selectedCategory != null && !selectedCategory.isEmpty()) {
                this.applyCategory(p -> this.setLighting((PoseTransform)p, b.getValue()));
            } else {
                Transform patt13870$temp = this.transform.getTransform();
                if (patt13870$temp instanceof PoseTransform) {
                    PoseTransform poseTransform = (PoseTransform)patt13870$temp;
                    this.setLighting(poseTransform, b.getValue());
                }
            }
        });
        this.lighting.h(20);
        this.lighting.context((ContextMenuManager menu) -> {
            menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> this.applyChildren(p -> this.setLighting((PoseTransform)p, this.lighting.getValue())));
            menu.action(Icons.DOWNLOAD, IKey.constant("Aplicar a categor\u00eda"), () -> this.applyCategory(p -> this.setLighting((PoseTransform)p, this.lighting.getValue())));
        });
        this.transform = this.createTransformEditor();
        this.transform.setModel();
        this.column().vertical().stretch();
        boolean bl = categoriesEnabled = BBSSettings.modelBlockCategoriesPanelEnabled != null && (Boolean)BBSSettings.modelBlockCategoriesPanelEnabled.get() != false;
        if (categoriesEnabled) {
            this.add(UI.row(this.groups, this.categories), UI.label(UIKeys.POSE_CONTEXT_FIX), this.fix, this.pickTexture, UI.row(this.color, this.lighting), this.transform);
        } else {
            this.add(this.groups, UI.label(UIKeys.POSE_CONTEXT_FIX), this.fix, this.pickTexture, UI.row(this.color, this.lighting), this.transform);
        }
    }

    public UIPoseEditor setDefaultTextureSupplier(Supplier<Link> supplier) {
        this.defaultTextureSupplier = supplier;
        return this;
    }

    private void applyChildren(Consumer<PoseTransform> consumer) {
        if (this.model == null) {
            return;
        }
        PoseTransform t = (PoseTransform)this.transform.getTransform();
        Collection<String> keys = this.model.getAllChildrenKeys(CollectionUtils.getKey(this.pose.transforms, t));
        for (String key : keys) {
            consumer.accept(this.pose.get(key));
        }
    }

    public Pose getPose() {
        return this.pose;
    }

    public String getGroup() {
        return (String)this.groups.getCurrentFirst();
    }

    protected void pastePose(MapType data) {
        String current = (String)this.groups.getCurrentFirst();
        this.pose.fromData(data);
        this.pickBone(current);
    }

    protected void flipPose() {
        String current = (String)this.groups.getCurrentFirst();
        this.pose.flip(this.flippedParts);
        this.pickBone(current);
    }

    public void setPose(Pose pose, String group) {
        this.pose = pose;
        this.group = group;
        this.refreshCategories();
    }

    public String getPoseGroupKey() {
        return this.group;
    }

    public void fillGroups(Collection<String> groups, boolean reset) {
        this.model = null;
        this.flippedParts = null;
        this.fillInGroups(groups, reset);
    }

    public void fillGroups(IModel model, Map<String, String> flippedParts, boolean reset) {
        this.model = model;
        this.flippedParts = flippedParts;
        this.fillInGroups(model == null ? Collections.emptyList() : model.getAllGroupKeys(), reset);
    }

    private void fillInGroups(Collection<String> groups, boolean reset) {
        this.groups.clear();
        this.groups.add(groups);
        this.groups.sort();
        this.fix.setVisible(!groups.isEmpty());
        this.color.setVisible(!groups.isEmpty());
        this.transform.setVisible(!groups.isEmpty());
        List list = this.groups.getList();
        int i = Math.max(reset ? 0 : list.indexOf(lastLimb), 0);
        this.groups.setCurrentScroll((String)CollectionUtils.getSafe(list, i));
        this.pickBone((String)this.groups.getCurrentFirst());
        this.refreshCategories();
    }

    public void selectBone(String bone) {
        lastLimb = bone;
        this.groups.setCurrentScroll(bone);
        this.pickBone(bone);
        if (this.categories != null && this.model != null) {
            List<String> cats = this.boneCategories.getCategories(this.group);
            for (String cat : cats) {
                List<String> bones = this.boneCategories.getBones(this.group, cat);
                if (!bones.contains(bone)) continue;
                this.categories.setCurrentScroll(cat);
                break;
            }
        }
    }

    protected UIPropTransform createTransformEditor() {
        return new CategoryPropTransform(this).enableHotkeys();
    }

    protected void pickBone(String bone) {
        lastLimb = bone;
        PoseTransform poseTransform = this.pose.get(bone);
        if (poseTransform != null) {
            this.fix.setValue(poseTransform.fix);
            this.color.setColor(poseTransform.color.getARGBColor());
            this.lighting.setValue(poseTransform.lighting == 0.0f);
            this.transform.setTransform(poseTransform);
        } else {
            this.fix.setValue(0.0);
            this.color.setColor(-1);
            this.lighting.setValue(false);
            this.transform.setTransform(null);
        }
    }

    protected void setFix(PoseTransform transform, float value) {
        transform.fix = value;
    }

    protected void setColor(PoseTransform transform, int value) {
        transform.color.set(value);
    }

    protected void setLighting(PoseTransform poseTransform, boolean value) {
        poseTransform.lighting = value ? 0.0f : 1.0f;
    }

    protected void setTexture(PoseTransform transform, Link value) {
        transform.texture = LinkUtils.copy(value);
    }

    protected void refreshCategories() {
        if (this.categories == null) {
            return;
        }
        this.categories.clear();
        if (this.group != null) {
            this.categories.add(this.boneCategories.getCategories(this.group));
            this.categories.sort();
        }
    }

    protected void applyCategory(Consumer<PoseTransform> consumer) {
        String selectedCategory;
        boolean categoriesEnabled = BBSSettings.modelBlockCategoriesPanelEnabled != null && (Boolean)BBSSettings.modelBlockCategoriesPanelEnabled.get() != false;
        String string = selectedCategory = categoriesEnabled ? (String)this.categories.getCurrentFirst() : null;
        if (this.model == null || selectedCategory == null || selectedCategory.isEmpty()) {
            return;
        }
        List<String> bones = this.boneCategories.getBones(this.group, selectedCategory);
        for (String key : bones) {
            PoseTransform t = this.pose.get(key);
            if (t == null) continue;
            consumer.accept(t);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CategoryPropTransform
    extends UIPropTransform {
        private final UIPoseEditor editor;

        private CategoryPropTransform(UIPoseEditor editor) {
            this.editor = editor;
        }

        private List<String> targets() {
            String selectedCategory;
            boolean categoriesEnabled = BBSSettings.modelBlockCategoriesPanelEnabled != null && (Boolean)BBSSettings.modelBlockCategoriesPanelEnabled.get() != false;
            String string = selectedCategory = categoriesEnabled && this.editor.categories != null ? (String)this.editor.categories.getCurrentFirst() : null;
            if (selectedCategory == null || selectedCategory.isEmpty()) {
                String current = (String)this.editor.groups.getCurrentFirst();
                return current == null ? Collections.emptyList() : Collections.singletonList(current);
            }
            return this.editor.boneCategories.getBones(this.editor.group, selectedCategory);
        }

        @Override
        public void setT(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)(x - (double)transform.translate.x);
            float dy = (float)(y - (double)transform.translate.y);
            float dz = (float)(z - (double)transform.translate.z);
            for (String key : this.targets()) {
                PoseTransform t = this.editor.pose.get(key);
                if (t == null) continue;
                t.translate.x += dx;
                t.translate.y += dy;
                t.translate.z += dz;
            }
        }

        @Override
        public void setS(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)(x - (double)transform.scale.x);
            float dy = (float)(y - (double)transform.scale.y);
            float dz = (float)(z - (double)transform.scale.z);
            for (String key : this.targets()) {
                PoseTransform t = this.editor.pose.get(key);
                if (t == null) continue;
                t.scale.x += dx;
                t.scale.y += dy;
                t.scale.z += dz;
            }
        }

        @Override
        public void setR(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = MathUtils.toRad((float)x) - transform.rotate.x;
            float dy = MathUtils.toRad((float)y) - transform.rotate.y;
            float dz = MathUtils.toRad((float)z) - transform.rotate.z;
            for (String key : this.targets()) {
                PoseTransform t = this.editor.pose.get(key);
                if (t == null) continue;
                t.rotate.x += dx;
                t.rotate.y += dy;
                t.rotate.z += dz;
            }
        }

        @Override
        public void setR2(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = MathUtils.toRad((float)x) - transform.rotate2.x;
            float dy = MathUtils.toRad((float)y) - transform.rotate2.y;
            float dz = MathUtils.toRad((float)z) - transform.rotate2.z;
            for (String key : this.targets()) {
                PoseTransform t = this.editor.pose.get(key);
                if (t == null) continue;
                t.rotate2.x += dx;
                t.rotate2.y += dy;
                t.rotate2.z += dz;
            }
        }

        @Override
        public void setP(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)x - transform.pivot.x;
            float dy = (float)y - transform.pivot.y;
            float dz = (float)z - transform.pivot.z;
            for (String key : this.targets()) {
                PoseTransform t = this.editor.pose.get(key);
                if (t == null) continue;
                t.pivot.x += dx;
                t.pivot.y += dy;
                t.pivot.z += dz;
            }
        }
    }
}

