/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.vox;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.audio.BinaryReader;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.vox.VoxDocument;
import mchorse.bbs_mod.vox.data.Vox;
import mchorse.bbs_mod.vox.data.VoxChunk;
import mchorse.bbs_mod.vox.data.VoxGroup;
import mchorse.bbs_mod.vox.data.VoxLayer;
import mchorse.bbs_mod.vox.data.VoxShape;
import mchorse.bbs_mod.vox.data.VoxTransform;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VoxReader
extends BinaryReader {
    public static int[] DEFAULT_PALETTE = new int[]{0, -1, -3342337, -6684673, -10027009, -13369345, -16711681, -13057, -3355393, -6697729, -10040065, -13382401, -16724737, -26113, -3368449, -6710785, -10053121, -13395457, -16737793, -39169, -3381505, -6723841, -10066177, -13408513, -16750849, -52225, -3394561, -6736897, -10079233, -13421569, -16763905, -65281, -3407617, -6749953, -10092289, -13434625, -16776961, -52, -3342388, -6684724, -10027060, -13369396, -16711732, -13108, -3355444, -6697780, -10040116, -13382452, -16724788, -26164, -3368500, -6710836, -10053172, -13395508, -16737844, -39220, -3381556, -6723892, -10066228, -13408564, -16750900, -52276, -3394612, -6736948, -10079284, -13421620, -16763956, -65332, -3407668, -6750004, -10092340, -13434676, -16777012, -103, -3342439, -6684775, -10027111, -13369447, -16711783, -13159, -3355495, -6697831, -10040167, -13382503, -16724839, -26215, -3368551, -6710887, -10053223, -13395559, -16737895, -39271, -3381607, -6723943, -10066279, -13408615, -16750951, -52327, -3394663, -6736999, -10079335, -13421671, -16764007, -65383, -3407719, -6750055, -10092391, -13434727, -16777063, -154, -3342490, -6684826, -10027162, -13369498, -16711834, -13210, -3355546, -6697882, -10040218, -13382554, -16724890, -26266, -3368602, -6710938, -10053274, -13395610, -16737946, -39322, -3381658, -6723994, -10066330, -13408666, -16751002, -52378, -3394714, -6737050, -10079386, -13421722, -16764058, -65434, -3407770, -6750106, -10092442, -13434778, -16777114, -205, -3342541, -6684877, -10027213, -13369549, -16711885, -13261, -3355597, -6697933, -10040269, -13382605, -16724941, -26317, -3368653, -6710989, -10053325, -13395661, -16737997, -39373, -3381709, -6724045, -10066381, -13408717, -16751053, -52429, -3394765, -6737101, -10079437, -13421773, -16764109, -65485, -3407821, -6750157, -10092493, -13434829, -16777165, -256, -3342592, -6684928, -10027264, -13369600, -16711936, -13312, -3355648, -6697984, -10040320, -13382656, -16724992, -26368, -3368704, -6711040, -10053376, -13395712, -16738048, -39424, -3381760, -6724096, -10066432, -13408768, -16751104, -52480, -3394816, -6737152, -10079488, -13421824, -16764160, -65536, -3407872, -6750208, -10092544, -13434880, -16776978, -16776995, -16777029, -16777046, -16777080, -16777097, -16777131, -16777148, -16777182, -16777199, -16716288, -16720640, -16729344, -16733696, -16742400, -16746752, -16755456, -16759808, -16768512, -16772864, -1179648, -2293760, -4521984, -5636096, -7864320, -8978432, -11206656, -12320768, -14548992, -15663104, -1118482, -2236963, -4473925, -5592406, -7829368, -8947849, -11184811, -12303292, -14540254, -15658735};
    private byte[] buf = new byte[4];

    public VoxDocument read(InputStream stream, Link link) throws Exception {
        if (this.readInt(stream) != this.fourChars("VOX ")) {
            throw new Exception("Not a 'VOX ' file!");
        }
        int version = this.readInt(stream);
        if (version != 150) {
            System.err.println("Version of given \"" + String.valueOf(link) + "\" VOX model is " + version + " (150 was expected). If model works, ignore this warning.");
            System.err.println("Otherwise, it's most likely due to different version of MagicaVoxel. Try using MagicaVoxel 0.99.6.3!");
        }
        VoxChunk main = this.readChunk(stream);
        if (!main.id.equals("MAIN")) {
            throw new Exception("The first chunk isn't main!");
        }
        VoxDocument document = new VoxDocument();
        Vox vox = null;
        block2: while (true) {
            VoxChunk chunk;
            try {
                chunk = this.readChunk(stream);
            }
            catch (Exception e) {
                break;
            }
            if (chunk.id.equals("SIZE")) {
                vox = new Vox();
                vox.w = this.readInt(stream);
                vox.d = this.readInt(stream);
                vox.h = this.readInt(stream);
                continue;
            }
            if (chunk.id.equals("XYZI")) {
                vox.voxels = new int[vox.w * vox.d * vox.h];
                for (int voxels = this.readInt(stream); voxels > 0; --voxels) {
                    stream.read(this.buf);
                    int x = vox.w - 1 - (this.buf[0] & 0xFF);
                    int y = this.buf[2] & 0xFF;
                    int z = this.buf[1] & 0xFF;
                    int block = this.buf[3] & 0xFF;
                    vox.set(x, y, z, block);
                }
                document.chunks.add(vox);
                continue;
            }
            if (chunk.id.equals("nTRN")) {
                document.nodes.add(new VoxTransform(stream, this));
                continue;
            }
            if (chunk.id.equals("nGRP")) {
                document.nodes.add(new VoxGroup(stream, this));
                continue;
            }
            if (chunk.id.equals("nSHP")) {
                document.nodes.add(new VoxShape(stream, this));
                continue;
            }
            if (chunk.id.equals("LAYR")) {
                document.layers.add(new VoxLayer(stream, this));
                continue;
            }
            if (chunk.id.equals("RGBA")) {
                document.palette = new int[256];
                int i = 0;
                while (true) {
                    if (i > 254) continue block2;
                    int color = this.readInt(stream);
                    int newColor = (color >> 24 & 0xFF) << 24;
                    newColor += (color >> 0 & 0xFF) << 16;
                    newColor += (color >> 8 & 0xFF) << 8;
                    document.palette[i + 1] = newColor += (color >> 16 & 0xFF) << 0;
                    ++i;
                }
            }
            stream.skip(chunk.size);
        }
        stream.close();
        return document;
    }

    public VoxChunk readChunk(InputStream stream) throws Exception {
        return new VoxChunk(this.readFourString(stream), this.readInt(stream), this.readInt(stream));
    }

    public String readString(InputStream stream) throws Exception {
        int size = this.readInt(stream);
        byte[] bytes = new byte[size];
        if (stream.read(bytes) == size) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        throw new IOException("Not enough bytes for the string!");
    }

    public Map<String, String> readDictionary(InputStream stream) throws Exception {
        HashMap<String, String> dict = new HashMap<String, String>();
        int keys = this.readInt(stream);
        for (int i = 0; i < keys; ++i) {
            dict.put(this.readString(stream), this.readString(stream));
        }
        return dict;
    }

    public Matrix3f readRotation(int rotation) {
        Matrix3f matrix = new Matrix3f();
        int firstIndex = rotation & 3;
        int secondIndex = (rotation & 0xC) >> 2;
        int[] array = new int[]{-1, -1, -1};
        int index = 0;
        array[firstIndex] = 0;
        array[secondIndex] = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != -1) continue;
            index = i;
            break;
        }
        int thirdIndex = index;
        boolean negativeFirst = (rotation & 0x10) >> 4 == 1;
        boolean negativeSecond = (rotation & 0x20) >> 5 == 1;
        boolean negativeThird = (rotation & 0x40) >> 6 == 1;
        Vector3f v = new Vector3f();
        matrix.setRow(0, (Vector3fc)v.set(0.0f, 0.0f, 0.0f).setComponent(firstIndex, negativeFirst ? -1.0f : 1.0f));
        matrix.setRow(1, (Vector3fc)v.set(0.0f, 0.0f, 0.0f).setComponent(secondIndex, negativeSecond ? -1.0f : 1.0f));
        matrix.setRow(2, (Vector3fc)v.set(0.0f, 0.0f, 0.0f).setComponent(thirdIndex, negativeThird ? -1.0f : 1.0f));
        return matrix;
    }
}

