/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.fabric;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.litetex.capes.config.CustomProviderConfig;
import net.litetex.capes.provider.ModMetadataProvider;
import net.litetex.capes.provider.suppliers.ModMetadataProviderSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricModMetadataProviderSupplier
implements ModMetadataProviderSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(FabricModMetadataProviderSupplier.class);

    @Override
    public Stream<ModMetadataProvider> get() {
        return FabricLoader.getInstance().getAllMods().stream().filter(mc -> mc.getMetadata().containsCustomValue("cape")).map(mc -> {
            try {
                return this.createCustomProviderConfig((ModContainer)mc);
            }
            catch (Exception e) {
                LOG.warn("Failed to load from {}", (Object)mc.getMetadata().getId(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).map(ModMetadataProvider::new);
    }

    protected CustomProviderConfig createCustomProviderConfig(ModContainer mc) {
        ModMetadata metadata = mc.getMetadata();
        String id = "mod-" + metadata.getId();
        String name = metadata.getName() + " (Mod)";
        CustomValue cape = metadata.getCustomValue("cape");
        if (cape.getType() == CustomValue.CvType.STRING) {
            return new CustomProviderConfig(id, name, cape.getAsString());
        }
        if (cape.getType() != CustomValue.CvType.OBJECT) {
            return null;
        }
        CustomValue.CvObject capeObject = cape.getAsObject();
        String url = Stream.of("url", "uriTemplate").map(arg_0 -> ((CustomValue.CvObject)capeObject).get(arg_0)).findFirst().map(CustomValue::getAsString).orElse(null);
        if (url == null) {
            return null;
        }
        return new CustomProviderConfig(id, name, url, false, null, Optional.ofNullable(capeObject.get("changeCapeUrl")).map(CustomValue::getAsString).orElse(null), Optional.of(capeObject.get("homepage")).map(CustomValue::getAsString).orElseGet(() -> {
            ContactInformation contact = metadata.getContact();
            return contact.get("homepage").or(() -> contact.get("sources")).or(() -> contact.get("issues")).orElse(null);
        }), null, Optional.ofNullable(capeObject.get("rateLimitedReqPerSec")).map(CustomValue::getAsNumber).map(Number::doubleValue).orElse(null));
    }
}

