/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.handler.textures;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.litetex.capes.handler.AnimatedNativeImageContainer;
import net.litetex.capes.handler.textures.TextureResolver;
import net.minecraft.class_1011;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnimatedGIFTextureResolver
implements TextureResolver {
    public static final String ID = "gif";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean animated() {
        return true;
    }

    @Override
    public TextureResolver.ResolvedTextureData resolve(byte[] imageData, boolean shouldOnlyResolveFirstFrame) throws IOException {
        ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
        try {
            TextureResolver.AnimatedResolvedTextureData animatedResolvedTextureData;
            block10: {
                ImageInputStream in = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));
                try {
                    reader.setInput(in);
                    int numImages = reader.getNumImages(true);
                    if (shouldOnlyResolveFirstFrame) {
                        numImages = Math.min(1, numImages);
                    }
                    MetadataInfo metadataInfo = this.resolveMetaDataInfo(reader.getStreamMetadata());
                    List<ImageFrame> imageFrames = this.resolveFrames(reader, metadataInfo, numImages);
                    boolean hasElytra = imageFrames.stream().findFirst().map(ImageFrame::image).map(img -> Math.floorDiv(img.getWidth(), img.getHeight()) == 2).orElse(false);
                    animatedResolvedTextureData = new TextureResolver.AnimatedResolvedTextureData(imageFrames.stream().map(imageFrame -> {
                        BufferedImage image = imageFrame.image();
                        int width = image.getWidth();
                        int height = image.getHeight();
                        class_1011 frame = new class_1011(width, height, true);
                        for (int x = 0; x < width; ++x) {
                            for (int y = 0; y < height; ++y) {
                                frame.method_61941(x, y, image.getRGB(x, y));
                            }
                        }
                        return new AnimatedNativeImageContainer(frame, imageFrame.delay() * 10);
                    }).toList(), hasElytra);
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return animatedResolvedTextureData;
        }
        finally {
            reader.dispose();
        }
    }

    protected MetadataInfo resolveMetaDataInfo(IIOMetadata metadata) {
        IIOMetadataNode colorTable;
        NodeList globalColorTable;
        IIOMetadataNode screenDescriptor;
        if (metadata == null) {
            return new MetadataInfo(-1, -1, null);
        }
        int width = -1;
        int height = -1;
        Color backgroundColor = null;
        IIOMetadataNode globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
        NodeList globalScreeDescriptor = globalRoot.getElementsByTagName("LogicalScreenDescriptor");
        if (globalScreeDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreeDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        if ((globalColorTable = globalRoot.getElementsByTagName("GlobalColorTable")).getLength() > 0 && (colorTable = (IIOMetadataNode)globalColorTable.item(0)) != null) {
            String bgIndex = colorTable.getAttribute("backgroundColorIndex");
            IIOMetadataNode colorEntry = (IIOMetadataNode)colorTable.getFirstChild();
            for (int safeGuard = 0; colorEntry != null && safeGuard < 1000000; colorEntry = (IIOMetadataNode)colorEntry.getNextSibling(), ++safeGuard) {
                if (!colorEntry.getAttribute("index").equals(bgIndex)) continue;
                int red = Integer.parseInt(colorEntry.getAttribute("red"));
                int green = Integer.parseInt(colorEntry.getAttribute("green"));
                int blue = Integer.parseInt(colorEntry.getAttribute("blue"));
                backgroundColor = new Color(red, green, blue);
                break;
            }
        }
        return new MetadataInfo(width, height, backgroundColor);
    }

    protected List<ImageFrame> resolveFrames(ImageReader reader, MetadataInfo metadataInfo, int numImages) throws IOException {
        int logicalScreenWidth = metadataInfo.logicalScreenWidth();
        int logicalScreenHeight = metadataInfo.logicalScreenHeight();
        BufferedImage baseImage = null;
        ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(numImages);
        for (int frameIndex = 0; frameIndex < numImages; ++frameIndex) {
            BufferedImage image = reader.read(frameIndex);
            int width = image.getWidth();
            int height = image.getHeight();
            int maxWidth = Math.min(width, logicalScreenWidth);
            int maxHeight = Math.min(height, logicalScreenHeight);
            if (baseImage == null) {
                baseImage = new BufferedImage(logicalScreenWidth, logicalScreenHeight, 2);
            }
            FrameMetaData frameMetaData = this.resolveFrameMetaData(reader, frameIndex);
            int imageX = frameMetaData.x();
            int imageY = frameMetaData.y();
            Rectangle area = new Rectangle(imageX, imageY, maxWidth, maxHeight);
            BufferedImage backup = new BufferedImage(maxWidth, maxHeight, 2);
            backup.setData(baseImage.getData(area));
            Graphics2D g = baseImage.createGraphics();
            g.drawImage((Image)image, imageX, imageY, null);
            BufferedImage clone = new BufferedImage(logicalScreenWidth, logicalScreenHeight, 2);
            clone.setData(baseImage.getData());
            if ("restoreToBackgroundColor".equals(frameMetaData.disposal())) {
                oldComposite = g.getComposite();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(imageX, imageY, width, height);
                g.setComposite(oldComposite);
            } else if ("restoreToPrevious".equals(frameMetaData.disposal())) {
                oldComposite = g.getComposite();
                g.setComposite(AlphaComposite.Src);
                g.drawImage((Image)backup, imageX, imageY, null);
                g.setComposite(oldComposite);
            }
            g.dispose();
            frames.add(new ImageFrame(clone, frameMetaData.delay()));
        }
        return frames;
    }

    protected FrameMetaData resolveFrameMetaData(ImageReader reader, int frameIndex) throws IOException {
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
        NodeList children = root.getChildNodes();
        int delay = Integer.parseInt(gce.getAttribute("delayTime"));
        String disposal = gce.getAttribute("disposalMethod");
        int x = 0;
        int y = 0;
        for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
            Node nodeItem = children.item(nodeIndex);
            if (!"ImageDescriptor".equals(nodeItem.getNodeName())) continue;
            NamedNodeMap map = nodeItem.getAttributes();
            x = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
            y = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
        }
        return new FrameMetaData(x, y, delay, disposal);
    }

    protected record MetadataInfo(int logicalScreenWidth, int logicalScreenHeight, Color backgroundColor) {
    }

    protected record FrameMetaData(int x, int y, int delay, String disposal) {
    }

    protected record ImageFrame(BufferedImage image, int delay) {
    }
}

