/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.minecraft.class_310;

public class WynntilsProvider
implements CapeProvider {
    @Override
    public String id() {
        return "wynntils";
    }

    @Override
    public String name() {
        return "Wynntils";
    }

    @Override
    public String getBaseUrl(GameProfile profile) {
        return "https://athena.wynntils.com/user/getInfo";
    }

    @Override
    public ResolvedTextureInfo resolveTexture(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, GameProfile profile) throws IOException, InterruptedException {
        try (HttpClient client = clientBuilder.build();){
            JsonObject body = new JsonObject();
            body.addProperty("uuid", profile.id().toString());
            HttpRequest request = requestBuilder.header("User-Agent", "Wynntils Artemis\\3.3.0+MC-1.21.4 (client) FABRIC").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body.toString())).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            record WynntilsResponseData(String texture) {
            }
            WynntilsResponseData responseData = (WynntilsResponseData)new Gson().fromJson((JsonElement)JsonParser.parseString((String)response.body()).getAsJsonObject().getAsJsonObject("user").getAsJsonObject("cosmetics"), WynntilsResponseData.class);
            if (responseData == null) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            ResolvedTextureInfo.Base64TextureInfo base64TextureInfo = new ResolvedTextureInfo.Base64TextureInfo(responseData.texture());
            return base64TextureInfo;
        }
    }

    @Override
    public boolean hasChangeCapeUrl() {
        return true;
    }

    @Override
    public String changeCapeUrl(class_310 client) {
        return "https://account.wynntils.com";
    }

    @Override
    public String homepageUrl() {
        return "https://wynntils.com";
    }

    @Override
    public double rateLimitedReqPerSec() {
        return 4.0;
    }
}

