/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider.ratelimit;

import com.google.common.util.concurrent.RateLimiter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.litetex.capes.provider.CapeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapeProviderRateLimits {
    private static final Logger LOG = LoggerFactory.getLogger(CapeProviderRateLimits.class);
    private final Map<CapeProvider, Optional<RateLimiter>> limiters = Collections.synchronizedMap(new HashMap());

    public void waitForRateLimit(CapeProvider capeProvider) {
        this.limiters.computeIfAbsent(capeProvider, cp -> cp.rateLimitedReqPerSec() > 0.0 ? Optional.of(RateLimiter.create((double)cp.rateLimitedReqPerSec(), (Duration)Duration.ofSeconds(1L))) : Optional.empty()).ifPresent(rateLimiter -> {
            double waitedSec = rateLimiter.acquire();
            if (waitedSec > 0.0) {
                LOG.debug("{} waited for {}ms", (Object)capeProvider.id(), (Object)((int)(waitedSec * 1000.0)));
            }
        });
    }
}

