/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.handler;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.litetex.capes.Capes;
import net.litetex.capes.config.AnimatedCapesHandling;
import net.litetex.capes.handler.AnimatedNativeImageContainer;
import net.litetex.capes.handler.TextureProvider;
import net.litetex.capes.handler.textures.DefaultTextureResolver;
import net.litetex.capes.handler.textures.TextureResolver;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.litetex.capes.util.CapeProviderTextureAsset;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerCapeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerCapeHandler.class);
    private final Capes capes;
    private final GameProfile profile;
    private Optional<TextureProvider> optTextureProvider = Optional.empty();
    private boolean hasElytraTexture = true;

    public PlayerCapeHandler(Capes capes, GameProfile profile) {
        this.capes = capes;
        this.profile = profile;
    }

    public Optional<TextureProvider> capeTextureProvider() {
        return this.optTextureProvider;
    }

    public class_12079.class_12081 getCape() {
        TextureProvider textureProvider = this.optTextureProvider.orElse(null);
        if (textureProvider != null) {
            return textureProvider.texture();
        }
        return null;
    }

    public void resetCape() {
        this.optTextureProvider = Optional.empty();
        this.hasElytraTexture = true;
    }

    public boolean trySetCape(CapeProvider capeProvider) {
        String url = capeProvider.getBaseUrl(this.profile);
        if (url == null) {
            return false;
        }
        try {
            HttpClient.Builder clientBuilder = this.createBuilder();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(10L)).header("User-Agent", "CP");
            ResolvedTextureInfo resolvedTextureInfo = capeProvider.resolveTexture(clientBuilder, requestBuilder, this.profile);
            if (resolvedTextureInfo == null || resolvedTextureInfo.imageBytes() == null) {
                return false;
            }
            if (this.isCapeBlocked(capeProvider, resolvedTextureInfo.imageBytes())) {
                return false;
            }
            TextureResolver textureResolver = this.capes.getAllTextureResolvers().getOrDefault(resolvedTextureInfo.textureResolverId(), DefaultTextureResolver.INSTANCE);
            AnimatedCapesHandling animatedCapesHandling = this.animatedCapesHandling();
            if (textureResolver.animated() && animatedCapesHandling == AnimatedCapesHandling.OFF) {
                return false;
            }
            this.optTextureProvider = this.registerTexturesAndGetProvider(this.determineTexturesToRegister(textureResolver, resolvedTextureInfo.imageBytes(), animatedCapesHandling == AnimatedCapesHandling.FROZEN, url));
            return this.optTextureProvider.isPresent();
        }
        catch (InterruptedException iex) {
            LOG.warn("Got interrupted[url='{}',profileId='{}']", new Object[]{url, this.profile.id(), iex});
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            LOG.warn("Failed to process texture[url='{}',profileId='{}']", new Object[]{url, this.profile.id(), ex});
        }
        this.resetCape();
        return false;
    }

    private HttpClient.Builder createBuilder() {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L));
        final Proxy proxy = class_310.method_1551().method_1487();
        if (proxy != null) {
            clientBuilder.proxy(new ProxySelector(this){

                @Override
                public List<Proxy> select(URI uri) {
                    return List.of(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
        }
        return clientBuilder;
    }

    private boolean isCapeBlocked(CapeProvider provider, byte[] imageBytes) {
        Set<Integer> blockedCapeHashes = this.capes.blockedProviderCapeHashes().get(provider);
        if (blockedCapeHashes == null) {
            return false;
        }
        return blockedCapeHashes.contains(Arrays.hashCode(imageBytes));
    }

    private List<TextureToRegister> determineTexturesToRegister(TextureResolver textureResolver, byte[] imageData, boolean freezeAnimation, String url) throws IOException {
        TextureResolver.ResolvedTextureData resolved = textureResolver.resolve(imageData, freezeAnimation);
        boolean bl = this.hasElytraTexture = !Boolean.FALSE.equals(resolved.hasElytra());
        if (resolved instanceof TextureResolver.DefaultResolvedTextureData) {
            TextureResolver.DefaultResolvedTextureData defaultResolvedTextureData = (TextureResolver.DefaultResolvedTextureData)resolved;
            return List.of(new TextureToRegister(PlayerCapeHandler.identifier(this.uuid().toString()), defaultResolvedTextureData.texture()));
        }
        if (resolved instanceof TextureResolver.AnimatedResolvedTextureData) {
            TextureResolver.AnimatedResolvedTextureData animatedResolvedTextureData = (TextureResolver.AnimatedResolvedTextureData)resolved;
            List<AnimatedNativeImageContainer> textures = animatedResolvedTextureData.textures();
            Stream animatedTextureStream = textures.stream();
            if (textures.isEmpty()) {
                LOG.warn("Received animated texture with no frames[url='{}',profileId='{}']", (Object)url, (Object)this.uuid());
                return List.of();
            }
            if (freezeAnimation) {
                animatedTextureStream = animatedTextureStream.limit(1L);
            }
            AtomicInteger counter = new AtomicInteger(0);
            return animatedTextureStream.map(c -> new TextureToRegister(PlayerCapeHandler.identifier(String.valueOf(this.uuid()) + (String)(!freezeAnimation ? "/" + counter.getAndIncrement() : "")), c.image(), c.delayMs())).toList();
        }
        throw new IllegalStateException("Unexpected ResolvedTextureData: " + resolved.getClass().getSimpleName());
    }

    private Optional<TextureProvider> registerTexturesAndGetProvider(List<TextureToRegister> texturesToRegister) {
        if (texturesToRegister.isEmpty()) {
            return Optional.empty();
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        CompletableFuture.runAsync(() -> texturesToRegister.forEach(t -> textureManager.method_4616(t.identifier(), (class_1044)new class_1043(() -> ((class_2960)t.identifier()).toString(), t.image()))), (Executor)class_310.method_1551()).exceptionally(ex -> {
            LOG.warn("Failed to register textures", ex);
            return null;
        });
        return Optional.of(texturesToRegister.size() == 1 ? new DefaultTextureProvider(texturesToRegister.getFirst().identifier()) : new AnimatedTextureProvider(texturesToRegister));
    }

    private AnimatedCapesHandling animatedCapesHandling() {
        return this.capes.config().getAnimatedCapesHandling();
    }

    static class_2960 identifier(String id) {
        return class_2960.method_60655((String)"cape-provider", (String)id);
    }

    public UUID uuid() {
        return this.profile.id();
    }

    public boolean hasElytraTexture() {
        return this.hasElytraTexture;
    }

    record TextureToRegister(class_2960 identifier, class_1011 image, int delayMs) {
        public TextureToRegister(class_2960 identifier, class_1011 image) {
            this(identifier, image, 100);
        }
    }

    static final class DefaultTextureProvider
    extends Record
    implements TextureProvider {
        private final CapeProviderTextureAsset texture;

        DefaultTextureProvider(class_2960 id) {
            this(new CapeProviderTextureAsset(id));
        }

        DefaultTextureProvider(CapeProviderTextureAsset texture) {
            this.texture = texture;
        }

        @Override
        public boolean dynamicIdentifier() {
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DefaultTextureProvider.class, "texture", "texture"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DefaultTextureProvider.class, "texture", "texture"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DefaultTextureProvider.class, "texture", "texture"}, this, o);
        }

        @Override
        public CapeProviderTextureAsset texture() {
            return this.texture;
        }
    }

    static class AnimatedTextureProvider
    implements TextureProvider {
        private final List<IdentifierContainer> identifiers;
        private int lastFrameIndex;
        private long nextFrameTime;

        AnimatedTextureProvider(Collection<TextureToRegister> identifiers) {
            this.identifiers = identifiers.stream().map(t -> new IdentifierContainer(new CapeProviderTextureAsset(t.identifier()), Math.clamp((long)t.delayMs(), 1, 60000))).toList();
        }

        @Override
        public class_12079.class_12081 texture() {
            long time = System.currentTimeMillis();
            if (time > this.nextFrameTime) {
                int thisFrameIndex;
                this.lastFrameIndex = thisFrameIndex = (this.lastFrameIndex + 1) % this.identifiers.size();
                IdentifierContainer ic = this.identifiers.get(thisFrameIndex);
                this.nextFrameTime = time + (long)ic.delay();
                return ic.identifier();
            }
            return this.identifiers.get(this.lastFrameIndex).identifier();
        }

        @Override
        public boolean dynamicIdentifier() {
            return true;
        }

        record IdentifierContainer(class_12079.class_12081 identifier, int delay) {
        }
    }
}

