/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.litetex.capes.provider.antifeature.AntiFeature;
import net.litetex.capes.provider.antifeature.AntiFeatures;
import net.minecraft.class_310;

public class CosmeticaProvider
implements CapeProvider {
    private static final String BASE64_PREFIX = "data:image/png;base64,";

    @Override
    public String id() {
        return "cosmetica";
    }

    @Override
    public String name() {
        return "Cosmetica";
    }

    @Override
    public String getBaseUrl(GameProfile profile) {
        return "https://api.cosmetica.cc/v2/get/info?uuid=" + profile.id().toString() + "&nothirdparty&excludemodels";
    }

    @Override
    public ResolvedTextureInfo resolveTexture(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, GameProfile profile) throws IOException, InterruptedException {
        requestBuilder.setHeader("Accept", "application/json");
        try (HttpClient client = clientBuilder.build();){
            HttpResponse<String> response = client.send(requestBuilder.GET().build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            record ResponseData(CapeData cape) {
                private final CapeData cape;

                ResponseData {
                    record CapeData(String image) {
                    }
                }

                public CapeData cape() {
                    return this.cape;
                }
            }
            ResponseData responseData = (ResponseData)new Gson().fromJson(response.body(), ResponseData.class);
            if (responseData == null || responseData.cape() == null || responseData.cape().image() == null || !responseData.cape().image().startsWith(BASE64_PREFIX)) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            ResolvedTextureInfo.Base64TextureInfo base64TextureInfo = new ResolvedTextureInfo.Base64TextureInfo(responseData.cape().image().substring(BASE64_PREFIX.length()));
            return base64TextureInfo;
        }
    }

    @Override
    public boolean hasChangeCapeUrl() {
        return true;
    }

    @Override
    public String changeCapeUrl(class_310 client) {
        return "https://login.cosmetica.cc";
    }

    @Override
    public String homepageUrl() {
        return "https://cosmetica.cc/";
    }

    @Override
    public List<AntiFeature> antiFeatures() {
        return List.of(AntiFeatures.ABANDONED, AntiFeatures.BAD_CONNECTION);
    }

    @Override
    public double rateLimitedReqPerSec() {
        return 10.0;
    }
}

