/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.util.collections;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DiscardingQueue<E>
extends LinkedBlockingQueue<E> {
    private final Consumer<E> onDiscarded;

    public DiscardingQueue(int capacity, Consumer<E> onDiscarded) {
        super(capacity);
        this.onDiscarded = onDiscarded;
    }

    @Override
    public boolean offer(@NotNull E e) {
        Object discarded;
        if (this.remainingCapacity() == 0 && (discarded = this.poll()) != null) {
            this.onDiscarded.accept(discarded);
        }
        return super.offer(e);
    }
}

