/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.config;

import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.litetex.capes.config.AnimatedCapesHandling;
import net.litetex.capes.config.CustomProviderConfig;
import net.litetex.capes.config.ModProviderHandling;

public class Config {
    private String currentPreviewProviderId;
    private Set<String> activeProviderIds;
    private boolean useDefaultProvider = true;
    private boolean onlyLoadForSelf;
    private boolean enableElytraTexture;
    private AnimatedCapesHandling animatedCapesHandling = AnimatedCapesHandling.ON;
    private List<CustomProviderConfig> customProviders = List.of();
    private ModProviderHandling modProviderHandling = ModProviderHandling.ON;
    private Map<String, Instant> knownModProviderIdsFirstTimeMissing;
    private Boolean validateProfile;
    private Integer loadThrottleSuppressSec;
    private Map<String, Set<Integer>> blockedProviderCapeHashes;
    private Integer loadThreads;
    private Integer playerCacheSize;
    private Boolean useRealPlayerOnlineValidation;

    public void reset() {
        this.setCurrentPreviewProviderId(null);
        this.setActiveProviderIds(List.of("minecraftcapes", "optifine"));
        this.setUseDefaultProvider(true);
        this.setOnlyLoadForSelf(false);
        this.setEnableElytraTexture(true);
        this.setAnimatedCapesHandling(AnimatedCapesHandling.ON);
        this.setModProviderHandling(ModProviderHandling.ON);
        this.setKnownModProviderIdsFirstTimeMissing(null);
        this.setValidateProfile(null);
        this.setLoadThrottleSuppressSec(null);
        this.setBlockedProviderCapeHashes(null);
        this.setLoadThreads(null);
        this.setPlayerCacheSize(null);
        this.setUseRealPlayerOnlineValidation(null);
    }

    public static Config createDefault() {
        Config config = new Config();
        config.reset();
        return config;
    }

    public String getCurrentPreviewProviderId() {
        return this.currentPreviewProviderId;
    }

    public void setCurrentPreviewProviderId(String currentPreviewProviderId) {
        this.currentPreviewProviderId = currentPreviewProviderId;
    }

    public Set<String> getActiveProviderIds() {
        return this.activeProviderIds;
    }

    public void setActiveProviderIds(Collection<String> activeProviderIds) {
        this.activeProviderIds = new LinkedHashSet<String>(Objects.requireNonNull(activeProviderIds));
    }

    public boolean isUseDefaultProvider() {
        return this.useDefaultProvider;
    }

    public void setUseDefaultProvider(boolean useDefaultProvider) {
        this.useDefaultProvider = useDefaultProvider;
    }

    public boolean isOnlyLoadForSelf() {
        return this.onlyLoadForSelf;
    }

    public void setOnlyLoadForSelf(boolean onlyLoadForSelf) {
        this.onlyLoadForSelf = onlyLoadForSelf;
    }

    public boolean isEnableElytraTexture() {
        return this.enableElytraTexture;
    }

    public void setEnableElytraTexture(boolean enableElytraTexture) {
        this.enableElytraTexture = enableElytraTexture;
    }

    public AnimatedCapesHandling getAnimatedCapesHandling() {
        return this.animatedCapesHandling;
    }

    public void setAnimatedCapesHandling(AnimatedCapesHandling animatedCapesHandling) {
        this.animatedCapesHandling = animatedCapesHandling;
    }

    public List<CustomProviderConfig> getCustomProviders() {
        return this.customProviders;
    }

    public void setCustomProviders(List<CustomProviderConfig> customProviders) {
        this.customProviders = customProviders;
    }

    public ModProviderHandling getModProviderHandling() {
        return this.modProviderHandling;
    }

    public void setModProviderHandling(ModProviderHandling modProviderHandling) {
        this.modProviderHandling = modProviderHandling;
    }

    public Map<String, Instant> getKnownModProviderIdsFirstTimeMissing() {
        return this.knownModProviderIdsFirstTimeMissing;
    }

    public void setKnownModProviderIdsFirstTimeMissing(Map<String, Instant> knownModProviderIdsFirstTimeMissing) {
        this.knownModProviderIdsFirstTimeMissing = knownModProviderIdsFirstTimeMissing;
    }

    public Boolean isValidateProfile() {
        return this.validateProfile;
    }

    public void setValidateProfile(Boolean validateProfile) {
        this.validateProfile = validateProfile;
    }

    public Integer getLoadThrottleSuppressSec() {
        return this.loadThrottleSuppressSec;
    }

    public void setLoadThrottleSuppressSec(Integer loadThrottleSuppressSec) {
        this.loadThrottleSuppressSec = loadThrottleSuppressSec;
    }

    public Map<String, Set<Integer>> getBlockedProviderCapeHashes() {
        return this.blockedProviderCapeHashes;
    }

    public void setBlockedProviderCapeHashes(Map<String, Set<Integer>> blockedProviderCapeHashes) {
        this.blockedProviderCapeHashes = blockedProviderCapeHashes;
    }

    public Integer getLoadThreads() {
        return this.loadThreads;
    }

    public void setLoadThreads(Integer loadThreads) {
        this.loadThreads = loadThreads;
    }

    public Integer getPlayerCacheSize() {
        return this.playerCacheSize;
    }

    public void setPlayerCacheSize(Integer playerCacheSize) {
        this.playerCacheSize = playerCacheSize;
    }

    public Boolean getUseRealPlayerOnlineValidation() {
        return this.useRealPlayerOnlineValidation;
    }

    public void setUseRealPlayerOnlineValidation(Boolean useRealPlayerOnlineValidation) {
        this.useRealPlayerOnlineValidation = useRealPlayerOnlineValidation;
    }
}

