package net.litetex.capes.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.resources.ResourceLocation;


@Mixin(CapeLayer.class)
public abstract class CapeFeatureRendererMixin
{
	@Redirect(method = "submit*", at = @At(value = "INVOKE",
		target = "Lnet/minecraft/client/renderer/RenderType;entitySolid(Lnet/minecraft/resources/ResourceLocation;)"
			+ "Lnet/minecraft/client/renderer/RenderType;"))
	private RenderType fixCapeTransparency(final ResourceLocation texture)
	{
		return RenderType.armorCutoutNoCull(texture);
	}
}
