/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

public interface ResolvedTextureInfo {
    public byte[] imageBytes();

    @Nullable
    public String textureResolverId();

    public record Base64TextureInfo(String base64Texture, String textureResolverId) implements ResolvedTextureInfo
    {
        public Base64TextureInfo(String base64Texture) {
            this(base64Texture, null);
        }

        @Override
        public byte[] imageBytes() {
            if (this.base64Texture == null || this.base64Texture.isEmpty()) {
                return null;
            }
            try {
                return Base64.decodeBase64((String)this.base64Texture);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public record ByteArrayTextureInfo(byte[] imageBytes, String textureResolverId) implements ResolvedTextureInfo
    {
        public ByteArrayTextureInfo(byte[] imageBytes) {
            this(imageBytes, null);
        }
    }
}

