/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.debugutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugUtils {
    public static final String MODID = "debugutils";
    public static final Logger LOGGER = LogManager.getLogger((String)"debugutils");

    public static <T> T getPlatformInstance(Class<T> abstractClss, String ... impls) {
        if (impls == null || impls.length == 0) {
            throw new IllegalStateException("Couldn't create an instance of " + String.valueOf(abstractClss) + ". No implementations provided!");
        }
        Class<?> clss = null;
        for (int i = 0; clss == null && i < impls.length; ++i) {
            try {
                clss = Class.forName(impls[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clss == null) {
            LOGGER.fatal("No Implementation of {} found with given paths {}", abstractClss, (Object)Arrays.toString(impls));
        } else if (abstractClss.isAssignableFrom(clss)) {
            try {
                Constructor<?> constructor = clss.getDeclaredConstructor(new Class[0]);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.fatal("Implementation of {} needs to provide an no arg constructor", clss);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.fatal((Object)e);
            }
        }
        throw new IllegalStateException("Couldn't create an instance of " + String.valueOf(abstractClss));
    }
}

