/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.debugutils.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.debugutils.client.DebugRenderHandler;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ClientDebugCommands {
    public static final SuggestionProvider<class_2172> PROVIDER = class_2321.method_10022((class_2960)class_2960.method_60655((String)"debugutils", (String)"client_toggles"), ClientDebugCommands::getToggles);

    public static <T extends class_2172> void register(CommandDispatcher<T> dispatcher, Function<String, LiteralArgumentBuilder<T>> literalBuilder, ArgumentBuildHelper<T> argumentBuilder, BiConsumer<T, class_2561> resultConsumer) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalBuilder.apply("debugutils_client").then(argumentBuilder.argument("module", class_2232.method_9441()).suggests(class_2321.method_71942(PROVIDER)).then(argumentBuilder.argument("on", BoolArgumentType.bool()).executes(ctx -> ClientDebugCommands.toggle(ctx, resultConsumer))))).then(literalBuilder.apply("off").executes(ctx -> ClientDebugCommands.toggleOff(ctx, resultConsumer))));
    }

    private static <T extends class_2172> int toggle(CommandContext<T> context, BiConsumer<T, class_2561> resultConsumer) {
        boolean on = BoolArgumentType.getBool(context, (String)"on");
        class_2960 value = (class_2960)context.getArgument("module", class_2960.class);
        DebugRenderHandler.toggle(value, on);
        resultConsumer.accept((class_2172)context.getSource(), (class_2561)class_2561.method_43469((String)("debugutils.command.toggle." + (on ? "on" : "off") + ".self"), (Object[])new Object[]{value.toString()}));
        return 1;
    }

    private static <T extends class_2172> int toggleOff(CommandContext<T> context, BiConsumer<T, class_2561> resultConsumer) {
        DebugRenderHandler.toggleOff();
        resultConsumer.accept((class_2172)context.getSource(), (class_2561)class_2561.method_43471((String)"debugutils.command.all.off.self"));
        return 1;
    }

    private static CompletableFuture<Suggestions> getToggles(CommandContext<?> context, SuggestionsBuilder build) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>(DebugRenderHandler.getClientHandlers());
        return ClientDebugCommands.suggestResource(ids, build);
    }

    private static void filterResources(Iterable<class_2960> resources, String input, Consumer<class_2960> resourceConsumer) {
        boolean bl = input.indexOf(58) > -1;
        for (class_2960 resource : resources) {
            if (bl) {
                String string = resource.toString();
                if (!class_2172.method_27136((String)input, (String)string)) continue;
                resourceConsumer.accept(resource);
                continue;
            }
            if (!class_2172.method_27136((String)input, (String)resource.method_12836()) && (!resource.method_12836().equals("minecraft") || !class_2172.method_27136((String)input, (String)resource.method_12832()) && !class_2172.method_27136((String)input, (String)resource.method_12832().replace("debug/", "")))) continue;
            resourceConsumer.accept(resource);
        }
    }

    private static CompletableFuture<Suggestions> suggestResource(Iterable<class_2960> resources, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ClientDebugCommands.filterResources(resources, string, res -> builder.suggest(res.toString()));
        return builder.buildFuture();
    }

    public static interface ArgumentBuildHelper<P> {
        public <T> RequiredArgumentBuilder<P, T> argument(String var1, ArgumentType<T> var2);
    }
}

