/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.debugutils.client;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.debugutils.api.DebugRenderHolder;
import io.github.flemmli97.debugutils.client.DebugRendererModifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_12017;
import net.minecraft.class_12020;
import net.minecraft.class_12043;
import net.minecraft.class_12046;
import net.minecraft.class_155;
import net.minecraft.class_1944;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4205;
import net.minecraft.class_4207;
import net.minecraft.class_4304;
import net.minecraft.class_4703;
import net.minecraft.class_4841;
import net.minecraft.class_5739;
import net.minecraft.class_7923;
import net.minecraft.class_8520;
import net.minecraft.class_8560;
import net.minecraft.class_860;
import net.minecraft.class_863;
import net.minecraft.class_865;
import net.minecraft.class_866;
import net.minecraft.class_867;
import net.minecraft.class_868;
import net.minecraft.class_869;
import net.minecraft.class_870;
import net.minecraft.class_871;
import net.minecraft.class_872;
import net.minecraft.class_8985;
import net.minecraft.class_9987;

public class DebugRenderHandler {
    private static final Map<class_2960, DebugRenderHolder> HANDLERS = new HashMap<class_2960, DebugRenderHolder>();
    private static final Set<class_2960> CLIENT_HANDLERS = new HashSet<class_2960>();
    private static final Set<class_12017<?>> ENABLED_SUBSCRIPTION = new HashSet();
    private static final Set<class_2960> ENABLED = new HashSet<class_2960>();

    public static synchronized void registerHandler(class_12017<?> subscription, DebugRenderHolder holder) {
        class_2960 id = class_7923.field_62996.method_10221(subscription);
        if (id == null) {
            throw new IllegalStateException("No such subscription registered" + String.valueOf(subscription) + "!");
        }
        DebugRenderHandler.register(id, holder, false);
    }

    public static synchronized void registerClientOnlyHandler(class_2960 id, DebugRenderHolder holder) {
        DebugRenderHandler.register(id, holder, true);
    }

    private static void register(class_2960 id, DebugRenderHolder holder, boolean clientOnly) {
        if (HANDLERS.containsKey(id)) {
            throw new IllegalStateException("Handler with given id " + String.valueOf(id) + " already registered!");
        }
        HANDLERS.put(id, holder);
        if (clientOnly) {
            CLIENT_HANDLERS.add(id);
        }
    }

    public static void recompute(class_863 renderer) {
        HANDLERS.forEach((id, holder) -> {
            boolean enabled = ENABLED.contains(id);
            if (enabled && !holder.alreadyEnabled().getAsBoolean()) {
                ((DebugRendererModifier)renderer).debugutils$update(holder.factory().apply(class_310.method_1551()), true, holder.translucent());
            }
        });
    }

    public static Set<class_2960> getClientHandlers() {
        return ImmutableSet.copyOf(CLIENT_HANDLERS);
    }

    public static Set<class_12017<?>> getEnabledSubscription() {
        return ENABLED_SUBSCRIPTION;
    }

    public static void toggle(class_12017<?> subscription, boolean enabled) {
        class_2960 id = class_7923.field_62996.method_10221(subscription);
        if (id != null) {
            DebugRenderHandler.toggle(id, enabled);
            if (enabled) {
                ENABLED_SUBSCRIPTION.add(subscription);
            } else {
                ENABLED_SUBSCRIPTION.remove(subscription);
            }
        }
    }

    public static void toggle(class_2960 id, boolean enabled) {
        DebugRenderHolder holder = HANDLERS.get(id);
        if (holder == null) {
            return;
        }
        if (enabled) {
            ENABLED.add(id);
        } else {
            ENABLED.remove(id);
        }
        if (!holder.alreadyEnabled().getAsBoolean()) {
            ((DebugRendererModifier)class_310.method_1551().field_1769.field_63067).debugutils$update(holder.factory().apply(class_310.method_1551()), enabled, holder.translucent());
        }
    }

    public static void toggleOff() {
        HashSet<class_2960> enabled = new HashSet<class_2960>(ENABLED);
        enabled.forEach(id -> DebugRenderHandler.toggle(id, false));
        ENABLED_SUBSCRIPTION.clear();
    }

    static {
        DebugRenderHandler.registerHandler(class_12020.field_62874, new DebugRenderHolder(() -> class_155.field_29750, class_868::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/water"), new DebugRenderHolder(() -> class_155.field_29751, class_872::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/heightmap"), new DebugRenderHolder(() -> class_155.field_29752, class_867::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/collision"), new DebugRenderHolder(() -> class_155.field_29753, class_865::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/support_blocks"), new DebugRenderHolder(() -> class_155.field_44779, class_8560::new));
        DebugRenderHandler.registerHandler(class_12020.field_62883, new DebugRenderHolder(() -> class_155.field_29755, class_869::new));
        DebugRenderHandler.registerHandler(class_12020.field_62878, new DebugRenderHolder(() -> class_155.field_52319, class_9987::new));
        DebugRenderHandler.registerHandler(class_12020.field_62881, new DebugRenderHolder(() -> class_155.field_29756, class_870::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/light"), new DebugRenderHolder(() -> class_155.field_29676, class_866::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/solid_faces"), new DebugRenderHolder(() -> class_155.field_29678, class_871::new));
        DebugRenderHandler.registerHandler(class_12020.field_62879, new DebugRenderHolder(() -> class_155.field_29689, class_4841::new));
        DebugRenderHandler.registerHandler(class_12020.field_62871, new DebugRenderHolder(() -> class_155.field_29690, class_4207::new));
        DebugRenderHandler.registerHandler(class_12020.field_62877, new DebugRenderHolder(() -> class_155.field_62771, minecraft -> new class_12046(new class_4207(minecraft))));
        DebugRenderHandler.registerHandler(class_12020.field_62870, new DebugRenderHolder(() -> class_155.field_29691, class_4703::new));
        DebugRenderHandler.registerHandler(class_12020.field_62880, new DebugRenderHolder(() -> class_155.field_29692, class_4304::new));
        DebugRenderHandler.registerHandler(class_12020.field_62873, new DebugRenderHolder(() -> class_155.field_29688, class_4205::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/chunk"), new DebugRenderHolder(() -> class_155.field_29679, class_860::new));
        DebugRenderHandler.registerHandler(class_12020.field_62882, new DebugRenderHolder(() -> class_155.field_29680, class_5739::new));
        DebugRenderHandler.registerHandler(class_12020.field_62884, new DebugRenderHolder(() -> class_155.field_29680, mc -> HANDLERS.get(class_7923.field_62996.method_10221((Object)class_12020.field_62882)).factory().apply((class_310)mc)));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/sky_light_sections"), new DebugRenderHolder(() -> class_155.field_44582, minecraft -> new class_8520(minecraft, class_1944.field_9284)));
        DebugRenderHandler.registerHandler(class_12020.field_62872, new DebugRenderHolder(() -> class_155.field_47176, class_8985::new));
        DebugRenderHandler.registerClientOnlyHandler(class_2960.method_60654((String)"debug/entity_block_intersection"), new DebugRenderHolder(() -> class_155.field_60959, class_12043::new));
    }
}

