/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.simplerepair.paper;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github._4drian3d.simplerepair.common.RepairLogic;
import io.github._4drian3d.simplerepair.common.RepairResult;
import io.github._4drian3d.simplerepair.common.configuration.ConfigurationContainer;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.slf4j.Logger;

public final class RepairBootstrap
implements PluginBootstrap,
RepairLogic<Player, EquipmentSlot> {
    private static final Map<String, EquipmentSlot> HANDS = Map.of("HAND", EquipmentSlot.HAND, "OFF_HAND", EquipmentSlot.OFF_HAND);

    public void bootstrap(BootstrapContext context) {
        ConfigurationContainer configurationContainer = ConfigurationContainer.load((Logger)context.getLogger(), context.getDataDirectory(), "config");
        context.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            List<String> aliases = List.of("itemrepair", "repair");
            LiteralCommandNode<CommandSourceStack> node = this.commandNode(configurationContainer);
            ((Commands)event.registrar()).register(node, aliases);
        });
    }

    private LiteralCommandNode<CommandSourceStack> commandNode(ConfigurationContainer container) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"simplerepair").requires(src -> {
            Player p;
            CommandSender patt0$temp = src.getSender();
            return patt0$temp instanceof Player && (p = (Player)patt0$temp).hasPermission("simplerepair.use");
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"hand", (ArgumentType)StringArgumentType.word()).requires(src -> src.getSender().hasPermission("simplerepair.use.handtype"))).suggests((context, builder) -> {
            HANDS.forEach((hand, slot) -> builder.suggest(hand));
            return builder.buildFuture();
        }).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
            EquipmentSlot slot = HANDS.get(StringArgumentType.getString((CommandContext)ctx, (String)"hand"));
            RepairResult result = this.repairItem(player, slot, 100.0);
            this.sendResult((Audience)player, result, container.get());
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"percentage", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)100.0)).requires(src -> src.getSender().hasPermission("simplerepair.use.percentage"))).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
            EquipmentSlot slot = HANDS.get(StringArgumentType.getString((CommandContext)ctx, (String)"hand"));
            double percentage = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"percentage");
            RepairResult result = this.repairItem(player, slot, percentage);
            this.sendResult((Audience)player, result, container.get());
            return 1;
        })))).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
            RepairResult result = this.repairItem(player, EquipmentSlot.HAND, 100.0);
            this.sendResult((Audience)player, result, container.get());
            return 1;
        })).build();
    }

    @Override
    public RepairResult repairItem(Player source, EquipmentSlot hand, double percentage) {
        ItemStack item = source.getInventory().getItem(hand);
        short maxDurability = item.getType().getMaxDurability();
        if (maxDurability != 0) {
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof Damageable)) {
                return RepairResult.CANNOT_BE_REPAIRED;
            }
            Damageable damageable = (Damageable)meta;
            if (!damageable.hasDamage()) {
                return RepairResult.CANNOT_BE_REPAIRED;
            }
            int damage = damageable.getDamage();
            if (damage == 0) {
                return RepairResult.ALREADY_REPAIRED;
            }
            int calculatedDamage = this.calculatePercentage(percentage, maxDurability);
            int newDamage = damage - calculatedDamage;
            damageable.setDamage(Math.max(newDamage, 0));
            item.setItemMeta((ItemMeta)damageable);
            return RepairResult.REPAIRED;
        }
        return RepairResult.CANNOT_BE_REPAIRED;
    }
}

