/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.simplerepair.common.configuration;

import io.github._4drian3d.simplerepair.common.configuration.Configuration;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public final class ConfigurationContainer {
    private final AtomicReference<Configuration> config;
    private final HoconConfigurationLoader loader;
    private final Logger logger;

    private ConfigurationContainer(Configuration config, HoconConfigurationLoader loader, Logger logger) {
        this.config = new AtomicReference<Configuration>(config);
        this.loader = loader;
        this.logger = logger;
    }

    public CompletableFuture<Boolean> reload() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
                Configuration newConfig = (Configuration)node.get(Configuration.class);
                node.set(Configuration.class, (Object)newConfig);
                this.loader.save((ConfigurationNode)node);
                this.config.set(newConfig);
                return true;
            }
            catch (ConfigurateException exception) {
                this.logger.error("Could not reload configuration file", (Throwable)exception);
                return false;
            }
        });
    }

    @NotNull
    public Configuration get() {
        return this.config.get();
    }

    public static ConfigurationContainer load(Logger logger, Path path, String file) {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(options -> options.header("SimpleRepair | by 4drian3d").shouldCopyDefaults(true))).path(path.resolve(file + ".conf"))).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            Configuration config = (Configuration)node.get(Configuration.class);
            node.set(Configuration.class, (Object)config);
            loader.save((ConfigurationNode)node);
            return new ConfigurationContainer(config, loader, logger);
        }
        catch (ConfigurateException exception) {
            logger.error("Could not load configuration file", (Throwable)exception);
            return null;
        }
    }
}

