/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.simplerepair.sponge;

import com.google.inject.Inject;
import io.github._4drian3d.simplerepair.common.RepairLogic;
import io.github._4drian3d.simplerepair.common.RepairResult;
import io.github._4drian3d.simplerepair.common.configuration.ConfigurationContainer;
import io.leangen.geantyref.TypeToken;
import java.nio.file.Path;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Server;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartedEngineEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="simplerepair")
public final class SimpleRepair
implements RepairLogic<ServerPlayer, HandType> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SimpleRepair");
    @Inject
    private PluginContainer pluginContainer;
    @Inject
    @ConfigDir(sharedRoot=true)
    private Path path;
    private ConfigurationContainer container;

    @Listener
    public void onServerStart(StartedEngineEvent<Server> event) {
        this.container = ConfigurationContainer.load(LOGGER, this.path, "simplerepair");
    }

    @Listener
    public void onCommandRegister(RegisterCommandEvent<Command.Parameterized> event) {
        Parameter.Value handParameter = Parameter.registryElement((TypeToken)TypeToken.get(HandType.class), (DefaultedRegistryType)RegistryTypes.HAND_TYPE, (String[])new String[0]).requiredPermission("simplerepair.use.handtype").key("hand").build();
        Parameter.Value percentageParameter = Parameter.doubleNumber().requiredPermission("simplerepair.use.percentage").key("percentage").build();
        Command.Parameterized command = Command.builder().permission("simplerepair.use").executionRequirements(context -> context.cause().root() instanceof ServerPlayer).addParameter((Parameter)handParameter).addParameter((Parameter)percentageParameter).executor(context -> {
            ServerPlayer player = (ServerPlayer)context.cause().first(ServerPlayer.class).orElseThrow();
            HandType handType = (HandType)context.one(handParameter).orElseGet(HandTypes.MAIN_HAND);
            double percentage = context.one(percentageParameter).orElse(100.0);
            return switch (this.repairItem(player, handType, percentage)) {
                default -> throw new MatchException(null, null);
                case RepairResult.REPAIRED -> {
                    player.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.container.get().itemRepaired()));
                    yield CommandResult.success();
                }
                case RepairResult.ALREADY_REPAIRED -> CommandResult.error((Component)MiniMessage.miniMessage().deserialize((Object)this.container.get().alreadyRepaired()));
                case RepairResult.CANNOT_BE_REPAIRED -> CommandResult.error((Component)MiniMessage.miniMessage().deserialize((Object)this.container.get().nonRepairableItem()));
            };
        }).build();
        event.register(this.pluginContainer, (Object)command, "simplerepair", new String[]{"repair"});
    }

    @Override
    public RepairResult repairItem(ServerPlayer source, HandType hand, double percentage) {
        ItemStack item = source.itemInHand(hand);
        int maxDurability = item.get(Keys.MAX_DURABILITY).orElse(0);
        int itemDurability = item.get(Keys.ITEM_DURABILITY).orElse(0);
        if (maxDurability == 0) {
            return RepairResult.CANNOT_BE_REPAIRED;
        }
        if (maxDurability == itemDurability) {
            return RepairResult.ALREADY_REPAIRED;
        }
        if (percentage == 100.0) {
            item.offer(Keys.ITEM_DURABILITY, (Object)maxDurability);
            return RepairResult.REPAIRED;
        }
        int newDurability = itemDurability + this.calculatePercentage(percentage, maxDurability);
        item.offer(Keys.ITEM_DURABILITY, (Object)Math.min(newDurability, maxDurability));
        return RepairResult.REPAIRED;
    }
}

