/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.specialforces.Specialty;
import su.uTa4u.specialforces.config.CommonConfig;

public enum Mission {
    SCOUTING("scouting"),
    RESCUE("rescue"),
    RAID("raid"),
    SIEGE("siege"),
    ARREST("arrest"),
    SABOTAGE("sabotage");

    private static final Mission[] VALUES;
    private static final Map<String, Mission> MISSION_BY_NAME;
    private final String name;
    private final MutableComponent message;
    private List<Specialty> participants;

    private Mission(String name) {
        this.name = name;
        this.message = Component.m_237115_((String)("mission.taczsf.msg." + name));
    }

    public String getName() {
        return this.name;
    }

    public MutableComponent getMessage() {
        return this.message.m_6881_();
    }

    public List<Specialty> getParticipants() {
        return this.participants;
    }

    @Nullable
    public static Mission byName(String name) {
        return MISSION_BY_NAME.get(name);
    }

    public static void loadParticipantsFromConfig() {
        for (Mission mission : VALUES) {
            mission.participants = ((List)CommonConfig.MISSION_PARTICIPANTS.get((Object)mission).get()).stream().map(Specialty::byName).toList();
        }
    }

    static {
        VALUES = Mission.values();
        MISSION_BY_NAME = new HashMap<String, Mission>();
        for (Mission mission : VALUES) {
            MISSION_BY_NAME.put(mission.name, mission);
        }
    }
}

