/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.specialforces.Util;
import su.uTa4u.specialforces.items.ModItems;

public enum Specialty {
    COMMANDER("commander", 0.3f),
    ASSAULTER("assaulter", 0.3f),
    GRENADIER("grenadier", 0.3f),
    BULLDOZER("bulldozer", 0.3f),
    ENGINEER("engineer", 0.3f),
    SNIPER("sniper", 1.0f),
    MEDIC("medic", 0.3f),
    SCOUT("scout", 0.3f),
    SPY("spy", 0.3f);

    private static final Random RNG;
    public static final Specialty[] VALUES;
    public static final int SIZE;
    private final String name;
    private final ResourceLocation skin;
    private final ResourceLocation lootTable;
    private final Component typeName;
    private final float headAimChance;
    private ItemStack spawnEgg;

    private Specialty(String name, float headAimChance) {
        this.name = name;
        this.skin = Util.getResource("textures/entity/" + name + ".png");
        this.headAimChance = headAimChance;
        this.lootTable = Util.getResource("spawn_inv/" + name);
        this.typeName = Component.m_237115_((String)("entity.taczsf." + name));
        this.spawnEgg = null;
    }

    public static Specialty getRandom() {
        return VALUES[RNG.nextInt(SIZE)];
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getSkin() {
        return this.skin;
    }

    public float getHeadAimChance() {
        return this.headAimChance;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public Component getTypeName() {
        return this.typeName;
    }

    public ItemStack getSpawnEgg() {
        if (this.spawnEgg == null) {
            this.spawnEgg = new ItemStack((ItemLike)ModItems.SWAT_SPAWN_EGG.get());
            CompoundTag displayTag = this.spawnEgg.m_41698_("display");
            ListTag loreTag = displayTag.m_128437_("Lore", 8);
            if (!displayTag.m_128425_("Lore", 9)) {
                displayTag.m_128365_("Lore", (Tag)loreTag);
            }
            loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)this.typeName)));
            this.spawnEgg.m_41698_("EntityTag").m_128359_("Specialty", this.name);
        }
        return this.spawnEgg.m_41777_();
    }

    @Nullable
    public static Specialty byName(String name) {
        return switch (name) {
            case "commander" -> COMMANDER;
            case "assaulter" -> ASSAULTER;
            case "grenadier" -> GRENADIER;
            case "bulldozer" -> BULLDOZER;
            case "engineer" -> ENGINEER;
            case "sniper" -> SNIPER;
            case "medic" -> MEDIC;
            case "scout" -> SCOUT;
            case "spy" -> SPY;
            default -> null;
        };
    }

    static {
        RNG = new Random();
        VALUES = Specialty.values();
        SIZE = VALUES.length;
    }
}

