/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.capabilities.observation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import su.uTa4u.specialforces.Mission;
import su.uTa4u.specialforces.SpecialForces;
import su.uTa4u.specialforces.capabilities.observation.IObservation;
import su.uTa4u.specialforces.config.CommonConfig;
import su.uTa4u.specialforces.entities.SwatEntity;

public class Observation
implements IObservation {
    private static final String NBT_KEY_SWAT_MISSION = "SwatMission";
    private static final String NBT_KEY_COMMANDERS = "Commanders";
    private static final String NBT_KEY_BLOCKS = "Blocks";
    private static final String NBT_KEY_ENTITIES = "Entities";
    private static final String NBT_KEY_TICK_TIMER = "TickTimer";
    private static final Set<Block> OBSERVATION_BLOCK_TARGETS = new HashSet<Block>();
    private static final Set<EntityType<? extends Entity>> OBSERVATION_ENTITY_TARGETS = new HashSet<EntityType<? extends Entity>>();
    private Map<Block, List<BlockPos>> observedBlocks = new HashMap<Block, List<BlockPos>>();
    private Map<EntityType<? extends Entity>, List<UUID>> observedEntities = new HashMap<EntityType<? extends Entity>, List<UUID>>();
    private int tickTimer = 0;
    private List<UUID> commanders = new ArrayList<UUID>();
    private Mission swatMission = null;

    Observation() {
    }

    @Override
    public void observe(Block block, BlockPos pos) {
        if (this.swatMission == Mission.SCOUTING && !this.observedBlocks.computeIfAbsent(block, k -> new ArrayList()).contains(pos)) {
            this.observedBlocks.get(block).add(pos);
        }
    }

    @Override
    public void observe(EntityType<? extends Entity> entityType, UUID uuid) {
        if (this.swatMission == Mission.SCOUTING && !this.observedEntities.computeIfAbsent(entityType, k -> new ArrayList()).contains(uuid)) {
            this.observedEntities.get(entityType).add(uuid);
        }
    }

    @Override
    public int getTickTimer() {
        return this.tickTimer;
    }

    @Override
    public List<UUID> getCommanders() {
        return this.commanders;
    }

    @Override
    public Map<Block, List<BlockPos>> getObservedBlocks() {
        return this.observedBlocks;
    }

    @Override
    public Map<EntityType<? extends Entity>, List<UUID>> getObservedEntities() {
        return this.observedEntities;
    }

    @Override
    public void tick(Player player) {
        if (player.f_19797_ % 20 == 0) {
            this.validateObserved();
        }
        ++this.tickTimer;
        if (this.tickTimer >= (Integer)CommonConfig.OBSERVATION_TICK_COOLDOWN.get()) {
            this.tickTimer = 0;
            ServerLevel serverLevel = (ServerLevel)player.m_9236_();
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.commanders.removeIf(uuid -> Observation.isCommanderInvalid(uuid, serverLevel));
            if (this.commanders.isEmpty()) {
                this.swatMission = null;
            }
            if (this.swatMission == null) {
                ArrayList<Mission> possibleMissions = new ArrayList<Mission>();
                if (!this.anyObservedBlocks()) {
                    possibleMissions.add(Mission.RAID);
                }
                if (!this.anyObservedEntities()) {
                    possibleMissions.add(Mission.RESCUE);
                }
                if (serverLevel.m_46472_() == serverPlayer.m_8963_() && serverPlayer.m_8961_() != null) {
                    possibleMissions.add(Mission.ARREST);
                }
                possibleMissions.add(Mission.SCOUTING);
                possibleMissions.add(Mission.SIEGE);
                possibleMissions.add(Mission.SABOTAGE);
                this.swatMission = (Mission)((Object)possibleMissions.get(player.m_217043_().m_188503_(possibleMissions.size())));
            }
            if (!serverLevel.m_46469_().m_46207_(SpecialForces.RULE_NATURAL_SPAWN)) {
                return;
            }
            if (this.commanders.size() >= (Integer)CommonConfig.OBSERVATION_SQUAD_COUNT.get()) {
                return;
            }
            serverPlayer.m_213846_((Component)this.swatMission.getMessage().m_130946_(", ").m_7220_(serverPlayer.m_7755_()));
            for (int i = 0; i < (Integer)CommonConfig.OBSERVATION_SQUAD_COUNT.get(); ++i) {
                SwatEntity commander = SwatEntity.commander((Level)serverLevel, this.swatMission);
                commander.m_146884_(player.m_20182_());
                Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)commander, (int)64, (int)15);
                if (pos == null || pos.m_82557_(player.m_20182_()) < 1024.0) continue;
                commander.m_146884_(pos);
                commander.m_6710_((LivingEntity)player);
                ForgeEventFactory.onFinalizeSpawn((Mob)commander, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(commander.m_20097_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                if (!serverLevel.m_7967_((Entity)commander)) continue;
                this.commanders.add(commander.m_20148_());
                commander.summonSquadNextTick();
            }
        }
    }

    private void validateObserved() {
        for (Block block : this.observedBlocks.keySet()) {
            if (Observation.isObservationTarget(block)) continue;
            this.observedBlocks.remove(block);
        }
        for (EntityType entityType : this.observedEntities.keySet()) {
            if (Observation.isObservationTarget(entityType)) continue;
            this.observedEntities.remove(entityType);
        }
    }

    @Override
    public void copy(IObservation other) {
        this.tickTimer = other.getTickTimer();
        this.commanders = other.getCommanders();
        this.observedBlocks = other.getObservedBlocks();
        this.observedEntities = other.getObservedEntities();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_KEY_TICK_TIMER, this.tickTimer);
        if (this.swatMission != null) {
            nbt.m_128359_(NBT_KEY_SWAT_MISSION, this.swatMission.getName());
        }
        ListTag spawnedUUIDsTag = new ListTag();
        this.commanders.forEach(uuid -> spawnedUUIDsTag.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        nbt.m_128365_(NBT_KEY_COMMANDERS, (Tag)spawnedUUIDsTag);
        CompoundTag blocksTag = new CompoundTag();
        this.observedBlocks.forEach((block, list) -> {
            ListTag blockTag = new ListTag();
            for (BlockPos pos : list) {
                blockTag.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            blocksTag.m_128365_(Observation.getBlockName(block), (Tag)blockTag);
        });
        nbt.m_128365_(NBT_KEY_BLOCKS, (Tag)blocksTag);
        CompoundTag entitiesTag = new CompoundTag();
        this.observedEntities.forEach((entityType, list) -> {
            ListTag entityTypeTag = new ListTag();
            for (UUID uuid : list) {
                entityTypeTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            entitiesTag.m_128365_(Observation.getEntityTypeName(entityType), (Tag)entityTypeTag);
        });
        nbt.m_128365_(NBT_KEY_ENTITIES, (Tag)entitiesTag);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag entitiesTag;
        CompoundTag blocksTag;
        ListTag commandersTag;
        Tag tag;
        Mission mission;
        this.tickTimer = nbt.m_128451_(NBT_KEY_TICK_TIMER);
        if (nbt.m_128441_(NBT_KEY_SWAT_MISSION) && (mission = Mission.byName(nbt.m_128461_(NBT_KEY_SWAT_MISSION))) != null) {
            this.swatMission = mission;
        }
        if ((tag = nbt.m_128423_(NBT_KEY_COMMANDERS)) instanceof ListTag && !(commandersTag = (ListTag)tag).isEmpty()) {
            for (Tag t : commandersTag) {
                this.commanders.add(NbtUtils.m_129233_((Tag)t));
            }
        }
        if ((blocksTag = (CompoundTag)nbt.m_128423_(NBT_KEY_BLOCKS)) != null) {
            for (Block block : OBSERVATION_BLOCK_TARGETS) {
                ListTag blockTag;
                tag = blocksTag.m_128423_(Observation.getBlockName(block));
                if (!(tag instanceof ListTag) || (blockTag = (ListTag)tag).isEmpty()) continue;
                ArrayList<BlockPos> list = new ArrayList<BlockPos>();
                for (Tag t : blockTag) {
                    list.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)t)));
                }
                this.observedBlocks.put(block, list);
            }
        }
        if ((entitiesTag = (CompoundTag)nbt.m_128423_(NBT_KEY_ENTITIES)) != null) {
            for (EntityType<? extends Entity> entityType : OBSERVATION_ENTITY_TARGETS) {
                ListTag entityTypeTag;
                tag = entitiesTag.m_128423_(Observation.getEntityTypeName(entityType));
                if (!(tag instanceof ListTag) || (entityTypeTag = (ListTag)tag).isEmpty()) continue;
                ArrayList<UUID> list = new ArrayList<UUID>();
                for (Tag t : entityTypeTag) {
                    list.add(NbtUtils.m_129233_((Tag)t));
                }
                this.observedEntities.put(entityType, list);
            }
        }
    }

    public static boolean isObservationTarget(Block block) {
        return OBSERVATION_BLOCK_TARGETS.contains(block);
    }

    public static boolean isObservationTarget(EntityType<?> entityType) {
        return OBSERVATION_ENTITY_TARGETS.contains(entityType);
    }

    private boolean anyObservedBlocks() {
        for (Block block : OBSERVATION_BLOCK_TARGETS) {
            List<BlockPos> list = this.observedBlocks.get(block);
            if (list == null || list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean anyObservedEntities() {
        for (EntityType<? extends Entity> entityType : OBSERVATION_ENTITY_TARGETS) {
            List<UUID> list = this.observedEntities.get(entityType);
            if (list == null || list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean isCommanderInvalid(UUID uuid, ServerLevel serverLevel) {
        SwatEntity swat;
        Entity entity = serverLevel.m_8791_(uuid);
        return !(entity instanceof SwatEntity) || (swat = (SwatEntity)entity).m_213877_() || swat.getState() == 2 || !swat.hasMission() || !swat.hasSquad();
    }

    private static String getBlockName(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }

    private static String getEntityTypeName(EntityType<?> entityType) {
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entityType)).m_135815_();
    }

    public static void loadTargetsFromConfig() {
        OBSERVATION_BLOCK_TARGETS.clear();
        ((List)CommonConfig.OBSERVATION_BLOCK_TARGETS.get()).stream().map(id -> (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.parse((String)id))).forEach(OBSERVATION_BLOCK_TARGETS::add);
        OBSERVATION_ENTITY_TARGETS.clear();
        ((List)CommonConfig.OBSERVATION_ENTITY_TARGETS.get()).stream().map(id -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)id))).forEach(OBSERVATION_ENTITY_TARGETS::add);
    }
}

