/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.capabilities.observation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.specialforces.Util;
import su.uTa4u.specialforces.capabilities.ModCapabilities;
import su.uTa4u.specialforces.capabilities.observation.IObservation;
import su.uTa4u.specialforces.capabilities.observation.Observation;

@Mod.EventBusSubscriber(modid="taczsf")
public class ObservationManager {
    private static final ResourceLocation IDENTIFIER = Util.getResource("observation");

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END) {
            return;
        }
        ObservationManager.ifCapPresent(event.player, (NonNullConsumer<? super IObservation>)((NonNullConsumer)cap -> cap.tick(event.player)));
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.f_46443_ || event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = level.m_8055_(pos).m_60734_();
        if (Observation.isObservationTarget(block)) {
            ObservationManager.ifCapPresent(event.getEntity(), (NonNullConsumer<? super IObservation>)((NonNullConsumer)cap -> cap.observe(block, pos)));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        oldPlayer.reviveCaps();
        ObservationManager.ifCapPresent(event.getEntity(), (NonNullConsumer<? super IObservation>)((NonNullConsumer)cap -> ObservationManager.ifCapPresent(oldPlayer, (NonNullConsumer<? super IObservation>)((NonNullConsumer)cap::copy))));
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        final Observation scoutDataCap = new Observation();
        final LazyOptional scoutDataCapOpt = LazyOptional.of(() -> scoutDataCap);
        final Capability<IObservation> capability = ModCapabilities.PLAYER_OBSERVATION;
        ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

            public CompoundTag serializeNBT() {
                return (CompoundTag)scoutDataCap.serializeNBT();
            }

            public void deserializeNBT(CompoundTag nbt) {
                scoutDataCap.deserializeNBT((Tag)nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction direction) {
                return cap == capability ? scoutDataCapOpt.cast() : LazyOptional.empty();
            }
        };
        event.addCapability(IDENTIFIER, (ICapabilityProvider)provider);
    }

    public static void ifCapPresent(Player player, NonNullConsumer<? super IObservation> consumer) {
        player.getCapability(ModCapabilities.PLAYER_OBSERVATION).ifPresent(consumer);
    }

    private ObservationManager() {
    }
}

