/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.config;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import su.uTa4u.specialforces.Mission;
import su.uTa4u.specialforces.Specialty;
import su.uTa4u.specialforces.Util;

public final class CommonConfig {
    public static final ForgeConfigSpec SPEC = CommonConfig.init();
    public static ForgeConfigSpec.IntValue OBSERVATION_TICK_COOLDOWN;
    public static ForgeConfigSpec.IntValue OBSERVATION_SQUAD_COUNT;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> OBSERVATION_BLOCK_TARGETS;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> OBSERVATION_ENTITY_TARGETS;
    public static ForgeConfigSpec.IntValue GUN_ATTACK_COOLDOWN;
    public static ForgeConfigSpec.DoubleValue SWAT_ENTITY_EFFECTIVE_RANGE_MULT;
    public static ForgeConfigSpec.IntValue SWAT_ENTITY_SQUAD_SUMMON_COOLDOWN;
    public static ForgeConfigSpec.IntValue SWAT_ENTITY_DEAD_BODY_LIFESPAN;
    public static ForgeConfigSpec.IntValue SWAT_ENTITY_FAILED_GUN_POS_LIMIT;
    public static ForgeConfigSpec.IntValue SWAT_ENTITY_HOLD_POSITION_DURATION;
    public static ForgeConfigSpec.BooleanValue SWAT_ENTITY_NO_CORPSE;
    public static EnumMap<Mission, ForgeConfigSpec.ConfigValue<List<? extends String>>> MISSION_PARTICIPANTS;
    public static EnumMap<Specialty, Map<Attribute, ForgeConfigSpec.DoubleValue>> SPECIALTY_ATTRIBUTES;

    private static ForgeConfigSpec init() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Observation");
        OBSERVATION_TICK_COOLDOWN = builder.comment("Time between selecting missions and spawning mission commanders,").comment("in ticks (20 ticks = 1 second)").comment("Default: 24000").defineInRange("tickCooldown", 24000, 1, Integer.MAX_VALUE);
        OBSERVATION_SQUAD_COUNT = builder.comment("How many squads (mission commanders) can exist at the same time.").comment("I wouldn't recommend setting this all the way to the max...").comment("Default: 3").defineInRange("squadCount", 3, 1, 128);
        OBSERVATION_BLOCK_TARGETS = builder.comment("List of blocks that swat will take note of when player interacts with them.").comment("Will be used in missions such as raid").comment("Example: `minecraft:chest`, `minecraft:furnace`").comment("Default: []").defineListAllowEmpty("blockTargets", List.of(), id -> ForgeRegistries.BLOCKS.getValue(ResourceLocation.parse((String)((String)id))) != null);
        OBSERVATION_ENTITY_TARGETS = builder.comment("List of entity types that swat will take note of when player interacts with them.").comment("Will be used in missions such as rescue").comment("Example: `minecraft:villager`, `minecraft:cow`").comment("Default: []").defineListAllowEmpty("entityTargets", List.of(), id -> ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)((String)id))) != null);
        builder.pop();
        builder.push("GunAttack");
        GUN_ATTACK_COOLDOWN = builder.comment("Time between gun attacks,").comment("in ticks (20 ticks = 1 second)").comment("Default: 40").defineInRange("cooldown", 40, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("SwatEntity");
        SWAT_ENTITY_EFFECTIVE_RANGE_MULT = builder.comment("Multiplier for entities weapon's effective range.").comment("Default: 2.0").defineInRange("effectiveRangeMult", 2.0, 0.01, 10.0);
        SWAT_ENTITY_SQUAD_SUMMON_COOLDOWN = builder.comment("Time between squad summonings by commander,").comment("in ticks (20 ticks = 1 second)").comment("Default: 6000").defineInRange("squadSummonCooldown", 6000, 1, Integer.MAX_VALUE);
        SWAT_ENTITY_DEAD_BODY_LIFESPAN = builder.comment("Time after which dead body will despawn,").comment("in ticks (20 ticks = 1 second)").comment("Default: 6000").defineInRange("deadBodyLifespan", 6000, 1, Integer.MAX_VALUE);
        SWAT_ENTITY_FAILED_GUN_POS_LIMIT = builder.comment("Number of failed attempts entity has to do before it is considered as stuck.").comment("Default: 1800").defineInRange("failedGunPosLimit", 1800, 1, Integer.MAX_VALUE);
        SWAT_ENTITY_HOLD_POSITION_DURATION = builder.comment("Time duration for which the entity is gonna hold it's current position even if it's not optimal.").comment("Higher values means less tps lag.").comment("Default: 300").defineInRange("holdPosDuration", 300, 1, Integer.MAX_VALUE);
        SWAT_ENTITY_NO_CORPSE = builder.comment("Should a corpse be left behind.").comment("Default: false").define("noCorpse", false);
        builder.pop();
        builder.push("Mission");
        MISSION_PARTICIPANTS = new EnumMap(Mission.class);
        CommonConfig.initMission(builder, Mission.SCOUTING, List.of("medic", "scout", "scout", "scout", "scout", "engineer", "spy"));
        CommonConfig.initMission(builder, Mission.RESCUE, List.of("medic", "assaulter", "assaulter", "assaulter", "bulldozer"));
        CommonConfig.initMission(builder, Mission.RAID, List.of("medic", "assaulter", "assaulter", "assaulter", "assaulter", "bulldozer", "grenadier", "grenadier"));
        CommonConfig.initMission(builder, Mission.SIEGE, List.of("medic", "sniper", "sniper", "grenadier", "grenadier", "grenadier", "bulldozer"));
        CommonConfig.initMission(builder, Mission.ARREST, List.of("medic", "assaulter", "assaulter", "assaulter", "bulldozer", "bulldozer", "grenadier"));
        CommonConfig.initMission(builder, Mission.SABOTAGE, List.of("medic", "spy", "spy", "spy", "engineer", "engineer"));
        builder.pop();
        builder.push("Specialty");
        SPECIALTY_ATTRIBUTES = new EnumMap(Specialty.class);
        CommonConfig.initSpecialty(builder, Specialty.COMMANDER, 90.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.ASSAULTER, 100.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.GRENADIER, 80.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.BULLDOZER, 150.0, Attributes.f_22277_.m_22082_(), 0.5, 0.15, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.ENGINEER, 70.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.SNIPER, 50.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.MEDIC, 70.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.SCOUT, 60.0, Attributes.f_22277_.m_22082_(), 0.05, 0.5, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        CommonConfig.initSpecialty(builder, Specialty.SPY, 60.0, Attributes.f_22277_.m_22082_(), 0.15, 0.3, Attributes.f_22281_.m_22082_(), Attributes.f_22282_.m_22082_(), Attributes.f_22283_.m_22082_(), Attributes.f_22284_.m_22082_(), Attributes.f_22285_.m_22082_());
        builder.pop();
        return builder.build();
    }

    private static void initMission(ForgeConfigSpec.Builder builder, Mission mission, List<String> participants) {
        builder.push(Util.capitalizeFirstLetter(mission.getName()));
        MISSION_PARTICIPANTS.put(mission, (ForgeConfigSpec.ConfigValue<List<? extends String>>)builder.comment("Allowed values: `commander`, `assaulter`, `grenadier`, `bulldozer`, `engineer`, `sniper`, `medic`, `scout`, `spy`").comment("Default: " + participants).defineList("Participants", participants, name -> Specialty.byName((String)name) != null));
        builder.pop();
    }

    private static void initSpecialty(ForgeConfigSpec.Builder builder, Specialty spec, double maxHealth, double followRange, double knockbackResistance, double movementSpeed, double attackDamage, double attackKnockback, double attackSpeed, double armor, double armorToughness) {
        builder.push(Util.capitalizeFirstLetter(spec.getName()));
        HashMap<Attribute, ForgeConfigSpec.DoubleValue> attributes = new HashMap<Attribute, ForgeConfigSpec.DoubleValue>();
        attributes.put(Attributes.f_22276_, builder.comment("Default: " + maxHealth).defineInRange("maxHealth", maxHealth, 1.0, 1024.0));
        attributes.put(Attributes.f_22277_, builder.comment("Default: " + followRange).defineInRange("followRange", followRange, 0.0, 2048.0));
        attributes.put(Attributes.f_22278_, builder.comment("Default: " + knockbackResistance).defineInRange("knockbackResistance", knockbackResistance, 0.0, 1.0));
        attributes.put(Attributes.f_22279_, builder.comment("Default: " + movementSpeed).defineInRange("movementSpeed", movementSpeed, 0.0, 1024.0));
        attributes.put(Attributes.f_22281_, builder.comment("Default: " + attackDamage).defineInRange("attackDamage", attackDamage, 0.0, 2048.0));
        attributes.put(Attributes.f_22282_, builder.comment("Default: " + attackKnockback).defineInRange("attackKnockback", attackKnockback, 0.0, 5.0));
        attributes.put(Attributes.f_22283_, builder.comment("Default: " + attackSpeed).defineInRange("attackSpeed", attackSpeed, 0.0, 1024.0));
        attributes.put(Attributes.f_22284_, builder.comment("Default: " + armor).defineInRange("armor", armor, 0.0, 30.0));
        attributes.put(Attributes.f_22285_, builder.comment("Default: " + armorToughness).defineInRange("armorToughness", armorToughness, 0.0, 20.0));
        SPECIALTY_ATTRIBUTES.put(spec, attributes);
        builder.pop();
    }

    private CommonConfig() {
    }
}

