/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.entity.shooter.LivingEntityAim;
import com.tacz.guns.entity.shooter.LivingEntityAmmoCheck;
import com.tacz.guns.entity.shooter.LivingEntityBolt;
import com.tacz.guns.entity.shooter.LivingEntityCrawl;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityFireSelect;
import com.tacz.guns.entity.shooter.LivingEntityMelee;
import com.tacz.guns.entity.shooter.LivingEntityReload;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.LivingEntitySpeedModifier;
import com.tacz.guns.entity.shooter.LivingEntitySprint;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.entity.sync.ModSyncedEntityData;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.EffectiveRangeModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.specialforces.Mission;
import su.uTa4u.specialforces.ModTags;
import su.uTa4u.specialforces.SpecialForces;
import su.uTa4u.specialforces.Specialty;
import su.uTa4u.specialforces.Util;
import su.uTa4u.specialforces.config.CommonConfig;
import su.uTa4u.specialforces.entities.ModEntities;
import su.uTa4u.specialforces.entities.ModEntityDataSerializers;
import su.uTa4u.specialforces.entities.goals.GunAttackGoal;
import su.uTa4u.specialforces.entities.goals.GunPosGoal;
import su.uTa4u.specialforces.entities.goals.PotionUseGoal;
import su.uTa4u.specialforces.entities.goals.RetreatGoal;
import su.uTa4u.specialforces.menus.SwatCorpseMenu;

public class SwatEntity
extends PathfinderMob
implements IGunOperator,
Container,
MenuProvider {
    private static final String NBT_KEY_DEAD_BODY_AGE = "DeadBodyAge";
    private static final String NBT_KEY_MISSION = "Mission";
    private static final String NBT_KEY_SQUAD = "Squad";
    private static final String NBT_KEY_COMMANDER = "Commander";
    private static final String NBT_KEY_STATE = "State";
    private static final String NBT_KEY_INVENTORY = "Inventory";
    private static final String NBT_KEY_SLOT = "Slot";
    private static final String NBT_KEY_SELECTED = "Selected";
    private static final String NBT_KEY_SQUAD_SUMMON_TIMER = "SquadTimer";
    private static final String NBT_KEY_FAILED_GUN_POS_COUNTER = "GunPosCounter";
    public static final String NBT_KEY_SPECIALTY = "Specialty";
    private static final EntityDimensions BOX_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)0.6f);
    private static final EntityDataAccessor<Specialty> SPECIALTY = SynchedEntityData.m_135353_(SwatEntity.class, ModEntityDataSerializers.SPECIAL_FORCE_SPECIALTY);
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.m_135353_(SwatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final byte STATE_ALIVE = 0;
    public static final byte STATE_DOWN = 1;
    public static final byte STATE_DEAD = 2;
    private static final List<String> GUN_TYPE_ORDER = List.of(Util.getGunTabTypeName(GunTabType.SNIPER), Util.getGunTabTypeName(GunTabType.RPG), Util.getGunTabTypeName(GunTabType.MG), Util.getGunTabTypeName(GunTabType.RIFLE), Util.getGunTabTypeName(GunTabType.SHOTGUN), Util.getGunTabTypeName(GunTabType.SMG), Util.getGunTabTypeName(GunTabType.PISTOL));
    private static final float DOWN_HEALTH_THRESHOLD = 20.0f;
    private MeleeAttackGoal meleeAttackGoal;
    private int squadSummonTimer = 0;
    private short deadBodyAge = 0;
    private float currentGunAttackRadiusSqr;
    private int failedGunPosCounter = 0;
    @Nullable
    private Mission mission = null;
    @Nullable
    private List<SwatEntity> squad = null;
    @Nullable
    private SwatEntity commander = null;
    private final LivingEntity tacz$shooter = this;
    private final ShooterDataHolder tacz$data = new ShooterDataHolder();
    private final LivingEntityDrawGun tacz$draw = new LivingEntityDrawGun(this.tacz$shooter, this.tacz$data);
    private final LivingEntityAim tacz$aim = new LivingEntityAim(this.tacz$shooter, this.tacz$data);
    private final LivingEntityCrawl tacz$crawl = new LivingEntityCrawl(this.tacz$shooter, this.tacz$data);
    private final LivingEntityAmmoCheck tacz$ammoCheck = new LivingEntityAmmoCheck(this.tacz$shooter);
    private final LivingEntityFireSelect tacz$fireSelect = new LivingEntityFireSelect(this.tacz$shooter, this.tacz$data);
    private final LivingEntityMelee tacz$melee = new LivingEntityMelee(this.tacz$shooter, this.tacz$data, this.tacz$draw);
    private final LivingEntityShoot tacz$shoot = new LivingEntityShoot(this.tacz$shooter, this.tacz$data, this.tacz$draw);
    private final LivingEntityBolt tacz$bolt = new LivingEntityBolt(this.tacz$data, this.tacz$shooter, this.tacz$draw, this.tacz$shoot);
    private final LivingEntityReload tacz$reload = new LivingEntityReload(this.tacz$shooter, this.tacz$data, this.tacz$draw, this.tacz$shoot);
    private final LivingEntitySpeedModifier tacz$speed = new LivingEntitySpeedModifier(this.tacz$shooter, this.tacz$data);
    private final LivingEntitySprint tacz$sprint = new LivingEntitySprint(this.tacz$shooter, this.tacz$data);
    public static final int SWAT_INVENTORY_SIZE = 36;
    public static final int SWAT_ARMOR_SIZE = 4;
    public static final int SWAT_OFFHAND_SIZE = 1;
    public static final int SWAT_CONTAINER_SIZE = 41;
    private static final int HOTBAR_INDEX_START = 0;
    private static final int HOTBAR_INDEX_END = 8;
    private static final int INV_INDEX_START = 9;
    private static final int INV_INDEX_END = 35;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armor = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> offhand = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final List<NonNullList<ItemStack>> compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    private int selected;

    protected SwatEntity(EntityType<SwatEntity> entityType, Level level) {
        super(entityType, level);
    }

    private static SwatEntity create(Level level, Specialty specialty, Mission mission) {
        SwatEntity entity = new SwatEntity((EntityType<SwatEntity>)((EntityType)ModEntities.SWAT_ENTITY.get()), level);
        entity.setSpecialty(specialty);
        entity.mission = mission;
        return entity;
    }

    public static SwatEntity commander(Level level, Mission mission) {
        SwatEntity entity = SwatEntity.create(level, Specialty.COMMANDER, mission);
        entity.squad = new ArrayList<SwatEntity>();
        return entity;
    }

    public static SwatEntity withSpecialty(Level level, Specialty specialty) {
        return SwatEntity.create(level, specialty, null);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (spawnType == MobSpawnType.SPAWNER) {
            this.setSpecialty(Specialty.getRandom());
        } else if (spawnType == MobSpawnType.COMMAND) {
            if (dataTag != null) {
                this.m_20258_(dataTag);
            }
        } else if (spawnType == MobSpawnType.SPAWN_EGG && dataTag != null && dataTag.m_128425_("EntityTag", 10)) {
            CompoundTag compoundtag = this.m_20240_(new CompoundTag());
            UUID uuid = this.m_20148_();
            compoundtag.m_128391_(dataTag.m_128469_("EntityTag"));
            this.m_20084_(uuid);
            this.m_20258_(compoundtag);
        }
        this.generateInventory();
        this.copySpecialAttributes();
        return spawnData;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.takeNextGun();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && player.m_7500_() && this.m_20147_() && player.m_21205_().m_150930_(Items.f_42423_)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return InteractionResult.SUCCESS;
        }
        if (this.getState() == 2) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new SwatCorpseMenu(id, inv, this), this.m_5677_()));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected boolean m_6107_() {
        return this.getState() != 0;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getSpecialty().getSpawnEgg();
    }

    public void m_5634_(float healAmount) {
        if (this.getState() == 2) {
            return;
        }
        super.m_5634_(healAmount);
        if (this.m_21223_() > 20.0f) {
            this.setState((byte)0);
            this.f_21345_.m_25374_(Goal.Flag.MOVE);
            this.m_21195_(MobEffects.f_19597_);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_7639_() instanceof SwatEntity) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float damageAmount) {
        float dmg = damageAmount;
        dmg = this.m_21161_(damageSource, dmg);
        dmg = this.m_6515_(damageSource, dmg);
        dmg = Math.max(dmg - this.m_6103_(), 0.0f);
        float hpAfterDmg = this.m_21223_() - dmg;
        if (hpAfterDmg <= 20.0f) {
            this.setState((byte)1);
            this.f_21345_.m_25355_(Goal.Flag.MOVE);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, Short.MAX_VALUE));
            if (hpAfterDmg <= 0.0f) {
                if (((Boolean)CommonConfig.SWAT_ENTITY_NO_CORPSE.get()).booleanValue()) {
                    this.compartments.forEach(comp -> comp.forEach(arg_0 -> ((SwatEntity)this).m_19983_(arg_0)));
                    this.m_6667_(damageSource);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    return;
                }
                this.setState((byte)2);
                this.m_20331_(true);
                this.m_21153_(1.0f);
                this.m_147272_();
                this.m_21219_();
                this.deadBodyAge = 0;
                return;
            }
        }
        super.m_6475_(damageSource, damageAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.tacz$data.isCrawling && (target == null || target.m_21224_() || this.getState() != 0)) {
            this.crawl(false);
        }
        if (!this.m_9236_().f_46443_) {
            this.taczTick();
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            if (this.getState() == 2) {
                this.deadBodyAge = (short)(this.deadBodyAge + 1);
                if (this.deadBodyAge >= (Integer)CommonConfig.SWAT_ENTITY_DEAD_BODY_LIFESPAN.get()) {
                    this.m_146870_();
                }
            }
            if (this.getSpecialty() == Specialty.COMMANDER && this.squad != null) {
                this.squad.removeIf(swat -> swat.m_213877_() || swat.getState() == 2);
                ++this.squadSummonTimer;
                if (this.mission != null && this.squadSummonTimer >= (Integer)CommonConfig.SWAT_ENTITY_SQUAD_SUMMON_COOLDOWN.get()) {
                    this.squadSummonTimer = 0;
                    List<Specialty> existingSpecs = this.squad.stream().map(SwatEntity::getSpecialty).toList();
                    List<Specialty> totalSpecs = this.mission.getParticipants();
                    ArrayList<Specialty> missingSpecs = new ArrayList<Specialty>(totalSpecs);
                    missingSpecs.removeAll(existingSpecs);
                    Vec3 pos = this.m_20182_();
                    for (Specialty spec : missingSpecs) {
                        SwatEntity squadMember = SwatEntity.withSpecialty((Level)serverLevel, spec);
                        squadMember.m_146884_(pos);
                        squadMember.m_6710_(target);
                        squadMember.commander = this;
                        ForgeEventFactory.onFinalizeSpawn((Mob)squadMember, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(BlockPos.m_274446_((Position)squadMember.m_20182_())), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                        if (!serverLevel.m_7967_((Entity)squadMember)) continue;
                        this.squad.add(squadMember);
                    }
                }
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_(NBT_KEY_SPECIALTY, this.getSpecialty().getName());
        nbt.m_128344_(NBT_KEY_STATE, this.getState());
        nbt.m_128405_(NBT_KEY_FAILED_GUN_POS_COUNTER, this.failedGunPosCounter);
        nbt.m_128405_(NBT_KEY_SQUAD_SUMMON_TIMER, this.squadSummonTimer);
        nbt.m_128376_(NBT_KEY_DEAD_BODY_AGE, this.deadBodyAge);
        if (this.mission != null) {
            nbt.m_128359_(NBT_KEY_MISSION, this.mission.getName());
        }
        if (this.squad != null) {
            ListTag squadTag = new ListTag();
            this.squad.forEach(swatEntity -> squadTag.add((Object)NbtUtils.m_129226_((UUID)swatEntity.m_20148_())));
            nbt.m_128365_(NBT_KEY_SQUAD, (Tag)squadTag);
        }
        if (this.commander != null) {
            nbt.m_128365_(NBT_KEY_COMMANDER, (Tag)NbtUtils.m_129226_((UUID)this.commander.m_20148_()));
        }
        nbt.m_128365_(NBT_KEY_INVENTORY, (Tag)this.saveCompartments(new ListTag()));
        nbt.m_128405_(NBT_KEY_SELECTED, this.selected);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        Level level;
        Mission mission;
        Specialty spec;
        super.m_7378_(nbt);
        if (nbt.m_128441_(NBT_KEY_SPECIALTY) && (spec = Specialty.byName(nbt.m_128461_(NBT_KEY_SPECIALTY))) != null) {
            this.setSpecialty(spec);
        }
        if (nbt.m_128441_(NBT_KEY_STATE)) {
            this.setState(nbt.m_128445_(NBT_KEY_STATE));
        }
        this.failedGunPosCounter = nbt.m_128451_(NBT_KEY_FAILED_GUN_POS_COUNTER);
        this.squadSummonTimer = nbt.m_128451_(NBT_KEY_SQUAD_SUMMON_TIMER);
        this.deadBodyAge = nbt.m_128448_(NBT_KEY_DEAD_BODY_AGE);
        if (nbt.m_128441_(NBT_KEY_MISSION) && (mission = Mission.byName(nbt.m_128461_(NBT_KEY_MISSION))) != null) {
            this.mission = mission;
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            Entity entity;
            ListTag squadTag;
            Tag tag;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.squad != null && (tag = nbt.m_128423_(NBT_KEY_SQUAD)) instanceof ListTag && !(squadTag = (ListTag)tag).isEmpty()) {
                for (Tag t : squadTag) {
                    Entity entity2 = serverLevel.m_8791_(NbtUtils.m_129233_((Tag)t));
                    if (!(entity2 instanceof SwatEntity)) continue;
                    SwatEntity swatEntity = (SwatEntity)entity2;
                    this.squad.add(swatEntity);
                }
            }
            if (this.getSpecialty() != Specialty.COMMANDER && (tag = nbt.m_128423_(NBT_KEY_COMMANDER)) != null && (entity = serverLevel.m_8791_(NbtUtils.m_129233_((Tag)tag))) instanceof SwatEntity) {
                SwatEntity swatEntity;
                this.commander = swatEntity = (SwatEntity)entity;
            }
        }
        this.loadCompartments(nbt.m_128437_(NBT_KEY_INVENTORY, 10));
        this.selected = nbt.m_128451_(NBT_KEY_SELECTED);
    }

    protected void m_8099_() {
        this.meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RetreatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PotionUseGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GunAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new GunPosGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        if (GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
            this.f_21345_.m_25352_(1, (Goal)new BreakDoorGoal((Mob)this, 120, d -> true));
        }
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SwatEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean hasMeleeAttackGoal() {
        return this.f_21345_.m_148105_().stream().anyMatch(wrap -> wrap.m_26015_() == this.meleeAttackGoal);
    }

    public static AttributeSupplier.Builder createDefaultAttributes() {
        return LivingEntity.m_21183_().m_22266_(Attributes.f_22277_).m_22266_(Attributes.f_22281_).m_22266_(Attributes.f_22282_).m_22266_(Attributes.f_22283_);
    }

    private void copySpecialAttributes() {
        Specialty spec = this.getSpecialty();
        for (Map.Entry<Attribute, ForgeConfigSpec.DoubleValue> e : CommonConfig.SPECIALTY_ATTRIBUTES.get((Object)spec).entrySet()) {
            Attribute attr = e.getKey();
            AttributeInstance inst = this.m_21204_().m_22146_(attr);
            if (inst == null) {
                SpecialForces.LOGGER.error("An error occurred when replacing attribute {} of specialty: {}", (Object)attr, (Object)spec);
                continue;
            }
            AttributeInstance newInst = new AttributeInstance(attr, a -> {});
            newInst.m_22100_(((Double)e.getValue().get()).doubleValue());
            inst.m_22102_(newInst);
        }
        this.m_21153_(this.m_21233_());
    }

    private void generateInventory() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(this.getSpecialty().getLootTable());
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287235_(LootContextParamSets.f_81410_);
        ObjectArrayList itemStacks = lootTable.m_287195_(lootParams);
        List<Integer> indices = this.getAvailableInvSlotsShuffled();
        Util.shuffleAndSplitItems((ObjectArrayList<ItemStack>)itemStacks, indices.size(), this.f_19796_);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            ItemStack itemStack = (ItemStack)itemStacks.remove(i);
            if (itemStack.m_204117_(ModTags.Items.RULE_HOTBAR) && this.getFreeHotbarIndex() != -1) {
                this.items.set(this.getFreeHotbarIndex(), (Object)itemStack);
                continue;
            }
            if (itemStack.canEquip(EquipmentSlot.HEAD, (Entity)this) && ((ItemStack)this.armor.get(0)).m_41619_()) {
                this.armor.set(0, (Object)itemStack);
                continue;
            }
            if (itemStack.canEquip(EquipmentSlot.CHEST, (Entity)this) && ((ItemStack)this.armor.get(1)).m_41619_()) {
                this.armor.set(1, (Object)itemStack);
                continue;
            }
            if (itemStack.canEquip(EquipmentSlot.LEGS, (Entity)this) && ((ItemStack)this.armor.get(2)).m_41619_()) {
                this.armor.set(2, (Object)itemStack);
                continue;
            }
            if (itemStack.canEquip(EquipmentSlot.FEET, (Entity)this) && ((ItemStack)this.armor.get(3)).m_41619_()) {
                this.armor.set(3, (Object)itemStack);
                continue;
            }
            if (itemStack.m_204117_(ModTags.Items.RULE_OFFHAND) && ((ItemStack)this.offhand.get(0)).m_41619_()) {
                this.offhand.set(0, (Object)itemStack);
                continue;
            }
            if (itemStack.m_41619_()) continue;
            this.items.set(indices.remove(indices.size() - 1).intValue(), (Object)itemStack);
        }
    }

    public void takeNextGun() {
        ArrayList<ItemStack> potentialNextGuns = new ArrayList<ItemStack>();
        HashMap<ItemStack, CommonGunIndex> potentialNextGunIndexes = new HashMap<ItemStack, CommonGunIndex>();
        HashMap<ItemStack, Integer> potentialNextGunIndices = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < this.items.size(); ++i) {
            Optional gunIndexOpt;
            ResourceLocation gunId;
            ItemStack gunItemStack = (ItemStack)this.items.get(i);
            CompoundTag nbt = gunItemStack.m_41784_();
            if (!nbt.m_128441_("GunId") || (gunId = ResourceLocation.m_135820_((String)nbt.m_128461_("GunId"))) == null || (gunIndexOpt = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId)).isEmpty() || !this.hasAmmoForGun(gunItemStack)) continue;
            CommonGunIndex gunIndex = (CommonGunIndex)gunIndexOpt.get();
            potentialNextGuns.add(gunItemStack);
            potentialNextGunIndexes.put(gunItemStack, gunIndex);
            potentialNextGunIndices.put(gunItemStack, i);
        }
        if (potentialNextGuns.isEmpty()) {
            return;
        }
        potentialNextGuns.sort((itemStack1, itemStack2) -> {
            CommonGunIndex gunIndex1 = (CommonGunIndex)potentialNextGunIndexes.get(itemStack1);
            CommonGunIndex gunIndex2 = (CommonGunIndex)potentialNextGunIndexes.get(itemStack2);
            int index1 = GUN_TYPE_ORDER.indexOf(gunIndex1.getType());
            int index2 = GUN_TYPE_ORDER.indexOf(gunIndex2.getType());
            return index1 - index2;
        });
        ItemStack nextGun = (ItemStack)potentialNextGuns.get(0);
        int index = (Integer)potentialNextGunIndices.get(nextGun);
        if (index > 8) {
            int hotbarIndex = this.getFreeHotbarIndex();
            if (hotbarIndex == -1) {
                hotbarIndex = this.f_19796_.m_188503_(9);
            }
            this.swapItems(index, hotbarIndex);
            index = hotbarIndex;
        }
        this.selected = index;
        this.currentGunAttackRadiusSqr = 0.0f;
        AttachmentCacheProperty prop = new AttachmentCacheProperty();
        prop.eval(nextGun, ((CommonGunIndex)potentialNextGunIndexes.get(nextGun)).getGunData());
        this.updateCacheProperty(prop);
        this.tacz$data.currentGunItem = () -> nextGun;
        float effectiveRange = ((Float)prop.getCache(EffectiveRangeModifier.ID)).floatValue();
        this.currentGunAttackRadiusSqr = (float)((double)(effectiveRange * effectiveRange) * (Double)CommonConfig.SWAT_ENTITY_EFFECTIVE_RANGE_MULT.get() * (Double)CommonConfig.SWAT_ENTITY_EFFECTIVE_RANGE_MULT.get());
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getSelectedItem();
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return (ItemStack)this.offhand.get(0);
        }
        if (slot.m_254934_()) {
            return (ItemStack)this.armor.get(3 - slot.m_20749_());
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot slot, @NotNull ItemStack itemStack) {
        this.m_181122_(itemStack);
        if (slot == EquipmentSlot.MAINHAND) {
            this.m_238392_(slot, (ItemStack)this.items.set(this.selected, (Object)itemStack), itemStack);
        } else if (slot == EquipmentSlot.OFFHAND) {
            this.m_238392_(slot, (ItemStack)this.offhand.set(0, (Object)itemStack), itemStack);
        } else if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.m_238392_(slot, (ItemStack)this.armor.set(3 - slot.m_20749_(), (Object)itemStack), itemStack);
        }
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return this.armor;
    }

    @NotNull
    public Iterable<ItemStack> m_6167_() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.m_21205_(), this.m_21206_()});
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_();
    }

    @NotNull
    protected Component m_5677_() {
        return this.getSpecialty().getTypeName();
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (pose == Pose.SWIMMING || this.getState() != 0) {
            return BOX_DIMENSIONS;
        }
        return super.m_6972_(pose);
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        if (pose == Pose.SWIMMING || this.getState() != 0) {
            return 0.4f;
        }
        return 1.62f;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (STATE.equals(key)) {
            this.m_6210_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPECIALTY, (Object)Specialty.COMMANDER);
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public Specialty getSpecialty() {
        return (Specialty)((Object)this.f_19804_.m_135370_(SPECIALTY));
    }

    private void setSpecialty(Specialty specialty) {
        this.f_19804_.m_135381_(SPECIALTY, (Object)specialty);
    }

    public byte getState() {
        return (Byte)this.f_19804_.m_135370_(STATE);
    }

    private void setState(byte state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public float getGunAttackRadiusSqr() {
        return this.currentGunAttackRadiusSqr;
    }

    public boolean hasMission() {
        return this.mission != null;
    }

    public boolean hasSquad() {
        return this.squad != null;
    }

    public Iterable<SwatEntity> getSquad() {
        return this.squad;
    }

    @Nullable
    public SwatEntity getCommander() {
        return this.commander;
    }

    public void summonSquadNextTick() {
        this.squadSummonTimer = (Integer)CommonConfig.SWAT_ENTITY_SQUAD_SUMMON_COOLDOWN.get();
    }

    public void incFailedGunPosCounter() {
        ++this.failedGunPosCounter;
    }

    public void resetFailedGunPosCounter() {
        this.failedGunPosCounter = 0;
    }

    public int getFailedGunPosCounter() {
        return this.failedGunPosCounter;
    }

    public long getSynShootCoolDown() {
        return (Long)ModSyncedEntityData.SHOOT_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public long getSynMeleeCoolDown() {
        return (Long)ModSyncedEntityData.MELEE_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public long getSynDrawCoolDown() {
        return (Long)ModSyncedEntityData.DRAW_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public boolean getSynIsBolting() {
        return (Boolean)ModSyncedEntityData.IS_BOLTING_KEY.getValue((Entity)this.tacz$shooter);
    }

    public ReloadState getSynReloadState() {
        return (ReloadState)ModSyncedEntityData.RELOAD_STATE_KEY.getValue((Entity)this.tacz$shooter);
    }

    public float getSynAimingProgress() {
        return ((Float)ModSyncedEntityData.AIMING_PROGRESS_KEY.getValue((Entity)this.tacz$shooter)).floatValue();
    }

    public boolean getSynIsAiming() {
        return (Boolean)ModSyncedEntityData.IS_AIMING_KEY.getValue((Entity)this.tacz$shooter);
    }

    public float getSynSprintTime() {
        return ((Float)ModSyncedEntityData.SPRINT_TIME_KEY.getValue((Entity)this.tacz$shooter)).floatValue();
    }

    public void initialData() {
        this.tacz$data.initialData();
        this.tacz$data.currentGunItem = () -> {
            ItemStack itemStack = this.m_21205_();
            if (itemStack.m_41720_() instanceof IGun) {
                return itemStack;
            }
            return null;
        };
    }

    public void draw(Supplier<ItemStack> gunItemSupplier) {
        this.tacz$draw.draw(gunItemSupplier);
    }

    public void bolt() {
        this.tacz$bolt.bolt();
    }

    public void reload() {
        this.tacz$reload.reload();
    }

    public void cancelReload() {
        this.tacz$reload.cancelReload();
    }

    public void melee() {
        this.tacz$melee.melee();
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw) {
        return this.shoot(pitch, yaw, System.currentTimeMillis() - this.tacz$data.baseTimestamp);
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw, long timestamp) {
        return this.tacz$shoot.shoot(pitch, yaw, timestamp);
    }

    public boolean needCheckAmmo() {
        return this.tacz$ammoCheck.needCheckAmmo();
    }

    public boolean consumesAmmoOrNot() {
        return this.tacz$ammoCheck.consumesAmmoOrNot();
    }

    public boolean getProcessedSprintStatus(boolean sprint) {
        return this.tacz$sprint.getProcessedSprintStatus(sprint);
    }

    public void aim(boolean isAim) {
        this.tacz$aim.aim(isAim);
    }

    public void crawl(boolean isCrawl) {
        this.tacz$crawl.crawl(isCrawl);
    }

    public void updateCacheProperty(AttachmentCacheProperty cacheProperty) {
        this.tacz$data.cacheProperty = cacheProperty;
    }

    @Nullable
    public AttachmentCacheProperty getCacheProperty() {
        return this.tacz$data.cacheProperty;
    }

    public ShooterDataHolder getDataHolder() {
        return this.tacz$data;
    }

    public boolean nextBulletIsTracer(int tracerCountInterval) {
        ++this.tacz$data.shootCount;
        if (tracerCountInterval == -1) {
            return false;
        }
        return this.tacz$data.shootCount % (tracerCountInterval + 1) == 0;
    }

    public void fireSelect() {
        this.tacz$fireSelect.fireSelect();
    }

    public void zoom() {
        this.tacz$aim.zoom();
    }

    private void taczTick() {
        ReloadState reloadState = this.tacz$reload.tickReloadState();
        this.tacz$aim.tickAimingProgress();
        this.tacz$aim.tickSprint();
        this.tacz$crawl.tickCrawling();
        this.tacz$bolt.tickBolt();
        this.tacz$melee.scheduleTickMelee();
        this.tacz$speed.updateSpeedModifier();
        this.tacz$shooter.m_6858_(this.getProcessedSprintStatus(this.tacz$shooter.m_20142_()));
        ModSyncedEntityData.SHOOT_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$shoot.getShootCoolDown());
        ModSyncedEntityData.MELEE_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$melee.getMeleeCoolDown());
        ModSyncedEntityData.DRAW_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$draw.getDrawCoolDown());
        ModSyncedEntityData.IS_BOLTING_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$data.isBolting);
        ModSyncedEntityData.RELOAD_STATE_KEY.setValue((Entity)this.tacz$shooter, (Object)reloadState);
        ModSyncedEntityData.AIMING_PROGRESS_KEY.setValue((Entity)this.tacz$shooter, (Object)Float.valueOf(this.tacz$data.aimingProgress));
        ModSyncedEntityData.IS_AIMING_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$data.isAiming);
        ModSyncedEntityData.SPRINT_TIME_KEY.setValue((Entity)this.tacz$shooter, (Object)Float.valueOf(this.tacz$data.sprintTimeS));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    }

    public int m_6643_() {
        return 41;
    }

    public boolean m_7983_() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            for (ItemStack itemStack : compartment) {
                if (itemStack.m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        NonNullList<ItemStack> compartment = this.getCompartment(index);
        return compartment == null ? ItemStack.f_41583_ : SwatEntity.compartmentSafeGet(compartment, index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        if (count <= 0) {
            return ItemStack.f_41583_;
        }
        NonNullList<ItemStack> compartment = this.getCompartment(index);
        if (compartment == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = SwatEntity.compartmentSafeGet(compartment, index);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return itemStack.m_41620_(count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        NonNullList<ItemStack> compartment = this.getCompartment(index);
        if (compartment == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = SwatEntity.compartmentSafeGet(compartment, index);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        compartment.set(index, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int index, @NotNull ItemStack itemStack) {
        NonNullList<ItemStack> compartment = this.getCompartment(index);
        if (compartment != null) {
            SwatEntity.compartmentSafeSet(compartment, index, itemStack);
        }
    }

    private int getFreeHotbarIndex() {
        for (int i = 0; i <= 8; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void setSelected(int index) {
        this.selected = index;
    }

    public ItemStack getSelectedItem() {
        if (0 <= this.selected && this.selected <= 8) {
            return (ItemStack)this.items.get(this.selected);
        }
        return ItemStack.f_41583_;
    }

    private int getFreeInvIndex() {
        for (int i = 9; i <= 35; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private ListTag saveCompartments(ListTag listTag) {
        CompoundTag slot;
        ItemStack itemStack;
        int index;
        for (index = 0; index < this.items.size(); ++index) {
            itemStack = (ItemStack)this.items.get(index);
            if (itemStack.m_41619_()) continue;
            slot = new CompoundTag();
            slot.m_128344_(NBT_KEY_SLOT, (byte)index);
            itemStack.m_41739_(slot);
            listTag.add((Object)slot);
        }
        for (index = 0; index < this.armor.size(); ++index) {
            itemStack = (ItemStack)this.armor.get(index);
            if (itemStack.m_41619_()) continue;
            slot = new CompoundTag();
            slot.m_128344_(NBT_KEY_SLOT, (byte)(index + 100));
            itemStack.m_41739_(slot);
            listTag.add((Object)slot);
        }
        for (index = 0; index < this.offhand.size(); ++index) {
            itemStack = (ItemStack)this.offhand.get(index);
            if (itemStack.m_41619_()) continue;
            slot = new CompoundTag();
            slot.m_128344_(NBT_KEY_SLOT, (byte)(index + 150));
            itemStack.m_41739_(slot);
            listTag.add((Object)slot);
        }
        return listTag;
    }

    private void loadCompartments(ListTag listTag) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag slot = listTag.m_128728_(i);
            int index = slot.m_128445_(NBT_KEY_SLOT) & 0xFF;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)slot);
            if (itemStack.m_41619_()) continue;
            if (index < this.items.size()) {
                this.items.set(index, (Object)itemStack);
                continue;
            }
            if (100 <= index && index < this.armor.size() + 100) {
                this.armor.set(index - 100, (Object)itemStack);
                continue;
            }
            if (150 > index || index >= this.offhand.size() + 150) continue;
            this.offhand.set(index - 150, (Object)itemStack);
        }
    }

    private List<Integer> getAvailableInvSlotsShuffled() {
        ObjectArrayList indices = new ObjectArrayList();
        for (int i = 9; i <= 35; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            indices.add((Object)i);
        }
        net.minecraft.Util.m_214673_((ObjectArrayList)indices, (RandomSource)this.f_19796_);
        return indices;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack itemStacks) {
        return false;
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return !this.m_213877_() && this.m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }

    public void m_6211_() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    public void swapItems(int index1, int index2) {
        if (index1 < 0 || index1 >= this.items.size()) {
            return;
        }
        if (index2 < 0 || index2 >= this.items.size()) {
            return;
        }
        ItemStack temp = (ItemStack)this.items.get(index1);
        this.items.set(index1, (Object)((ItemStack)this.items.get(index2)));
        this.items.set(index2, (Object)temp);
    }

    public boolean hasAmmoForGun(ItemStack gunItemStack) {
        for (ItemStack ammoItemStack : this.items) {
            IAmmo iAmmo;
            Item ammoItem = ammoItemStack.m_41720_();
            if (ammoItem instanceof IAmmo && (iAmmo = (IAmmo)ammoItem).isAmmoOfGun(gunItemStack, ammoItemStack)) {
                return true;
            }
            if (!(ammoItem instanceof IAmmoBox)) continue;
            IAmmoBox iAmmoBox = (IAmmoBox)ammoItem;
            if (iAmmoBox.isAllTypeCreative(ammoItemStack) || iAmmoBox.isCreative(ammoItemStack)) {
                return true;
            }
            if (!iAmmoBox.isAmmoBoxOfGun(gunItemStack, ammoItemStack)) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getIndicesWithItem(Item item) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i <= 35; ++i) {
            if (!((ItemStack)this.items.get(i)).m_150930_(item)) continue;
            indices.add(i);
        }
        return indices;
    }

    @Nullable
    private NonNullList<ItemStack> getCompartment(int index) {
        NonNullList<ItemStack> ret = null;
        for (NonNullList<ItemStack> compartment : this.compartments) {
            if (index < compartment.size()) {
                ret = compartment;
                break;
            }
            index -= compartment.size();
        }
        return ret;
    }

    private static ItemStack compartmentSafeGet(NonNullList<ItemStack> compartment, int index) {
        return (ItemStack)compartment.get(index % compartment.size());
    }

    private static void compartmentSafeSet(NonNullList<ItemStack> compartment, int index, ItemStack itemStack) {
        compartment.set(index % compartment.size(), (Object)itemStack);
    }

    public int m_6893_() {
        return super.m_6893_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new SwatCorpseMenu(containerId, playerInventory, this);
    }
}

