/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.entities.goals;

import com.tacz.guns.api.entity.ShootResult;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import su.uTa4u.specialforces.config.CommonConfig;
import su.uTa4u.specialforces.entities.SwatEntity;

public class GunAttackGoal
extends Goal {
    private final SwatEntity shooter;
    private int lastAttackTick = 0;
    private boolean isAimingAtHead = false;
    private float bulletPitch;
    private float bulletYaw;

    public GunAttackGoal(SwatEntity shooter) {
        this.shooter = shooter;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.shooter.m_5448_();
        return target != null && !target.m_21224_() && !(this.shooter.m_20280_((Entity)target) > (double)this.shooter.getGunAttackRadiusSqr()) && this.shooter.m_142582_((Entity)target);
    }

    public void m_8056_() {
        this.shooter.aim(true);
        this.shooter.m_21561_(true);
    }

    public void m_8041_() {
        LivingEntity target = this.shooter.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.shooter.m_6710_(null);
        }
        this.shooter.aim(false);
        this.shooter.m_21561_(false);
    }

    public void m_8037_() {
        LivingEntity target = this.shooter.m_5448_();
        if (target == null || target.m_21224_()) {
            return;
        }
        double targetX = target.m_20185_();
        double targetY = this.isAimingAtHead ? target.m_20188_() : GunAttackGoal.getBodyY((Entity)target);
        double targetZ = target.m_20189_();
        this.shooter.m_21563_().m_24946_(targetX, targetY, targetZ);
        if (this.shooter.f_19797_ - this.lastAttackTick < (Integer)CommonConfig.GUN_ATTACK_COOLDOWN.get()) {
            return;
        }
        this.lastAttackTick = this.shooter.f_19797_;
        this.computeBulletPitchYaw(targetX, targetY, targetZ);
        ShootResult result = this.shooter.shoot(() -> Float.valueOf(this.bulletPitch), () -> Float.valueOf(this.bulletYaw));
        if (result == ShootResult.NO_AMMO) {
            if (this.shooter.hasAmmoForGun(this.shooter.getSelectedItem())) {
                this.shooter.reload();
            } else {
                this.shooter.takeNextGun();
            }
        }
        this.isAimingAtHead = this.shooter.m_217043_().m_188501_() < this.shooter.getSpecialty().getHeadAimChance();
    }

    public boolean m_183429_() {
        return true;
    }

    private void computeBulletPitchYaw(double targetX, double targetY, double targetZ) {
        RandomSource rng = this.shooter.m_217043_();
        double lookOffset = (double)(3 - this.shooter.m_9236_().m_46791_().m_19028_() + 2) * 0.15;
        double lookX = (targetX += Mth.m_216263_((RandomSource)rng, (double)(-lookOffset), (double)lookOffset)) - this.shooter.m_20185_();
        double lookZ = (targetZ += Mth.m_216263_((RandomSource)rng, (double)(-lookOffset), (double)lookOffset)) - this.shooter.m_20189_();
        double lookY = (targetY += Mth.m_216263_((RandomSource)rng, (double)(-lookOffset), (double)lookOffset)) - this.shooter.m_20188_();
        double lookD = Math.sqrt(lookX * lookX + lookZ * lookZ);
        float bulletYaw = (float)(Mth.m_14136_((double)lookZ, (double)lookX) * 57.2957763671875) - 90.0f;
        float bulletPitch = (float)(-(Mth.m_14136_((double)lookY, (double)lookD) * 57.2957763671875));
        this.bulletYaw = GunAttackGoal.rotateTowards(this.shooter.m_6080_(), bulletYaw, this.shooter.m_21529_());
        this.bulletPitch = GunAttackGoal.rotateTowards(this.shooter.m_146909_(), bulletPitch, this.shooter.m_8132_());
    }

    private static float rotateTowards(float from, float to, float max) {
        float f = Mth.m_14118_((float)from, (float)to);
        f = Mth.m_14036_((float)f, (float)(-max), (float)max);
        return from + f;
    }

    private static double getBodyY(Entity entity) {
        return (entity.m_20191_().f_82289_ + entity.m_20191_().f_82292_) / 2.0;
    }
}

