/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.entities.goals;

import com.tacz.guns.api.item.IGun;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import su.uTa4u.specialforces.Specialty;
import su.uTa4u.specialforces.config.CommonConfig;
import su.uTa4u.specialforces.entities.SwatEntity;

public class GunPosGoal
extends Goal {
    private final SwatEntity shooter;
    private Vec3 posToTake;
    private int holdPosTimer = 0;

    public GunPosGoal(SwatEntity shooter) {
        this.shooter = shooter;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!(this.shooter.m_21205_().m_41720_() instanceof IGun)) {
            return false;
        }
        ++this.holdPosTimer;
        if (this.holdPosTimer < (Integer)CommonConfig.SWAT_ENTITY_HOLD_POSITION_DURATION.get()) {
            return false;
        }
        this.holdPosTimer = 0;
        LivingEntity target = this.shooter.m_5448_();
        if (target == null || target.m_21224_()) {
            return false;
        }
        double dist = this.shooter.m_20280_((Entity)target);
        if (dist > (double)this.shooter.getGunAttackRadiusSqr()) {
            this.posToTake = target.m_20182_();
            return true;
        }
        if (!this.shooter.m_142582_((Entity)target)) {
            List<BlockPos> haveLineOfSight = this.posWithLineOfSight();
            List<BlockPos> haveLineOfSightAndPath = haveLineOfSight.stream().filter(this::hasNavPath).toList();
            Vec3 posToTake = null;
            if (!haveLineOfSightAndPath.isEmpty()) {
                BlockPos pos = haveLineOfSightAndPath.get(0);
                posToTake = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
            if (posToTake != null) {
                this.posToTake = posToTake;
                return true;
            }
            this.shooter.incFailedGunPosCounter();
            if (this.shooter.getFailedGunPosCounter() >= (Integer)CommonConfig.SWAT_ENTITY_FAILED_GUN_POS_LIMIT.get()) {
                this.shooter.resetFailedGunPosCounter();
                Vec3 tpPos = null;
                if (this.shooter.getSpecialty() == Specialty.COMMANDER) {
                    for (SwatEntity swat : this.shooter.getSquad()) {
                        if (!swat.m_142582_((Entity)target)) continue;
                        tpPos = swat.m_20182_();
                        break;
                    }
                } else {
                    SwatEntity commander = this.shooter.getCommander();
                    if (commander != null) {
                        for (SwatEntity swat : commander.getSquad()) {
                            if (!swat.m_142582_((Entity)target)) continue;
                            tpPos = swat.m_20182_();
                            break;
                        }
                    }
                }
                if (tpPos == null && !haveLineOfSight.isEmpty()) {
                    BlockPos pos = haveLineOfSight.get(0);
                    tpPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                }
                if (tpPos != null) {
                    this.shooter.m_146884_(tpPos);
                }
            }
            return false;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.shooter.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.shooter.m_21573_().m_26519_(this.posToTake.f_82479_, this.posToTake.f_82480_, this.posToTake.f_82481_, 1.0);
    }

    public void m_8041_() {
        this.posToTake = null;
    }

    private List<BlockPos> posWithLineOfSight() {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121925_((BlockPos)this.shooter.m_20183_(), (int)8, (int)4, (int)8)) {
            if (!this.hasLineOfSight(pos)) continue;
            ret.add(pos);
        }
        return ret;
    }

    private boolean hasNavPath(BlockPos pos) {
        return this.shooter.m_21573_().m_7864_(pos, 1) != null;
    }

    private boolean hasLineOfSight(BlockPos pos) {
        LivingEntity target = this.shooter.m_5448_();
        if (target == null || target.m_21224_()) {
            return false;
        }
        Vec3 posVec3 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Vec3 targetVec3 = target.m_20182_();
        if (targetVec3.m_82557_(posVec3) > 16384.0) {
            return false;
        }
        return this.shooter.m_9236_().m_45547_(new ClipContext(posVec3, targetVec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target)).m_6662_() == HitResult.Type.MISS;
    }
}

