/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.entities.goals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import su.uTa4u.specialforces.Specialty;
import su.uTa4u.specialforces.entities.SwatEntity;

public class PotionUseGoal
extends Goal {
    private static final UUID SPEED_MODIFIER_DRINKING_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_UUID, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final Map<Predicate<SwatEntity>, MobEffect> POSSIBLE_EFFECTS = new HashMap<Predicate<SwatEntity>, MobEffect>();
    private final SwatEntity swat;
    private int potionIndex = -1;

    public PotionUseGoal(SwatEntity swat) {
        this.swat = swat;
    }

    public boolean m_8036_() {
        if (this.swat.getState() == 2) {
            return false;
        }
        List<Integer> indices = this.swat.getIndicesWithItem(Items.f_42589_);
        if (indices.isEmpty()) {
            return false;
        }
        for (Predicate<SwatEntity> p : POSSIBLE_EFFECTS.keySet()) {
            int index;
            if (this.swat.m_21023_(POSSIBLE_EFFECTS.get(p)) || !p.test(this.swat) || (index = this.findPotionIndex(indices, POSSIBLE_EFFECTS.get(p))) == -1) continue;
            this.potionIndex = index;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.swat.m_21212_() > 0;
    }

    public void m_8056_() {
        AttributeInstance attr;
        this.swat.setSelected(this.potionIndex);
        if (!this.swat.m_20067_()) {
            this.swat.m_9236_().m_6263_(null, this.swat.m_20185_(), this.swat.m_20186_(), this.swat.m_20189_(), SoundEvents.f_12551_, this.swat.m_5720_(), 1.0f, 0.8f + this.swat.m_217043_().m_188501_() * 0.4f);
        }
        if ((attr = this.swat.m_21051_(Attributes.f_22279_)) != null) {
            attr.m_22130_(SPEED_MODIFIER_DRINKING);
            attr.m_22118_(SPEED_MODIFIER_DRINKING);
        }
        this.swat.m_6672_(InteractionHand.MAIN_HAND);
    }

    public void m_8041_() {
        this.potionIndex = -1;
        AttributeInstance attr = this.swat.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22130_(SPEED_MODIFIER_DRINKING);
        }
        this.swat.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42590_));
        this.swat.takeNextGun();
    }

    public void m_8037_() {
    }

    private int findPotionIndex(List<Integer> indices, MobEffect effect) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i : indices) {
            if (!this.hasEffect(PotionUtils.m_43579_((ItemStack)this.swat.m_8020_(i)), effect)) continue;
            res.add(i);
        }
        if (res.isEmpty()) {
            return -1;
        }
        return (Integer)res.get(this.swat.m_217043_().m_188503_(res.size()));
    }

    private boolean hasEffect(Potion potion, MobEffect effect) {
        for (MobEffectInstance e : potion.m_43488_()) {
            if (e.m_19544_() != effect) continue;
            return true;
        }
        return false;
    }

    static {
        POSSIBLE_EFFECTS.put(swat -> swat.m_21223_() < swat.m_21233_() / 2.0f, MobEffects.f_19601_);
        POSSIBLE_EFFECTS.put(swat -> swat.m_21223_() < swat.m_21233_() * 3.0f / 4.0f, MobEffects.f_19605_);
        POSSIBLE_EFFECTS.put(swat -> swat.m_6060_(), MobEffects.f_19607_);
        POSSIBLE_EFFECTS.put(swat -> swat.m_5842_(), MobEffects.f_19608_);
        POSSIBLE_EFFECTS.put(swat -> swat.f_19789_ > 10.0f, MobEffects.f_19591_);
        POSSIBLE_EFFECTS.put(swat -> swat.m_9236_().m_46462_(), MobEffects.f_19611_);
        POSSIBLE_EFFECTS.put(swat -> swat.hasMeleeAttackGoal(), MobEffects.f_19600_);
        POSSIBLE_EFFECTS.put(swat -> swat.getSpecialty() == Specialty.SPY, MobEffects.f_19609_);
        POSSIBLE_EFFECTS.put(swat -> swat.getSpecialty() == Specialty.BULLDOZER, MobEffects.f_19606_);
        POSSIBLE_EFFECTS.put(swat -> swat.getSpecialty() == Specialty.SCOUT, MobEffects.f_19603_);
        POSSIBLE_EFFECTS.put(swat -> swat.getSpecialty() == Specialty.MEDIC, MobEffects.f_19596_);
        POSSIBLE_EFFECTS.put(swat -> swat.getSpecialty() == Specialty.ENGINEER, MobEffects.f_19598_);
        POSSIBLE_EFFECTS.put(swat -> swat.m_21223_() == swat.m_21233_(), MobEffects.f_19616_);
    }
}

