/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.specialforces.glms;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AddItemsModifier
extends LootModifier {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Supplier<Codec<AddItemsModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(m -> m.entries)).apply((Applicative)inst, AddItemsModifier::new)));
    private final List<Entry> entries;

    public AddItemsModifier(LootItemCondition[] conditions, List<Entry> entries) {
        super(conditions);
        this.entries = entries;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)lootContext)) continue;
            return generatedLoot;
        }
        for (Entry entry : this.entries) {
            CompoundTag nbt;
            ItemStack toAdd = new ItemStack((ItemLike)entry.item, entry.count);
            try {
                nbt = TagParser.m_129359_((String)entry.nbt);
            }
            catch (CommandSyntaxException e) {
                nbt = null;
                LOGGER.error(e.getMessage());
            }
            toAdd.m_41751_(nbt);
            generatedLoot.add((Object)toAdd);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("count", (Object)1).forGetter(m -> m.count), (App)Codec.STRING.optionalFieldOf("nbt", (Object)"{}").forGetter(m -> m.nbt), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, Entry::new));
        private final Item item;
        private final int count;
        private final String nbt;
        private final float chance;

        public Entry(Item item, int count, String nbt, float chance) {
            this.item = item;
            this.count = count;
            this.nbt = nbt;
            this.chance = chance;
        }
    }
}

