/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded;

import io.github.steaf23.bingoreloaded.data.BingoLobby;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoSound;
import io.github.steaf23.bingoreloaded.data.BingoStatData;
import io.github.steaf23.bingoreloaded.data.BingoStatType;
import io.github.steaf23.bingoreloaded.data.DefaultKitData;
import io.github.steaf23.bingoreloaded.data.TeamData;
import io.github.steaf23.bingoreloaded.data.TexturedMenuData;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.data.helper.SerializablePlayer;
import io.github.steaf23.bingoreloaded.data.serializers.BingoLobbySerializer;
import io.github.steaf23.bingoreloaded.data.serializers.BingoSettingsStorageSerializer;
import io.github.steaf23.bingoreloaded.data.serializers.CustomKitStorageSerializer;
import io.github.steaf23.bingoreloaded.data.serializers.DefaultKitStorageSerializer;
import io.github.steaf23.bingoreloaded.data.serializers.ItemStorageSerializer;
import io.github.steaf23.bingoreloaded.data.serializers.PlayerStorageSerializer;
import io.github.steaf23.bingoreloaded.data.serializers.TeamTemplateStorageSerializer;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.gameloop.SingularGameManager;
import io.github.steaf23.bingoreloaded.lib.api.BingoReloadedRuntime;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializerRegistry;
import io.github.steaf23.bingoreloaded.lib.data.core.VirtualDataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.serializers.StatisticSerializer;
import io.github.steaf23.bingoreloaded.lib.item.SerializableItem;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.DebugLogger;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.CustomKit;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.GameTaskSerializer;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import io.github.steaf23.bingoreloaded.tasks.data.TaskStorageSerializer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.key.Namespaced;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public class BingoReloaded
implements Namespaced {
    public static final String RESOURCE_PACK_URL = "https://github.com/Steaf23/BingoReloaded/raw/menu-frontend-split-for-resource-pack/resourcepack/BingoReloaded.zip";
    public static final String RESOURCE_PACK_HASH = "6fb0aa69a5c6076eb8d55d964493195588676301";
    public static final ResourcePackInfo RESOURCE_PACK = ResourcePackInfo.resourcePackInfo().uri(URI.create("https://github.com/Steaf23/BingoReloaded/raw/menu-frontend-split-for-resource-pack/resourcepack/BingoReloaded.zip")).hash("6fb0aa69a5c6076eb8d55d964493195588676301").build();
    public static final String CARD_1_21 = "lists_1_21";
    public static final int ONE_SECOND = 20;
    private static BingoReloaded INSTANCE;
    private final ServerSoftware platform = PlatformResolver.get();
    private final BingoReloadedRuntime runtime;
    private BingoConfigurationData config;
    private GameManager gameManager;
    private TexturedMenuData textureData;
    private boolean useResourcePack = false;
    private static final Map<String, DataAccessor> accessorMap;

    BingoReloaded(BingoReloadedRuntime runtime) {
        this.runtime = runtime;
    }

    public void load() {
        INSTANCE = this;
        DebugLogger.setupLogger(this.platform);
    }

    public void enable() {
        this.runtime.setupConfig();
        DataStorageSerializerRegistry.addSerializer(new DefaultKitStorageSerializer(), DefaultKitData.Kit.class);
        DataStorageSerializerRegistry.addSerializer(new CustomKitStorageSerializer(), CustomKit.class);
        DataStorageSerializerRegistry.addSerializer(new TaskStorageSerializer(), TaskData.class);
        DataStorageSerializerRegistry.addSerializer(new PlayerStorageSerializer(), SerializablePlayer.class);
        DataStorageSerializerRegistry.addSerializer(new TeamTemplateStorageSerializer(), TeamData.TeamTemplate.class);
        DataStorageSerializerRegistry.addSerializer(new BingoSettingsStorageSerializer(), BingoSettings.class);
        DataStorageSerializerRegistry.addSerializer(new StatisticSerializer(), StatisticHandle.class);
        DataStorageSerializerRegistry.addSerializer(new ItemStorageSerializer(), SerializableItem.class);
        DataStorageSerializerRegistry.addSerializer(new GameTaskSerializer(), GameTask.class);
        DataStorageSerializerRegistry.addSerializer(new BingoLobbySerializer(), BingoLobby.class);
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/cards", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/textures", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/default_kits", true));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/kits", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/default_lists", true));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/" + BingoReloaded.getDefaultTasksVersion(), false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/presets", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/player_stats", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/teams", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/players", false));
        BingoReloaded.addDataAccessor(new TagDataAccessor(this.platform, "data/lobby", false));
        for (DataAccessor accessor : this.runtime.getDataToRegister()) {
            BingoReloaded.addDataAccessor(accessor);
        }
        this.config = new BingoConfigurationData(this.runtime.getConfigData());
        this.runtime.onConfigReloaded(this.config);
        DebugLogger.setLoggingEnabled(this.config.getOptionValue(BingoOptions.ENABLE_DEBUG_LOGGING));
        this.useResourcePack = this.config.getOptionValue(BingoOptions.USE_INCLUDED_RESOURCE_PACK);
        String language = this.config.getOptionValue(BingoOptions.LANGUAGE).replace(".yml", "");
        this.setLanguage(language);
        BingoSound.setSounds(BingoReloaded.getDataAccessor("sounds"));
        this.textureData = new TexturedMenuData();
        this.reloadManager();
        ConsoleMessenger.log(Component.text("Enabled " + this.platform.getExtensionInfo().name()).color(NamedTextColor.GREEN));
    }

    public void disable() {
        if (this.gameManager != null) {
            this.gameManager.onPluginDisable();
        }
    }

    public BingoConfigurationData config() {
        return this.config;
    }

    public static void incrementPlayerStat(PlayerHandle player, BingoStatType stat) {
        boolean savePlayerStatistics = BingoReloaded.INSTANCE.config.getOptionValue(BingoOptions.SAVE_PLAYER_STATISTICS);
        if (savePlayerStatistics) {
            BingoStatData statsData = new BingoStatData(BingoReloaded.INSTANCE.platform);
            statsData.incrementPlayerStat(player, stat);
        }
    }

    public static void setPlayerStat(PlayerHandle player, BingoStatType stat, int value) {
        boolean savePlayerStatistics = BingoReloaded.INSTANCE.config.getOptionValue(BingoOptions.SAVE_PLAYER_STATISTICS);
        if (savePlayerStatistics) {
            BingoStatData statsData = new BingoStatData(BingoReloaded.INSTANCE.platform);
            statsData.setPlayerStat(player.uniqueId(), stat, value);
        }
    }

    public static int getPlayerStat(PlayerHandle player, BingoStatType stat) {
        boolean savePlayerStatistics = BingoReloaded.INSTANCE.config.getOptionValue(BingoOptions.SAVE_PLAYER_STATISTICS);
        if (savePlayerStatistics) {
            BingoStatData statsData = new BingoStatData(BingoReloaded.INSTANCE.platform);
            return statsData.getPlayerStat(player.uniqueId(), stat);
        }
        return 0;
    }

    public static String getDefaultTasksVersion() {
        return CARD_1_21;
    }

    public static void sendResourcePack(PlayerHandle player) {
        if (!BingoReloaded.useResourcePack()) {
            return;
        }
        player.sendResourcePacks((ResourcePackRequest)ResourcePackRequest.resourcePackRequest().packs(RESOURCE_PACK, new ResourcePackInfoLike[0]).required(true).build());
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public static TexturedMenuData getTextureData() {
        return BingoReloaded.INSTANCE.textureData;
    }

    @NotNull
    public static DataAccessor getDataAccessor(@NotNull String location) {
        if (location.isEmpty()) {
            ConsoleMessenger.bug("No location specified for data accessor, returning empty data accessor.", (Object)INSTANCE);
            return new VirtualDataAccessor(location);
        }
        if (!accessorMap.containsKey(location)) {
            ConsoleMessenger.bug("No data accessor exists for the specified location (" + location + "), returning empty data accessor.", (Object)INSTANCE);
            return new VirtualDataAccessor(location);
        }
        return accessorMap.get(location);
    }

    public static DataAccessor addDataAccessor(DataAccessor accessor) {
        if (!BingoReloaded.containsDataAccessor(accessor.getLocation())) {
            accessorMap.put(accessor.getLocation(), accessor);
        }
        accessor.load();
        return accessor;
    }

    public static boolean containsDataAccessor(String name) {
        return accessorMap.containsKey(name);
    }

    public void reloadConfigFromFile() {
        this.runtime.setupConfig();
        this.config.reload();
        this.runtime.onConfigReloaded(this.config);
        DebugLogger.setLoggingEnabled(this.config.getOptionValue(BingoOptions.ENABLE_DEBUG_LOGGING));
    }

    public void reloadScoreboards() {
        BingoReloaded.getDataAccessor("scoreboards").load();
    }

    public void reloadPlaceholders() {
        BingoReloaded.getDataAccessor("placeholders").load();
    }

    public void reloadSounds() {
        DataAccessor data = BingoReloaded.getDataAccessor("sounds");
        data.load();
        BingoSound.setSounds(data);
    }

    public void reloadData() {
        BingoReloaded.getDataAccessor("data/cards").load();
        BingoReloaded.getDataAccessor("data/textures").load();
        BingoReloaded.getDataAccessor("data/kits").load();
        BingoReloaded.getDataAccessor("data/default_lists").load();
        BingoReloaded.getDataAccessor("data/" + BingoReloaded.getDefaultTasksVersion()).load();
        BingoReloaded.getDataAccessor("data/presets").load();
        BingoReloaded.getDataAccessor("data/player_stats").load();
        BingoReloaded.getDataAccessor("data/teams").load();
        BingoReloaded.getDataAccessor("data/players").load();
        BingoReloaded.getDataAccessor("data/lobby").load();
    }

    public void reloadLanguage() {
        ConsoleMessenger.warn("Reloading languages, however due to how plugins are loaded this may not affect all text");
        ConsoleMessenger.warn("To fully reload the languages restart the server.");
        String selectedLanguage = this.config.getOptionValue(BingoOptions.LANGUAGE);
        String langString = selectedLanguage.replace(".yml", "");
        this.setLanguage(langString);
    }

    public void setLanguage(String language) {
        if (this.platform.getResource((String)(language = "languages/" + (String)language) + ".yml") != null) {
            BingoMessage.setLanguage(this.runtime.getLanguageData((String)language));
            this.runtime.onLanguageUpdated();
            ConsoleMessenger.log(BingoMessage.CHANGED_LANGUAGE.asPhrase(new Component[0]).color(NamedTextColor.GREEN));
        } else {
            ConsoleMessenger.error("Could not set language, a translation for language '" + (String)language + "' could not be found!");
        }
    }

    public void reloadManager() {
        if (this.gameManager != null) {
            for (String name : this.gameManager.getSessionNames()) {
                this.gameManager.endGame(name);
                for (UUID playerId : this.gameManager.getPlayerData().getSavedPlayers()) {
                    PlayerHandle player = this.platform.getPlayerFromUniqueId(playerId);
                    if (player == null) continue;
                    this.gameManager.getPlayerData().loadPlayer(player);
                }
                this.gameManager.destroySession(name);
            }
            this.gameManager.onPluginDisable();
        }
        this.gameManager = this.config.getOptionValue(BingoOptions.CONFIGURATION) == BingoOptions.PluginConfiguration.SINGULAR ? new SingularGameManager(this.runtime, this.config) : new GameManager(this.runtime, this.config);
        this.gameManager.setup(this.config.getOptionValue(BingoOptions.DEFAULT_WORLDS));
        this.runtime.registerActions(this.config);
    }

    @Override
    @KeyPattern.Namespace
    @NotNull
    public String namespace() {
        return "bingoreloaded";
    }

    public static Key resourceKey(@Subst(value="value") String value) {
        return Key.key(INSTANCE, value);
    }

    public static Component applyTitleFormat(Component to) {
        return to.color(NamedTextColor.GOLD).decorate(TextDecoration.BOLD);
    }

    public static Component applyTitleFormat(String to) {
        return ((TextComponent)Component.text(to).color(NamedTextColor.GOLD)).decorate(TextDecoration.BOLD);
    }

    public static BingoReloadedRuntime runtime() {
        return BingoReloaded.INSTANCE.runtime;
    }

    public static boolean useResourcePack() {
        return BingoReloaded.INSTANCE.useResourcePack;
    }

    static {
        accessorMap = new HashMap<String, DataAccessor>();
    }
}

