/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.protocol.dialog.Dialog;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerShowDialog;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.action.AutoBingoAction;
import io.github.steaf23.bingoreloaded.action.BingoAction;
import io.github.steaf23.bingoreloaded.action.BingoConfigAction;
import io.github.steaf23.bingoreloaded.action.BotCommandAction;
import io.github.steaf23.bingoreloaded.action.CommandTemplate;
import io.github.steaf23.bingoreloaded.action.TeamChatCommand;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.api.TeamDisplay;
import io.github.steaf23.bingoreloaded.api.TeamDisplayPaper;
import io.github.steaf23.bingoreloaded.api.network.BingoClientManager;
import io.github.steaf23.bingoreloaded.api.network.PaperClientManager;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.DataUpdaterV3_3_0;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.phase.PregameLobby;
import io.github.steaf23.bingoreloaded.gui.BingoCardMapRenderer;
import io.github.steaf23.bingoreloaded.gui.inventory.AdminBingoMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.TeamCardSelectMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.TeamEditorMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.TeamSelectionMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.VoteMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.card.GenericCardMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.card.HotswapGenericCardMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.card.HotswapTexturedCardMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.card.TexturedCardMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.BingoCreatorMenu;
import io.github.steaf23.bingoreloaded.lib.action.ActionTree;
import io.github.steaf23.bingoreloaded.lib.api.BingoReloadedRuntime;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.EntityTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.PaperServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.SharedDisplay;
import io.github.steaf23.bingoreloaded.lib.data.core.ConfigDataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.YamlDataAccessor;
import io.github.steaf23.bingoreloaded.lib.events.EventListenerPaper;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.MenuBoardPaper;
import io.github.steaf23.bingoreloaded.lib.menu.EmptyDisplay;
import io.github.steaf23.bingoreloaded.lib.menu.ScoreboardDisplay;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.PlayerDisplayTranslationKey;
import io.github.steaf23.bingoreloaded.placeholder.BingoReloadedPlaceholderExpansion;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.util.bstats.Metrics;
import io.github.steaf23.bingoreloaded.world.CustomWorldCreator;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BingoReloadedPaper
extends JavaPlugin
implements BingoReloadedRuntime {
    private PaperServerSoftware platform;
    private BingoReloaded bingo;
    private MenuBoard menuBoard;
    private EventListenerPaper eventListener;
    private SharedDisplay gameDisplay;
    private SharedDisplay settingsDisplay;
    private BingoClientManager clientManager;

    public void onLoad() {
        this.platform = new PaperServerSoftware(this);
        PlatformResolver.set(new PaperServerSoftware(this));
        DataUpdaterV3_3_0 updater = new DataUpdaterV3_3_0(this);
        updater.update();
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(true);
        PacketEvents.getAPI().load();
        this.bingo = new BingoReloaded(this);
        this.platform.saveResource("bingoreloaded.zip", true);
        this.platform.saveResource("bingoreloaded_lite.zip", true);
        this.bingo.load();
    }

    public void onEnable() {
        this.menuBoard = new MenuBoardPaper(this.platform, this);
        this.bingo.enable();
        this.clientManager = this.bingo.config().getOptionValue(BingoOptions.DISABLE_CLIENT_MOD) != false ? new BingoClientManager.DisabledClientManager() : new PaperClientManager(this, this.bingo);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new BingoReloadedPlaceholderExpansion(this.platform, this.bingo).register();
            BingoMessage.setMessagePreParser((player, message) -> {
                if (player == null) {
                    return message;
                }
                return PlaceholderAPI.setPlaceholders((Player)((PlayerHandlePaper)player).handle(), (String)message);
            });
        }
        this.eventListener = new EventListenerPaper(this, this.bingo.getGameManager().eventListener());
        Metrics bStatsMetrics = new Metrics(this, 22586);
        bStatsMetrics.addCustomChart(new Metrics.SimplePie("selected_language", () -> this.bingo.config().getOptionValue(BingoOptions.LANGUAGE).replace(".yml", "").replace("languages/", "")));
        bStatsMetrics.addCustomChart(new Metrics.SimplePie("plugin_configuration", () -> this.bingo.config().getOptionValue(BingoOptions.CONFIGURATION) == BingoOptions.PluginConfiguration.SINGULAR ? "Singular" : "Multiple"));
    }

    public void onDisable() {
        this.bingo.disable();
    }

    @Override
    public void onConfigReloaded(BingoConfigurationData config) {
        if (this.gameDisplay != null) {
            this.gameDisplay.clearPlayers();
        }
        if (this.settingsDisplay != null) {
            this.settingsDisplay.clearPlayers();
        }
        if (this.bingo.config().getOptionValue(BingoOptions.DISABLE_SCOREBOARD_SIDEBAR).booleanValue()) {
            this.gameDisplay = new EmptyDisplay();
            this.settingsDisplay = new EmptyDisplay();
        } else {
            this.gameDisplay = new ScoreboardDisplay("game");
            this.settingsDisplay = new ScoreboardDisplay("lobby");
        }
    }

    @Override
    public DataAccessor getConfigData() {
        return new ConfigDataAccessor(this.platform);
    }

    @Override
    public Collection<DataAccessor> getDataToRegister() {
        return List.of(new YamlDataAccessor(this.platform, "scoreboards", false), new YamlDataAccessor(this.platform, "placeholders", false), new YamlDataAccessor(this.platform, "sounds", false));
    }

    @Override
    public void setupConfig() {
        this.saveConfig();
        this.saveDefaultConfig();
        YamlConfiguration defaultConfigFull = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getResource("config.yml")));
        FileConfiguration userConfig = this.getConfig();
        for (String key : userConfig.getKeys(true)) {
            if (!defaultConfigFull.contains(key)) continue;
            defaultConfigFull.set(key, userConfig.get(key));
        }
        defaultConfigFull.set("version", (Object)this.getPluginMeta().getVersion());
        try {
            defaultConfigFull.save(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            ConsoleMessenger.bug("Could not update config.yml to new version", (Object)this);
        }
    }

    @Override
    public Set<EntityType> getValidEntityTypesForStatistics() {
        HashSet<EntityType> types = new HashSet<EntityType>();
        Arrays.stream(Material.values()).forEach(mat -> {
            if (mat.name().contains("_SPAWN_EGG")) {
                types.add(new EntityTypePaper(org.bukkit.entity.EntityType.valueOf((String)mat.name().replace("_SPAWN_EGG", ""))));
            }
        });
        return types;
    }

    @Override
    public BingoReloadedRuntime.LanguageData getLanguageData(String language) {
        YamlDataAccessor lang = new YamlDataAccessor(this.platform, language, false);
        YamlDataAccessor fallback = new YamlDataAccessor(this.platform, "languages/en_us", false);
        BingoReloaded.addDataAccessor(lang);
        BingoReloaded.addDataAccessor(fallback);
        return new BingoReloadedRuntime.LanguageData(lang, fallback);
    }

    @Override
    public void onLanguageUpdated() {
        PlayerDisplayTranslationKey.setTranslateFunction(key -> switch (key) {
            default -> throw new MatchException(null, null);
            case PlayerDisplayTranslationKey.MENU_PREVIOUS -> BingoMessage.MENU_PREV.asPhrase(new Component[0]);
            case PlayerDisplayTranslationKey.MENU_NEXT -> BingoMessage.MENU_NEXT.asPhrase(new Component[0]);
            case PlayerDisplayTranslationKey.MENU_ACCEPT -> BingoMessage.MENU_ACCEPT.asPhrase(new Component[0]);
            case PlayerDisplayTranslationKey.MENU_SAVE_EXIT -> BingoMessage.MENU_SAVE_EXIT.asPhrase(new Component[0]);
            case PlayerDisplayTranslationKey.MENU_FILTER -> BingoMessage.MENU_FILTER.asPhrase(new Component[0]);
            case PlayerDisplayTranslationKey.MENU_CLEAR_FILTER -> BingoMessage.MENU_CLEAR_FILTER.asPhrase(new Component[0]);
        });
        BasicMenu.pluginTitlePrefix = BingoMessage.MENU_PREFIX.asPhrase(new Component[0]);
    }

    @Override
    public void registerActions(BingoConfigurationData config) {
        this.registerCommand(true, new AutoBingoAction(this.platform, this.bingo.getGameManager()));
        this.registerCommand(true, new BingoConfigAction(config));
        this.registerCommand(false, new BingoAction(this.bingo, config, this.bingo.getGameManager()));
        this.registerCommand(false, new BotCommandAction(this.bingo.getGameManager()));
        if (config.getOptionValue(BingoOptions.ENABLE_TEAM_CHAT).booleanValue()) {
            TeamChatCommand command = new TeamChatCommand(player -> this.bingo.getGameManager().getSessionFromWorld(player.world()));
            this.registerCommand(false, command);
            Bukkit.getPluginManager().registerEvents((Listener)command, (Plugin)this);
        }
    }

    @Override
    public WorldHandle createBingoWorld(String worldName, Key generationOptions) {
        return CustomWorldCreator.createWorld(this.platform, worldName, generationOptions);
    }

    @Override
    public ServerSoftware getServerSoftware() {
        return this.platform;
    }

    @Override
    public StackHandle createCardItemForPlayer(BingoParticipant player) {
        if (player.sessionPlayer().isEmpty() || player.getCard().isEmpty() && player.getTeam() != null) {
            return PlayerKit.CARD_ITEM.buildItem();
        }
        PlayerHandle playerHandle = player.sessionPlayer().get();
        if (!this.bingo.config().getOptionValue(BingoOptions.USE_MAP_RENDERER).booleanValue() || this.clientManager.playerHasClient(playerHandle)) {
            return PlayerKit.CARD_ITEM.buildItem();
        }
        StackHandlePaper mapStack = (StackHandlePaper)PlayerKit.CARD_ITEM_RENDERABLE.buildItem();
        ItemStack handle = mapStack.handle();
        handle.editMeta(m -> {
            if (m instanceof MapMeta) {
                MapMeta meta = (MapMeta)m;
                MapView view = Bukkit.createMap((World)((WorldHandlePaper)playerHandle.world()).handle());
                for (MapRenderer renderer : new ArrayList(view.getRenderers())) {
                    view.removeRenderer(renderer);
                }
                view.addRenderer((MapRenderer)new BingoCardMapRenderer(this.platform, player.getCard().get(), player.getTeam()));
                meta.setMapView(view);
            } else {
                ConsoleMessenger.bug("No valid map item found to render texture to.", (Object)this);
            }
        });
        return mapStack;
    }

    @Override
    public CardMenu createMenu(boolean textured, CardDisplayInfo displayInfo) {
        if (textured) {
            if (displayInfo.mode() == BingoGamemode.HOTSWAP) {
                return new HotswapTexturedCardMenu(this.bingo, this.menuBoard, displayInfo);
            }
            return new TexturedCardMenu(this.bingo, this.menuBoard, displayInfo);
        }
        if (displayInfo.mode() == BingoGamemode.HOTSWAP) {
            return new HotswapGenericCardMenu(this.bingo, this.menuBoard, displayInfo, null);
        }
        return new GenericCardMenu(this.bingo, this.menuBoard, displayInfo, null);
    }

    @Override
    public void openBingoMenu(PlayerHandle player, BingoSession session) {
        if (player.hasPermission("bingo.admin")) {
            new AdminBingoMenu(this.menuBoard, session).open(player);
        } else if (player.hasPermission("bingo.player")) {
            new TeamSelectionMenu(this.menuBoard, session).open(player);
        }
    }

    @Override
    public void openTeamEditor(PlayerHandle player) {
        new TeamEditorMenu(this.menuBoard).open(player);
    }

    @Override
    public void openTeamCardSelect(PlayerHandle player, BingoSession session) {
        new TeamCardSelectMenu(this.menuBoard, session).open(player);
    }

    @Override
    public void openBingoCreator(PlayerHandle player) {
        new BingoCreatorMenu(this.menuBoard).open(player);
    }

    @Override
    public void openTeamSelector(PlayerHandle player, BingoSession session) {
        TeamSelectionMenu menu = new TeamSelectionMenu(this.menuBoard, session);
        menu.open(player);
    }

    @Override
    public void openVoteMenu(PlayerHandle player, PregameLobby lobby) {
        VoteMenu menu = new VoteMenu(this.menuBoard, this.bingo.config().getOptionValue(BingoOptions.VOTE_LIST), lobby);
        menu.open(player);
    }

    @Override
    public TeamDisplay createTeamDisplay(BingoSession session) {
        return new TeamDisplayPaper(session);
    }

    @Override
    public SharedDisplay gameDisplay() {
        return this.gameDisplay;
    }

    @Override
    public SharedDisplay settingsDisplay() {
        return this.settingsDisplay;
    }

    @Override
    public BingoClientManager getClientManager() {
        return this.clientManager;
    }

    public void registerCommand(boolean allowConsole, ActionTree action) {
        CommandTemplate commandExec = new CommandTemplate(allowConsole, action);
        PluginCommand command = this.getCommand(action.name());
        if (command != null) {
            command.setExecutor((CommandExecutor)commandExec);
            command.setTabCompleter((TabCompleter)commandExec);
        } else {
            ConsoleMessenger.bug("Cannot register command named '" + action.name() + "'", (Object)this);
        }
    }

    public static void showPacketDialog(PlayerHandle player, Dialog dialog) {
        WrapperPlayServerShowDialog dialogWrapper = new WrapperPlayServerShowDialog(dialog);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)((PlayerHandlePaper)player).handle(), (PacketWrapper)dialogWrapper);
    }
}

