/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.action;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoLobbyData;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoStatData;
import io.github.steaf23.bingoreloaded.data.CustomKitData;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.gameloop.phase.PregameLobby;
import io.github.steaf23.bingoreloaded.lib.action.ActionResult;
import io.github.steaf23.bingoreloaded.lib.action.ActionTree;
import io.github.steaf23.bingoreloaded.lib.api.ActionUser;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.settings.CustomKit;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.util.BingoPlayerSender;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.Nullable;

public class BingoAction
extends ActionTree {
    private final BingoConfigurationData config;
    private final GameManager gameManager;
    private final BingoReloaded bingo;
    private final BingoLobbyData lobbyData;

    public BingoAction(BingoReloaded bingo, BingoConfigurationData config, GameManager gameManager) {
        super("bingo", List.of("bingo.player"));
        this.config = config;
        this.bingo = bingo;
        this.gameManager = gameManager;
        this.lobbyData = new BingoLobbyData();
        this.setAction(action -> {
            BingoSession session = this.getSessionFromUser(this.getLastUser());
            if (session == null) {
                return ActionResult.IGNORED;
            }
            BingoReloaded.runtime().openBingoMenu((PlayerHandle)this.getLastUser(), session);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("vote", List.of(), (args, session) -> {
            GamePhase patt0$temp = session.phase();
            if (!(patt0$temp instanceof PregameLobby)) {
                return ActionResult.IGNORED;
            }
            PregameLobby lobby = (PregameLobby)patt0$temp;
            if (!config.getOptionValue(BingoOptions.USE_VOTE_SYSTEM).booleanValue() || config.getOptionValue(BingoOptions.VOTE_USING_COMMANDS_ONLY).booleanValue() || config.getOptionValue(BingoOptions.VOTE_LIST).isEmpty()) {
                BingoPlayerSender.sendMessage(Component.text("Voting is disabled!").color(NamedTextColor.RED), (Audience)this.getLastUser());
                return ActionResult.IGNORED;
            }
            ActionUser patt1$temp = this.getLastUser();
            if (!(patt1$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt1$temp;
            BingoReloaded.runtime().openVoteMenu(player, lobby);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("join", List.of(), (args, session) -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            BingoReloaded.runtime().openTeamSelector(player, (BingoSession)session);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("leave", List.of(), (args, session) -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            BingoParticipant participant = session.teamManager.getPlayerAsParticipant(player);
            if (participant != null) {
                session.removeParticipant(participant);
                return ActionResult.SUCCESS;
            }
            return ActionResult.IGNORED;
        });
        this.addSessionSubAction("getcard", List.of(), (args, session) -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            if (session.canPlayersViewCard()) {
                BingoParticipant participant = session.teamManager.getPlayerAsParticipant(player);
                if (participant instanceof BingoPlayer) {
                    BingoPlayer bingoPlayer = (BingoPlayer)participant;
                    int cardSlot = session.settingsBuilder.view().kit().getCardSlot();
                    BingoGame game = (BingoGame)session.phase();
                    game.returnCardToPlayer(cardSlot, bingoPlayer);
                }
                return ActionResult.SUCCESS;
            }
            return ActionResult.IGNORED;
        });
        this.addSessionSubAction("back", List.of(), (args, session) -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            if (session.isRunning() && config.getOptionValue(BingoOptions.TELEPORT_AFTER_DEATH).booleanValue()) {
                ((BingoGame)session.phase()).teleportPlayerAfterDeath(player);
                return ActionResult.SUCCESS;
            }
            return ActionResult.IGNORED;
        });
        this.addSessionSubAction("view", List.of(), (args, session) -> {
            if (!this.getLastUser().hasPermission("bingo.admin") && !config.getOptionValue(BingoOptions.ALLOW_VIEWING_ALL_CARDS).booleanValue()) {
                return ActionResult.NO_PERMISSION;
            }
            this.showTeamCardsToUser((BingoSession)session);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("about", List.of(), (args, session) -> {
            ServerSoftware server = PlatformResolver.get();
            this.getLastUser().sendMessage(Component.text("Bingo Reloaded Version: " + server.getExtensionInfo().version() + " Created by: " + String.valueOf(server.getExtensionInfo().authors())));
            this.getLastUser().sendMessage(BingoMessage.createInfoUrlComponent(Component.text("Join the bingo reloaded discord server here to stay up to date!"), "https://discord.gg/AzZNxPRNPf"));
            return ActionResult.SUCCESS;
        });
        this.addSubAction(new ActionTree("reload", List.of("bingo.admin"), args -> {
            if (((String[])args).length == 1) {
                return this.reloadCommand(args[0], this.getLastUser());
            }
            return this.reloadCommand("all", this.getLastUser());
        }).addTabCompletion(args -> List.of("all", "config", "worlds", "placeholders", "scoreboards", "data", "language", "sounds")).addUsage("<option>"));
        this.addSessionSubAction("start", List.of("bingo.admin"), (args, session) -> {
            if (((String[])args).length == 0) {
                session.startGame();
                return ActionResult.SUCCESS;
            }
            if (((String[])args).length == 1 && args[0].equals("here")) {
                ActionUser patt0$temp = this.getLastUser();
                if (!(patt0$temp instanceof PlayerHandle)) {
                    return ActionResult.INCORRECT_USE;
                }
                PlayerHandle player = (PlayerHandle)patt0$temp;
                WorldPosition pos = player.position();
                session.startGame(pos);
                return ActionResult.SUCCESS;
            }
            if (((String[])args).length == 2 && args[0].equals("here")) {
                ActionUser patt0$temp = this.getLastUser();
                if (!(patt0$temp instanceof PlayerHandle)) {
                    return ActionResult.INCORRECT_USE;
                }
                PlayerHandle player = (PlayerHandle)patt0$temp;
                int seed = Integer.parseInt(args[1]);
                session.settingsBuilder.cardSeed(seed);
                WorldPosition pos = player.position();
                session.startGame(pos);
                return ActionResult.SUCCESS;
            }
            if (((String[])args).length == 1) {
                int seed = Integer.parseInt(args[0]);
                session.settingsBuilder.cardSeed(seed);
                session.startGame();
                return ActionResult.SUCCESS;
            }
            return ActionResult.INCORRECT_USE;
        }).usage("[here] [<seed>]");
        this.addSessionSubAction("end", List.of("bingo.admin"), (args, session) -> {
            session.endGame();
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("wait", List.of("bingo.admin"), (args, session) -> {
            session.pauseAutomaticStart();
            BingoPlayerSender.sendMessage(Component.text("Toggled automatic starting timer"), (Audience)this.getLastUser());
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("deathmatch", List.of("bingo.admin"), (args, session) -> {
            if (!session.isRunning()) {
                BingoMessage.NO_DEATHMATCH.sendToAudience((Audience)this.getLastUser(), (TextColor)NamedTextColor.RED, new Component[0]);
                return ActionResult.IGNORED;
            }
            ((BingoGame)session.phase()).startDeathMatch(3);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("creator", List.of("bingo.admin"), (args, session) -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            BingoReloaded.runtime().openBingoCreator(player);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("stats", List.of("bingo.admin"), (args, session) -> {
            Component msg;
            if (!config.getOptionValue(BingoOptions.SAVE_PLAYER_STATISTICS).booleanValue()) {
                Component text = Component.text("Player statistics are not being tracked at this moment!").color(NamedTextColor.RED);
                BingoPlayerSender.sendMessage(text, (Audience)this.getLastUser());
                return ActionResult.IGNORED;
            }
            BingoStatData statsData = new BingoStatData(gameManager.getPlatform());
            if (((String[])args).length > 1 && this.getLastUser().hasPermission("bingo.admin")) {
                msg = statsData.getPlayerStatsFormatted(args[1]);
            } else {
                ActionUser patt0$temp = this.getLastUser();
                if (!(patt0$temp instanceof PlayerHandle)) {
                    return ActionResult.IGNORED;
                }
                PlayerHandle player = (PlayerHandle)patt0$temp;
                msg = statsData.getPlayerStatsFormatted(player.uniqueId());
            }
            BingoPlayerSender.sendMessage(msg, (Audience)this.getLastUser());
            return ActionResult.SUCCESS;
        });
        ActionTree addKitAction = new ActionTree("add", args -> {
            if (((String[])args).length < 1) {
                return ActionResult.INCORRECT_USE;
            }
            if (((String[])args).length < 2) {
                BingoPlayerSender.sendMessage(Component.text("Please specify a kit name for slot " + args[0]).color(NamedTextColor.RED), (Audience)this.getLastUser());
                return ActionResult.INCORRECT_USE;
            }
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            this.addPlayerKit(args[0], String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, ((String[])args).length)), player);
            return ActionResult.SUCCESS;
        }).addTabCompletion(args -> List.of("1", "2", "3", "4", "5")).addUsage("<slot> <name>");
        ActionTree removeKitAction = new ActionTree("remove", args -> this.removePlayerKit(args[0])).addTabCompletion(args -> List.of("1", "2", "3", "4", "5")).addUsage("<slot>");
        ActionTree itemKitAction = new ActionTree("item", args -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            return this.giveUserBingoItem(player, args[0]);
        }).addTabCompletion(args -> List.of("wand", "card")).addUsage("<item_name>");
        this.addSubAction(new ActionTree("kit", List.of("bingo.admin")).addSubAction(addKitAction).addSubAction(removeKitAction).addSubAction(itemKitAction));
        this.addSessionSubAction("teamedit", List.of("bingo.admin"), (args, session) -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            BingoReloaded.runtime().openTeamEditor(player);
            return ActionResult.SUCCESS;
        });
        this.addSessionSubAction("teams", List.of("bingo.admin"), (args, session) -> {
            BingoPlayerSender.sendMessage(Component.text("Here are all the teams with at least 1 player:"), (Audience)this.getLastUser());
            session.teamManager.getActiveTeams().getTeams().forEach(team -> {
                if (team.getMembers().isEmpty()) {
                    return;
                }
                this.getLastUser().sendMessage(((TextComponent)Component.text(" - ").append(team.getColoredName())).append(Component.text(": ").append(Component.join(JoinConfiguration.separator(Component.text(", ")), team.getMembers().stream().map(BingoParticipant::getDisplayName).toList()))));
            });
            return ActionResult.SUCCESS;
        });
        ActionTree createLobbyAction = new ActionTree("create", args -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle player = (PlayerHandle)patt0$temp;
            WorldPosition pos = player.position();
            gameManager.getLobbyData().create(pos);
            BingoPlayerSender.sendMessage(ComponentUtils.MINI_BUILDER.deserialize("<green>Created a lobby spawn point at this position.\nPlayers can be teleported here using the option <dark_green>teleportToLobbyAfterGame</dark_green>.</green>"), (Audience)player);
            return ActionResult.SUCCESS;
        });
        ActionTree removeLobbyAction = new ActionTree("remove", args -> {
            if (!gameManager.getLobbyData().isEnabled()) {
                BingoPlayerSender.sendMessage(ComponentUtils.MINI_BUILDER.deserialize("<red>A lobby has not been created yet.</red>\n<yellow>Tip: </yellow><italic>Use <aqua>/bingo lobby create</aqua> to create a lobby spawn point at your current position.</italic>"), (Audience)this.getLastUser());
                return ActionResult.IGNORED;
            }
            gameManager.getLobbyData().remove();
            BingoPlayerSender.sendMessage(ComponentUtils.MINI_BUILDER.deserialize("<green>Removed the created lobby.</green>\n<yellow>Tip: </yellow><italic>Use <aqua>/bingo lobby create</aqua> to create a lobby spawn point at your current position.</italic>"), (Audience)this.getLastUser());
            return ActionResult.SUCCESS;
        });
        this.addSubAction(new ActionTree("lobby", List.of("bingo.admin")).addSubAction(createLobbyAction).addSubAction(removeLobbyAction));
    }

    public void addPlayerKit(String slot, String kitName, PlayerHandle fromPlayerInventory) {
        PlayerKit kit;
        switch (slot) {
            case "1": {
                PlayerKit playerKit = PlayerKit.CUSTOM_1;
                break;
            }
            case "2": {
                PlayerKit playerKit = PlayerKit.CUSTOM_2;
                break;
            }
            case "3": {
                PlayerKit playerKit = PlayerKit.CUSTOM_3;
                break;
            }
            case "4": {
                PlayerKit playerKit = PlayerKit.CUSTOM_4;
                break;
            }
            case "5": {
                PlayerKit playerKit = PlayerKit.CUSTOM_5;
                break;
            }
            default: {
                BingoPlayerSender.sendMessage(Component.text("Invalid slot, please pick a slot from 1 through 5 to save this kit in").color(NamedTextColor.RED), (Audience)this.getLastUser());
                PlayerKit playerKit = kit = null;
            }
        }
        if (kit == null) {
            return;
        }
        CustomKitData data = new CustomKitData();
        if (!data.assignCustomKit((Component)ComponentUtils.MINI_BUILDER.deserialize(kitName), kit, fromPlayerInventory)) {
            Component message = ComponentUtils.MINI_BUILDER.deserialize("<red>Cannot add custom kit " + kitName + " to slot " + slot + ", this slot already contains kit ").append(data.getCustomKit(kit).name()).append(Component.text(". Remove it first!"));
            BingoPlayerSender.sendMessage(message, (Audience)this.getLastUser());
        } else {
            Object message = ComponentUtils.MINI_BUILDER.deserialize("<green>Created custom kit " + kitName + " in slot " + slot + " from your inventory");
            BingoPlayerSender.sendMessage(message, (Audience)this.getLastUser());
        }
    }

    public ActionResult removePlayerKit(String slot) {
        PlayerKit kit;
        switch (slot) {
            case "1": {
                PlayerKit playerKit = PlayerKit.CUSTOM_1;
                break;
            }
            case "2": {
                PlayerKit playerKit = PlayerKit.CUSTOM_2;
                break;
            }
            case "3": {
                PlayerKit playerKit = PlayerKit.CUSTOM_3;
                break;
            }
            case "4": {
                PlayerKit playerKit = PlayerKit.CUSTOM_4;
                break;
            }
            case "5": {
                PlayerKit playerKit = PlayerKit.CUSTOM_5;
                break;
            }
            default: {
                BingoPlayerSender.sendMessage(Component.text("Invalid slot, please a slot from 1 through 5 to save this kit in").color(NamedTextColor.RED), (Audience)this.getLastUser());
                PlayerKit playerKit = kit = null;
            }
        }
        if (kit == null) {
            return ActionResult.INCORRECT_USE;
        }
        CustomKitData data = new CustomKitData();
        CustomKit customKit = data.getCustomKit(kit);
        if (customKit == null) {
            Object message = ComponentUtils.MINI_BUILDER.deserialize("<red>Cannot remove kit from slot " + slot + " because no custom kit is assigned to this slot");
            BingoPlayerSender.sendMessage(message, (Audience)this.getLastUser());
        } else {
            data.removeCustomKit(kit);
            Object message = ComponentUtils.MINI_BUILDER.deserialize("<green>Removed custom kit " + (String)ComponentUtils.MINI_BUILDER.serialize(customKit.name()) + " from slot " + slot);
            BingoPlayerSender.sendMessage(message, (Audience)this.getLastUser());
        }
        return ActionResult.SUCCESS;
    }

    public ActionResult giveUserBingoItem(PlayerHandle player, String itemName) {
        return switch (itemName) {
            case "wand" -> {
                player.inventory().addItem(PlayerKit.WAND_ITEM.buildItem());
                yield ActionResult.SUCCESS;
            }
            case "card" -> {
                player.inventory().addItem(PlayerKit.CARD_ITEM.buildItem());
                yield ActionResult.SUCCESS;
            }
            default -> ActionResult.INCORRECT_USE;
        };
    }

    public void showTeamCardsToUser(BingoSession session) {
        if (!session.canPlayersViewCard()) {
            return;
        }
        ActionUser actionUser = this.getLastUser();
        if (!(actionUser instanceof PlayerHandle)) {
            return;
        }
        PlayerHandle player = (PlayerHandle)actionUser;
        BingoReloaded.runtime().openTeamCardSelect(player, session);
    }

    public static int toInt(String in, int defaultValue) {
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public ActionResult reloadCommand(String reloadOption, ActionUser user) {
        switch (reloadOption) {
            case "all": {
                this.reloadAll();
                break;
            }
            case "config": {
                this.reloadConfig();
                break;
            }
            case "worlds": {
                this.reloadWorlds();
                break;
            }
            case "placeholders": {
                this.reloadPlaceholders();
                break;
            }
            case "scoreboards": {
                this.reloadScoreboards();
                break;
            }
            case "data": {
                this.reloadData();
                break;
            }
            case "language": {
                this.reloadLanguage();
                break;
            }
            case "sounds": {
                this.reloadSounds();
                break;
            }
            default: {
                BingoPlayerSender.sendMessage(Component.text("Cannot reload '" + reloadOption + "', invalid option"), (Audience)user);
                return ActionResult.INCORRECT_USE;
            }
        }
        BingoPlayerSender.sendMessage(Component.text("Reloaded " + reloadOption), (Audience)user);
        return ActionResult.SUCCESS;
    }

    public void reloadAll() {
        this.reloadConfig();
        this.reloadPlaceholders();
        this.reloadScoreboards();
        this.reloadData();
        this.reloadLanguage();
        this.reloadSounds();
        this.reloadWorlds();
    }

    public void reloadConfig() {
        this.bingo.reloadConfigFromFile();
    }

    public void reloadWorlds() {
        this.bingo.reloadManager();
    }

    public void reloadPlaceholders() {
        this.bingo.reloadPlaceholders();
    }

    public void reloadScoreboards() {
        this.bingo.reloadScoreboards();
    }

    public void reloadData() {
        this.bingo.reloadData();
    }

    public void reloadLanguage() {
        this.bingo.reloadLanguage();
    }

    public void reloadSounds() {
        this.bingo.reloadSounds();
    }

    @Nullable
    public BingoSession getSessionFromUser(ActionUser user) {
        if (user instanceof PlayerHandle) {
            PlayerHandle player = (PlayerHandle)user;
            return this.gameManager.getSessionFromWorld(player.world());
        }
        return null;
    }

    public ActionTree addSessionSubAction(String name, List<String> permissions, BiFunction<String[], BingoSession, ActionResult> action) {
        return this.addSubAction(new ActionTree(name, permissions, args -> {
            BingoSession session = this.getSessionFromUser(this.getLastUser());
            if (session == null) {
                return ActionResult.IGNORED;
            }
            return (ActionResult)((Object)((Object)action.apply((String[])args, session)));
        }));
    }
}

