/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.action;

import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.lib.action.ActionResult;
import io.github.steaf23.bingoreloaded.lib.action.ActionTree;
import io.github.steaf23.bingoreloaded.lib.api.ActionUser;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.VirtualBingoPlayer;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class BotCommandAction
extends ActionTree {
    private final GameManager manager;

    public BotCommandAction(GameManager manager) {
        super("bingobot", List.of("bingo.admin"));
        this.manager = manager;
        this.addSessionSubAction("add", List.of(), (args, session) -> {
            String playerName = args[0];
            String teamName = args[1];
            this.addVirtualPlayerToTeam((BingoSession)session, playerName, teamName);
            return true;
        });
        this.addSessionSubAction("add10", List.of(), (args, session) -> {
            for (int i = 0; i < 10; ++i) {
                String playerName = "testPlayer_" + i;
                String teamName = args[0];
                this.addVirtualPlayerToTeam((BingoSession)session, playerName, teamName);
            }
            return true;
        });
        this.addSessionSubAction("add100", List.of(), (args, session) -> {
            for (int i = 0; i < 100; ++i) {
                String playerName = "testPlayer_" + i;
                String teamName = args[0];
                this.addVirtualPlayerToTeam((BingoSession)session, playerName, teamName);
            }
            return true;
        });
        this.addSessionSubAction("fill", List.of(), (args, session) -> {
            ConsoleMessenger.log("CAPACITY: " + session.teamManager.getTotalParticipantCapacity());
            for (String teamId : session.teamManager.getJoinableTeams().keySet()) {
                for (int i = 0; i < session.teamManager.getMaxTeamSize(); ++i) {
                    String name = "test_" + teamId + "_" + i;
                    this.addVirtualPlayerToTeam((BingoSession)session, name, teamId);
                }
            }
            return true;
        });
        this.addSessionSubAction("fillauto", List.of(), (args, session) -> {
            ConsoleMessenger.log("CAPACITY: " + session.teamManager.getTotalParticipantCapacity());
            for (int i = 0; i < session.teamManager.getTotalParticipantCapacity() + 3; ++i) {
                String name = "test_" + i;
                this.addVirtualPlayerToTeam((BingoSession)session, name, "auto");
            }
            return true;
        });
        this.addSessionSubAction("remove", List.of(), (args, session) -> {
            String playerName = args[0];
            BingoParticipant player = this.getVirtualPlayerFromName((BingoSession)session, playerName);
            if (player != null) {
                session.teamManager.removeMemberFromTeam(player);
            }
            return true;
        });
        this.addSessionSubAction("complete", List.of(), (args, session) -> {
            BingoParticipant virtualPlayer = this.getVirtualPlayerFromName((BingoSession)session, args[0]);
            int taskIndex = Integer.parseInt(args[1]);
            if (virtualPlayer == null) {
                ConsoleMessenger.error("Cannot complete task " + args[1] + " for non existing virtual player: " + args[0]);
                return false;
            }
            this.completeTaskByPlayer(virtualPlayer, taskIndex);
            return true;
        });
    }

    void completeTaskByPlayer(BingoParticipant player, int taskIndex) {
        if (!player.getSession().isRunning()) {
            return;
        }
        Optional<TaskCard> card = player.getCard();
        if (card.isEmpty() || taskIndex >= card.get().getTasks().size()) {
            ConsoleMessenger.error("index out of bounds for task list!");
            return;
        }
        GameTask task = card.get().getTasks().get(taskIndex);
        BingoGame game = (BingoGame)player.getSession().phase();
        task.complete(player, game.getGameTime());
        game.onBingoTaskCompleted(player, task);
    }

    @Nullable
    private BingoParticipant getVirtualPlayerFromName(BingoSession session, String name) {
        return session.teamManager.getParticipants().stream().filter(p -> p.getName().equals(name)).findAny().orElse(null);
    }

    public void addVirtualPlayerToTeam(BingoSession session, String playerName, String teamName) {
        BingoParticipant virtualPlayer = this.getVirtualPlayerFromName(session, playerName);
        if (virtualPlayer == null) {
            virtualPlayer = new VirtualBingoPlayer(UUID.randomUUID(), playerName, session);
        }
        session.teamManager.addMemberToTeam(virtualPlayer, teamName);
    }

    @Nullable
    public BingoSession getSessionFromUser(ActionUser user) {
        if (user instanceof PlayerHandle) {
            PlayerHandle player = (PlayerHandle)user;
            return this.manager.getSessionFromWorld(player.world());
        }
        return null;
    }

    public void addSessionSubAction(String name, List<String> permissions, BiFunction<String[], BingoSession, Boolean> action) {
        this.addSubAction(new ActionTree(name, permissions, args -> {
            BingoSession session = this.getSessionFromUser(this.getLastUser());
            if (session == null) {
                return ActionResult.IGNORED;
            }
            if (((Boolean)action.apply((String[])args, session)).booleanValue()) {
                return ActionResult.SUCCESS;
            }
            return ActionResult.IGNORED;
        }));
    }
}

