/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.action;

import io.github.steaf23.bingoreloaded.action.ConsoleActionUser;
import io.github.steaf23.bingoreloaded.lib.action.ActionTree;
import io.github.steaf23.bingoreloaded.lib.api.ActionUser;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandTemplate
implements TabExecutor {
    private final boolean allowConsole;
    private final ActionTree command;

    public CommandTemplate(boolean allowConsole, ActionTree command) {
        this.command = command;
        this.allowConsole = allowConsole;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command bukkitCmd, @NotNull String s, String @NotNull [] arguments) {
        ActionUser user;
        if (commandSender instanceof ConsoleCommandSender && !this.allowConsole) {
            return false;
        }
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            user = new PlayerHandlePaper(player);
        } else if (commandSender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)commandSender;
            user = new ConsoleActionUser(console);
        } else {
            ConsoleMessenger.bug("Cannot execute command for this command sender..?", (Object)this);
            return false;
        }
        if (!this.command.hasPermission(user)) {
            return false;
        }
        switch (this.command.execute(user, arguments)) {
            case INCORRECT_USE: {
                commandSender.sendMessage(ComponentUtils.MINI_BUILDER.deserialize("<dark_gray>- <red>Usage: " + this.command.usage(arguments)));
                return false;
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String alias, @NotNull String[] strings) {
        ActionUser user;
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            user = new PlayerHandlePaper(player);
        } else if (commandSender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)commandSender;
            user = new ConsoleActionUser(console);
        } else {
            return List.of();
        }
        List<String> tabComplete = this.command.tabComplete(user, strings);
        if (tabComplete == null) {
            return null;
        }
        return tabComplete.stream().filter(s -> StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)strings[strings.length - 1])).toList();
    }
}

