/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.action;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.action.ActionResult;
import io.github.steaf23.bingoreloaded.lib.action.ActionTree;
import io.github.steaf23.bingoreloaded.lib.api.ActionUser;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;

public class TeamChatCommand
extends ActionTree
implements Listener {
    private final List<BingoPlayer> enabledPlayers = new ArrayList<BingoPlayer>();
    private final Function<PlayerHandle, @Nullable BingoSession> sessionResolver;

    public TeamChatCommand(Function<PlayerHandle, @Nullable BingoSession> sessionResolver) {
        super("btc", List.of("bingo.player"));
        this.sessionResolver = sessionResolver;
        this.setAction(args -> {
            ActionUser patt0$temp = this.getLastUser();
            if (!(patt0$temp instanceof PlayerHandle)) {
                return ActionResult.IGNORED;
            }
            PlayerHandle handle = (PlayerHandle)patt0$temp;
            BingoSession session = this.getSession(handle);
            if (session == null) {
                return ActionResult.IGNORED;
            }
            TeamManager teamManager = session.teamManager;
            BingoParticipant participant = teamManager.getPlayerAsParticipant(handle);
            if (!(participant instanceof BingoPlayer)) {
                return ActionResult.IGNORED;
            }
            BingoPlayer player = (BingoPlayer)participant;
            if (!teamManager.getParticipants().contains(player)) {
                BingoMessage.NO_CHAT.sendToAudience((Audience)player, (TextColor)NamedTextColor.RED, new Component[0]);
                return ActionResult.IGNORED;
            }
            if (this.enabledPlayers.contains(player)) {
                this.enabledPlayers.remove(player);
                BingoMessage.CHAT_OFF.sendToAudience((Audience)player, (TextColor)NamedTextColor.GREEN, Component.text("/btc").color(NamedTextColor.GRAY));
            } else {
                this.enabledPlayers.add(player);
                BingoMessage.CHAT_ON.sendToAudience((Audience)player, (TextColor)NamedTextColor.GREEN, Component.text("/btc").color(NamedTextColor.GRAY));
            }
            return ActionResult.SUCCESS;
        });
    }

    @Nullable
    private BingoSession getSession(PlayerHandle player) {
        return this.sessionResolver.apply(player);
    }

    @EventHandler
    public void onPlayerSendMessage(AsyncChatEvent event) {
        PlayerHandlePaper handle = new PlayerHandlePaper(event.getPlayer());
        BingoSession session = this.getSession(handle);
        if (session == null) {
            return;
        }
        TeamManager teamManager = session.teamManager;
        BingoParticipant player = teamManager.getPlayerAsParticipant(handle);
        if (!(player instanceof BingoPlayer) || !this.enabledPlayers.contains(player)) {
            return;
        }
        BingoTeam team = player.getTeam();
        if (team == null) {
            return;
        }
        this.sendMessage(team, handle, event.message());
        event.setCancelled(true);
    }

    public void sendMessage(BingoTeam team, PlayerHandle player, Component message) {
        team.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(team.getPrefix())).append(((TextComponent)Component.text("<").append(player.displayName())).append(Component.text("> ")))).append(message)).build());
    }
}

