/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.api;

import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.gameloop.phase.PregameLobby;
import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.InteractAction;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.event.EventResults;
import io.github.steaf23.bingoreloaded.lib.event.PlatformEventDispatcher;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BingoEventListener
implements PlatformEventDispatcher {
    private final boolean disableAdvancements;
    private final boolean disableStatistics;
    private final GameManager gameManager;

    public BingoEventListener(GameManager gameManager, boolean disableAdvancements, boolean disableStatistics) {
        this.gameManager = gameManager;
        this.disableAdvancements = disableAdvancements;
        this.disableStatistics = disableStatistics;
    }

    @Nullable
    private BingoSession getSession(@NotNull WorldHandle world) {
        return this.gameManager.getSessionFromWorld(world);
    }

    @Override
    public EventResult<?> sendPlayerMove(PlayerHandle player, WorldPosition from, WorldPosition to) {
        BingoGame game = this.getBingoGame(player.world());
        if (game == null) {
            return EventResult.PASS;
        }
        return game.handlePlayerMove(player, from, to);
    }

    @Override
    public EventResult<?> sendPlayerTeleport(PlayerHandle player, WorldPosition from, WorldPosition to) {
        return this.gameManager.handlePlayerTeleport(player, from, to);
    }

    @Override
    public EventResult<EventResults.PlayerMoveResult> sendPlayerPortal(PlayerHandle player, WorldPosition from, WorldPosition to) {
        BingoSession session = this.getSession(from.world());
        if (session == null) {
            return new EventResult<Object>(false, null);
        }
        return session.handlePlayerPortalEvent(player, from, to);
    }

    @Override
    public EventResult<?> sendPlayerDroppedStack(PlayerHandle player, StackHandle item) {
        BingoGame game;
        BingoSession session = this.getSession(player.world());
        if (session == null) {
            return EventResult.PASS;
        }
        EventResult<?> sessionResult = session.handlePlayerDroppedStack(player, item);
        BingoGame bingoGame = game = session.isRunning() ? (BingoGame)session.phase() : null;
        if (game != null && game.hasStarted()) {
            game.getProgressTracker().handlePlayerDroppedItem(player, item);
        }
        return sessionResult;
    }

    @Override
    public EventResult<?> sendPlayerStackDamaged(PlayerHandle player, StackHandle item) {
        BingoGame game = this.getBingoGame(player.world());
        if (game == null) {
            return EventResult.PASS;
        }
        return game.handlePlayerStackDamaged(player, item);
    }

    @Override
    public EventResult<?> sendPlayerInteracted(PlayerHandle player, @Nullable StackHandle handItem, InteractAction action) {
        BingoSession session = this.getSession(player.world());
        if (session == null) {
            return EventResult.PASS;
        }
        return session.phase().handlePlayerInteracted(player, handItem, action);
    }

    @Override
    public EventResult<?> sendPlayerFallDamage(PlayerHandle player) {
        BingoGame game = this.getBingoGame(player.world());
        if (game == null) {
            return EventResult.PASS;
        }
        return game.handlePlayerFallDamage(player);
    }

    @Override
    public EventResult<EventResults.PlayerDeathResult> sendPlayerDeath(PlayerHandle player, Collection<? extends StackHandle> drops) {
        BingoGame game = this.getBingoGame(player.world());
        if (game == null) {
            return new EventResult<Object>(false, null);
        }
        return game.handlePlayerDeath(player, drops);
    }

    @Override
    public EventResult<EventResults.PlayerRespawnResult> sendPlayerRespawn(PlayerHandle player, boolean isBedSpawn, boolean isAnchorSpawn) {
        BingoGame game;
        GamePhase gamePhase;
        BingoSession session = this.getSession(player.world());
        if (session != null && (gamePhase = session.getPhase()) instanceof PregameLobby) {
            PregameLobby lobby = (PregameLobby)gamePhase;
            lobby.handlePlayerRespawn(player);
        }
        BingoGame bingoGame = game = session != null && session.isRunning() ? (BingoGame)session.phase() : null;
        if (game != null) {
            return game.handlePlayerRespawn(player, isBedSpawn, isAnchorSpawn);
        }
        return new EventResult<Object>(false, null);
    }

    @Override
    public EventResult<?> sendPlayerJoinsServer(PlayerHandle player) {
        return this.gameManager.handlePlayerJoinsServer(player);
    }

    @Override
    public EventResult<?> sendPlayerQuitsServer(PlayerHandle player) {
        return this.gameManager.handlePlayerQuitsServer(player);
    }

    @Override
    public EventResult<?> sendPlayerBreaksBlock(PlayerHandle player, WorldPosition position, ItemType blockType) {
        BingoSession session = this.getSession(player.world());
        if (session == null) {
            return EventResult.PASS;
        }
        return session.handlePlayerBlockBreak(player, position, blockType);
    }

    @Override
    public EventResult<?> sendPlayerPlacesBlock(PlayerHandle player, WorldPosition position, ItemType blockType) {
        BingoSession session = this.getSession(player.world());
        if (session == null) {
            return EventResult.PASS;
        }
        return session.handlePlayerBlockPlace(player, position, blockType);
    }

    @Override
    public EventResult<?> sendPlayerStatisticIncrement(PlayerHandle player, StatisticHandle statistic, int newValue) {
        BingoGame game;
        if (this.disableStatistics) {
            return EventResult.PASS;
        }
        BingoSession session = this.getSession(player.world());
        BingoGame bingoGame = game = session != null && session.isRunning() ? (BingoGame)session.phase() : null;
        if (game != null) {
            game.getProgressTracker().handlePlayerStatIncrement(player, statistic, newValue);
        }
        return EventResult.PASS;
    }

    @Override
    public EventResult<?> sendPlayerAdvancementDone(PlayerHandle player, AdvancementHandle advancement) {
        BingoGame game;
        if (this.disableAdvancements) {
            return EventResult.PASS;
        }
        BingoSession session = this.getSession(player.world());
        BingoGame bingoGame = game = session != null && session.isRunning() ? (BingoGame)session.phase() : null;
        if (game != null) {
            game.getProgressTracker().handlePlayerAdvancementDone(player, advancement);
        }
        return EventResult.PASS;
    }

    @Override
    public EventResult<EventResults.PlayerPickupResult> sendPlayerPickupStack(PlayerHandle player, StackHandle stack, WorldPosition itemLocation) {
        BingoGame game;
        BingoSession session = this.getSession(player.world());
        BingoGame bingoGame = game = session != null && session.isRunning() ? (BingoGame)session.phase() : null;
        if (game != null && game.hasStarted()) {
            return game.getProgressTracker().handlePlayerPickupItem(player, stack, itemLocation);
        }
        return new EventResult<Object>(false, null);
    }

    @Override
    public EventResult<?> sendPlayerInventoryClick(PlayerHandle player, StackHandle itemOnCursor, boolean resultSlot, boolean shiftClick) {
        BingoGame game;
        BingoSession session = this.getSession(player.world());
        BingoGame bingoGame = game = session != null && session.isRunning() ? (BingoGame)session.phase() : null;
        if (game != null && game.hasStarted()) {
            game.getProgressTracker().handleInventoryClicked(player, itemOnCursor, resultSlot, shiftClick);
        }
        return EventResult.PASS;
    }

    @Nullable
    private BingoGame getBingoGame(WorldHandle world) {
        BingoSession session = this.getSession(world);
        if (session == null) {
            return null;
        }
        GamePhase gamePhase = session.getPhase();
        if (gamePhase instanceof BingoGame) {
            BingoGame game = (BingoGame)gamePhase;
            return game;
        }
        return null;
    }
}

