/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.api;

import io.github.steaf23.bingoreloaded.api.TeamDisplay;
import io.github.steaf23.bingoreloaded.api.TeamPacketHelper;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamDisplayPaper
implements TeamDisplay {
    private final BingoSession session;
    private final TeamManager manager;
    private final Map<UUID, Set<TeamInfo>> createdTeams;

    public TeamDisplayPaper(BingoSession session) {
        this.session = session;
        this.manager = session.teamManager;
        this.createdTeams = new HashMap<UUID, Set<TeamInfo>>();
    }

    @Override
    public void update() {
        this.reset();
        Set<BingoTeam> activeTeams = this.manager.getActiveTeams().getTeams();
        for (PlayerHandle player : this.session.getPlayersInWorld()) {
            this.addTeamsForPlayer(player, activeTeams);
        }
    }

    private void addTeamsForPlayer(PlayerHandle player, Set<BingoTeam> activeTeams) {
        Set knownTeams = this.createdTeams.getOrDefault(player.uniqueId(), Set.of());
        for (TeamInfo t : knownTeams) {
            boolean removeTeam = activeTeams.stream().noneMatch(bTeam -> bTeam.getIdentifier().equals(t.identifier()));
            if (!removeTeam) continue;
            this.removeTeamForPlayer(t.identifier(), player);
        }
        Set newTeams = activeTeams.stream().map(this::teamInfoFromBingoTeam).collect(Collectors.toSet());
        this.createdTeams.put(player.uniqueId(), newTeams);
        for (TeamInfo team : newTeams) {
            this.createTeamForPlayer(team, player);
        }
    }

    private TeamInfo teamInfoFromBingoTeam(BingoTeam team) {
        return new TeamInfo(team.getIdentifier(), team.getName(), team.getPrefix(), null, team.getMemberNames());
    }

    private void createTeamForPlayer(TeamInfo team, PlayerHandle player) {
        TeamPacketHelper.createTeamVisibleToPlayer(player, team.identifier(), team.displayName(), team.prefix(), team.suffix(), team.entries());
    }

    private void removeTeamForPlayer(String teamIdentifier, PlayerHandle player) {
        TeamPacketHelper.removeTeamVisibleToPlayer(player, teamIdentifier);
    }

    @Override
    public void clearTeamsForPlayer(@NotNull PlayerHandle player) {
        for (TeamInfo info : this.createdTeams.getOrDefault(player.uniqueId(), Set.of())) {
            this.removeTeamForPlayer(info.identifier(), player);
        }
        this.createdTeams.remove(player.uniqueId());
    }

    @Override
    public void reset() {
        for (PlayerHandle player : this.session.getPlayersInWorld()) {
            this.clearTeamsForPlayer(player);
        }
        this.createdTeams.clear();
    }

    private record TeamInfo(String identifier, Component displayName, @Nullable Component prefix, @Nullable Component suffix, Collection<String> entries) {
    }
}

