/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoTaskCard
extends TaskCard {
    public BingoTaskCard(@NotNull CardMenu menu, CardSize size) {
        super(menu, size);
    }

    @Override
    public boolean hasTeamWon(BingoTeam team) {
        List<GameTask> allTasks = this.getTasks();
        for (int y = 0; y < this.size.size; ++y) {
            boolean completedRow = true;
            boolean completedCol = true;
            for (int x = 0; x < this.size.size; ++x) {
                int indexCol;
                int indexRow = this.size.size * y + x;
                if (!allTasks.get(indexRow).isCompletedByTeam(team)) {
                    completedRow = false;
                }
                if (allTasks.get(indexCol = this.size.size * x + y).isCompletedByTeam(team)) continue;
                completedCol = false;
            }
            if (!completedRow && !completedCol) continue;
            return true;
        }
        boolean completedDiagonal1 = true;
        for (int idx = 0; idx < this.size.fullCardSize; idx += this.size.size + 1) {
            if (allTasks.get(idx).isCompletedByTeam(team)) continue;
            completedDiagonal1 = false;
            break;
        }
        boolean completedDiagonal2 = true;
        for (int idx = 0; idx < this.size.fullCardSize; idx += this.size.size - 1) {
            if (idx == 0 || idx == this.size.fullCardSize - 1 || allTasks.get(idx).isCompletedByTeam(team)) continue;
            completedDiagonal2 = false;
            break;
        }
        return completedDiagonal1 || completedDiagonal2;
    }

    @Override
    public BingoTaskCard copy(@Nullable Component alternateTitle) {
        BingoTaskCard card = new BingoTaskCard(this.menu.copy(alternateTitle), this.size);
        ArrayList<GameTask> newTasks = new ArrayList<GameTask>();
        for (GameTask slot : this.getTasks()) {
            newTasks.add(slot.copy());
        }
        card.setTasks(newTasks);
        return card;
    }

    @Override
    public boolean canGenerateSeparateCards() {
        return true;
    }
}

