/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.api.HotswapCardMenu;
import io.github.steaf23.bingoreloaded.api.TaskDisplayMode;
import io.github.steaf23.bingoreloaded.cards.BingoTaskCard;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.cards.CompleteTaskCard;
import io.github.steaf23.bingoreloaded.cards.HotswapTaskCard;
import io.github.steaf23.bingoreloaded.cards.LockoutTaskCard;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.lib.api.BingoReloadedRuntime;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.tasks.TaskGenerator;
import java.util.HashSet;
import java.util.Set;

public class CardFactory {
    public static TaskCard fromGame(BingoReloadedRuntime runtime, BingoGame game, boolean texturedMenu) {
        BingoSettings settings = game.getSettings();
        CardSize size = settings.size();
        boolean allowViewingAllCards = game.getConfig().getOptionValue(BingoOptions.ALLOW_VIEWING_ALL_CARDS);
        CardDisplayInfo displayInfo = new CardDisplayInfo(settings.mode(), size, game.getConfig().getOptionValue(BingoOptions.SHOW_UNIQUE_ADVANCEMENT_ITEMS) != false ? TaskDisplayMode.UNIQUE_TASK_ITEMS : TaskDisplayMode.GENERIC_TASK_ITEMS, game.getConfig().getOptionValue(BingoOptions.SHOW_UNIQUE_STATISTIC_ITEMS) != false ? TaskDisplayMode.UNIQUE_TASK_ITEMS : TaskDisplayMode.GENERIC_TASK_ITEMS, allowViewingAllCards);
        CardMenu menu = runtime.createMenu(texturedMenu, displayInfo);
        return switch (settings.mode()) {
            case BingoGamemode.LOCKOUT -> new LockoutTaskCard(menu, size, game.getSession(), game.getTeamManager().getActiveTeams());
            case BingoGamemode.COMPLETE -> new CompleteTaskCard(menu, size, game.getSettings().completeGoal());
            case BingoGamemode.HOTSWAP -> new HotswapTaskCard((HotswapCardMenu)menu, size, game, game.getProgressTracker(), settings.hotswapGoal(), game.getConfig().getOptionValue(BingoOptions.HOTSWAP_CONFIG));
            default -> new BingoTaskCard(menu, size);
        };
    }

    public static Set<TaskCard> generateCardsForGame(BingoGame game, boolean includeAdvancements, boolean includeStatistics) {
        BingoSettings settings = game.getSettings();
        TaskGenerator.GeneratorSettings generatorSettings = new TaskGenerator.GeneratorSettings(settings.card(), settings.seed(), includeAdvancements, includeStatistics, settings.size());
        HashSet<TaskCard> uniqueCards = new HashSet<TaskCard>();
        TaskCard masterCard = CardFactory.fromGame(BingoReloaded.runtime(), game, BingoReloaded.useResourcePack());
        if (settings.differentCardPerTeam() && masterCard.canGenerateSeparateCards()) {
            game.getTeamManager().getActiveTeams().forEach(t -> {
                t.outOfTheGame = false;
                TaskCard card = masterCard.copy(BingoMessage.SHOW_TEAM_CARD_NAME.asPhrase(t.getColoredName()));
                card.generateCard(generatorSettings);
                t.setCard(card);
                uniqueCards.add(card);
            });
        } else {
            masterCard.generateCard(generatorSettings);
            game.getTeamManager().getActiveTeams().forEach(t -> {
                t.outOfTheGame = false;
                TaskCard card = masterCard.copy(BingoMessage.SHOW_TEAM_CARD_NAME.asPhrase(t.getColoredName()));
                t.setCard(card);
                uniqueCards.add(card);
            });
        }
        return uniqueCards;
    }
}

