/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.NotNull;

public enum CardSize implements ComponentLike
{
    X3(3, 3),
    X5(5, 2);

    public final int size;
    public final int leftSpacing;
    public final int rightSpacing;
    public final int fullCardSize;
    public final Set<Integer> taskSlots;

    private CardSize(int size, int leftSpacing) {
        this.size = size;
        this.leftSpacing = leftSpacing;
        this.rightSpacing = 9 - size - leftSpacing;
        this.fullCardSize = (int)Math.pow(size, 2.0);
        this.taskSlots = new HashSet<Integer>();
        for (int i = 0; i < this.fullCardSize; ++i) {
            this.taskSlots.add(this.getCardInventorySlot(i));
        }
    }

    public int getCardInventorySlot(int itemIndex) {
        int row = itemIndex == this.fullCardSize - 1 ? this.size - 1 : (int)Math.floor((double)itemIndex / (double)this.size);
        return itemIndex + this.leftSpacing + row * (this.leftSpacing + this.rightSpacing);
    }

    public static CardSize fromWidth(int width) {
        for (CardSize size : CardSize.values()) {
            if (size.size != width) continue;
            return size;
        }
        return X5;
    }

    @Override
    @NotNull
    public Component asComponent() {
        return Component.text(this.size + "x" + this.size);
    }
}

