/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompleteTaskCard
extends TaskCard {
    private final int completeGoal;

    public CompleteTaskCard(@NotNull CardMenu menu, CardSize size, int completeGoal) {
        super(menu, size);
        menu.setInfo(BingoMessage.INFO_COMPLETE_NAME.asPhrase(new Component[0]), BingoMessage.INFO_COMPLETE_DESC.asMultiline(new Component[0]));
        this.completeGoal = completeGoal;
    }

    @Override
    public boolean hasTeamWon(@NotNull BingoTeam team) {
        return this.getCompleteCount(team) == Math.min(this.completeGoal, this.size.fullCardSize);
    }

    @Override
    public TaskCard copy(@Nullable Component alternateTitle) {
        CompleteTaskCard card = new CompleteTaskCard(this.menu.copy(alternateTitle), this.size, this.completeGoal);
        ArrayList<GameTask> newTasks = new ArrayList<GameTask>();
        for (GameTask t : this.getTasks()) {
            newTasks.add(t.copy());
        }
        card.setTasks(newTasks);
        return card;
    }

    @Override
    public boolean canGenerateSeparateCards() {
        return true;
    }
}

