/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import io.github.steaf23.bingoreloaded.api.HotswapCardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.cards.hotswap.ExpiringHotswapTask;
import io.github.steaf23.bingoreloaded.cards.hotswap.HotswapTaskHolder;
import io.github.steaf23.bingoreloaded.cards.hotswap.SimpleHotswapTask;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoSound;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.TaskGenerator;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import io.github.steaf23.bingoreloaded.tasks.tracker.TaskProgressTracker;
import io.github.steaf23.bingoreloaded.util.CollectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotswapTaskCard
extends TaskCard {
    private final int winningScore;
    private final Random randomExpiryProvider = new Random();
    private final int minExpirationTime;
    private final int maxExpirationTime;
    private final int recoveryTimeSeconds;
    private final boolean showExpirationAsDurability;
    private final boolean expireTasksAutomatically;
    private final List<HotswapTaskHolder> taskHolders = new ArrayList<HotswapTaskHolder>();
    private Supplier<GameTask> bingoTaskGenerator;
    private final List<GameTask> completedTasks = new ArrayList<GameTask>();
    private final BingoCardData cardData;
    private final BingoGame game;
    private final TaskProgressTracker progressTracker;
    private final List<TaskData> randomTasks;

    public HotswapTaskCard(@NotNull HotswapCardMenu menu, CardSize size, BingoGame game, TaskProgressTracker progressTracker, int winningScore, BingoConfigurationData.HotswapConfig config) {
        super(menu, size);
        this.bingoTaskGenerator = () -> null;
        this.cardData = new BingoCardData();
        this.game = game;
        this.progressTracker = progressTracker;
        this.minExpirationTime = config.minimumExpiration();
        this.maxExpirationTime = config.maximumExpiration();
        this.recoveryTimeSeconds = config.recoveryTime();
        this.showExpirationAsDurability = config.showExpirationAsDurability() && game.getSettings().expireHotswapTasks();
        this.randomTasks = new ArrayList<TaskData>();
        this.expireTasksAutomatically = game.getSettings().expireHotswapTasks();
        game.getTimer().addNotifier(this::updateTaskExpiration);
        this.winningScore = game.getSettings().useScoreAsWinCondition() ? winningScore : -1;
        Component[] description = new Component[]{};
        if (this.expireTasksAutomatically) {
            description = BingoMessage.INFO_HOTSWAP_DESC_EXPIRE.asMultiline(Component.text(game.getSettings().countdownDuration()));
        }
        Component[] extraDescription = switch (game.getSettings().countdownType()) {
            default -> throw new MatchException(null, null);
            case BingoSettings.CountdownType.DISABLED -> BingoMessage.INFO_HOTSWAP_DESC_SCORE.asMultiline(Component.text(game.getSettings().hotswapGoal()));
            case BingoSettings.CountdownType.DURATION -> BingoMessage.INFO_HOTSWAP_DESC_TIME.asMultiline(new Component[0]);
            case BingoSettings.CountdownType.TIME_LIMIT -> BingoMessage.INFO_HOTSWAP_DESC_ANY.asMultiline(Component.text(game.getSettings().hotswapGoal()));
        };
        menu.setInfo(BingoMessage.INFO_HOTSWAP_NAME.asPhrase(new Component[0]), CollectionHelper.concatWithArrayCopy(description, extraDescription));
    }

    @Override
    public boolean hasTeamWon(@NotNull BingoTeam team) {
        if (this.winningScore == -1) {
            return false;
        }
        return this.getCompleteCount(team) >= this.winningScore;
    }

    @Override
    public TaskCard copy(@Nullable Component alternateTitle) {
        return this;
    }

    @Override
    public boolean canGenerateSeparateCards() {
        return false;
    }

    @Override
    public void generateCard(TaskGenerator.GeneratorSettings settings) {
        super.generateCard(settings);
        if (settings.seed() != 0) {
            this.randomExpiryProvider.setSeed(settings.seed());
        }
        this.bingoTaskGenerator = () -> {
            if (this.randomTasks.isEmpty()) {
                this.randomTasks.addAll(this.cardData.getAllTasks(settings.cardName(), settings.includeStatistics(), settings.includeAdvancements()));
                this.randomTasks.removeIf(data -> {
                    for (GameTask task : this.getTasks()) {
                        if (!task.data.isTaskEqual((TaskData)data)) continue;
                        return true;
                    }
                    return false;
                });
                Collections.shuffle(this.randomTasks, this.randomExpiryProvider);
            }
            if (this.randomTasks.isEmpty()) {
                return GameTask.simpleItemTask(ItemType.of("dirt"), 1);
            }
            TaskData data2 = this.randomTasks.removeLast();
            return TaskGenerator.createTaskFromData(data2);
        };
    }

    @Override
    public void setTasks(List<GameTask> tasks) {
        this.taskHolders.clear();
        if (this.expireTasksAutomatically) {
            for (GameTask task : tasks) {
                int expirationTime = this.randomExpiryProvider.nextInt(this.minExpirationTime * 60, this.maxExpirationTime * 60 + 1);
                this.taskHolders.add(new ExpiringHotswapTask(task, expirationTime, this.recoveryTimeSeconds, this.showExpirationAsDurability));
            }
        } else {
            for (GameTask task : tasks) {
                this.taskHolders.add(new SimpleHotswapTask(task, this.recoveryTimeSeconds));
            }
        }
        ((HotswapCardMenu)this.menu).updateTaskHolders(this.taskHolders);
    }

    @Override
    public void onTaskCompleted(BingoParticipant player, GameTask task, long timeSeconds) {
        this.completedTasks.add(task);
    }

    @Override
    public List<GameTask> getTasks() {
        return this.taskHolders.stream().map(HotswapTaskHolder::getTask).toList();
    }

    public void updateTaskExpiration(long timeElapsed) {
        GameTask taskToSend;
        int idx = 0;
        int taskExpiredCount = 0;
        int taskRecoveredCount = 0;
        GameTask lastExpiredTask = null;
        GameTask lastRecoverdTask = null;
        boolean dirty = false;
        for (HotswapTaskHolder holder : this.taskHolders) {
            if (!holder.isRecovering() && holder.getTask().isCompleted()) {
                holder.startRecovering();
                continue;
            }
            holder.updateTaskTime();
            if (holder.getCurrentTime() <= 0) {
                if (holder.isRecovering()) {
                    ++taskRecoveredCount;
                    GameTask newTask = this.bingoTaskGenerator.get();
                    if (newTask == null) {
                        ConsoleMessenger.bug("Cannot generate new task for hot-swap", (Object)this);
                    }
                    lastRecoverdTask = newTask;
                    if (this.expireTasksAutomatically) {
                        int expirationTime = this.randomExpiryProvider.nextInt(this.minExpirationTime, this.maxExpirationTime + 1) * 60;
                        this.taskHolders.set(idx, new ExpiringHotswapTask(newTask, expirationTime, this.recoveryTimeSeconds, this.showExpirationAsDurability));
                    } else {
                        this.taskHolders.set(idx, new SimpleHotswapTask(newTask, this.recoveryTimeSeconds));
                    }
                    this.progressTracker.startTrackingTask(newTask);
                } else {
                    ++taskExpiredCount;
                    lastExpiredTask = holder.getTask();
                    holder.getTask().setVoided(true);
                    holder.startRecovering();
                    this.progressTracker.removeTask(holder.getTask());
                }
                dirty = true;
            }
            ++idx;
        }
        if (taskExpiredCount > 0) {
            this.game.playSound((Sound)BingoSound.HOTSWAP_TASK_EXPIRED.builder().build());
            if (taskExpiredCount == 1) {
                taskToSend = lastExpiredTask;
                this.game.getActionBar().requestMessage(p -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().decorate(TextDecoration.BOLD)).append(BingoMessage.HOTSWAP_SINGLE_EXPIRED.asPhrase(taskToSend.data.getName()).color(TextColor.fromHexString("#e85e21")))).build(), 1, 3);
            } else {
                this.game.getActionBar().requestMessage(p -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().decorate(TextDecoration.BOLD)).append(BingoMessage.HOTSWAP_MULTIPLE_EXPIRED.asPhrase(new Component[0]).color(TextColor.fromHexString("#e85e21")))).build(), 1, 3);
            }
        }
        if (taskRecoveredCount > 0) {
            this.game.playSound((Sound)BingoSound.HOTSWAP_TASK_ADDED.builder().build());
            if (taskRecoveredCount == 1) {
                taskToSend = lastRecoverdTask;
                this.game.getActionBar().requestMessage(p -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().decorate(TextDecoration.BOLD)).append(BingoMessage.HOTSWAP_SINGLE_ADDED.asPhrase(taskToSend.data.getName()).color(TextColor.fromHexString("#5cb1ff")))).build(), 2, 3);
            } else {
                this.game.getActionBar().requestMessage(p -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().decorate(TextDecoration.BOLD)).append(BingoMessage.HOTSWAP_MULTIPLE_ADDED.asPhrase(new Component[0]).color(TextColor.fromHexString("#5cb1ff")))).build(), 1, 3);
            }
        }
        if (this.progressTracker.shouldUpdateClient()) {
            for (BingoParticipant participant : this.game.getTeamManager().getParticipants()) {
                Optional<TaskCard> card = participant.getCard();
                if (!this.equals(card.orElse(null))) continue;
                participant.sessionPlayer().ifPresent(player -> this.game.getSession().getGameManager().getRuntime().getClientManager().updateHotswapContext((PlayerHandle)player, this.taskHolders));
            }
        }
        ((HotswapCardMenu)this.menu).updateTaskHolders(this.taskHolders);
    }

    @Override
    public int getCompleteCount(@NotNull BingoTeam team) {
        return (int)this.completedTasks.stream().filter(task -> task.isCompletedByTeam(team)).count();
    }

    @Override
    public int getCompleteCount(@NotNull BingoParticipant participant) {
        return (int)this.completedTasks.stream().filter(t -> t.getCompletedByPlayer().isPresent() && t.getCompletedByPlayer().get().getId().equals(participant.getId())).count();
    }
}

