/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.BingoTeamContainer;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockoutTaskCard
extends TaskCard {
    public int teamCount;
    public int currentMaxTasks;
    private final BingoSession session;
    private final BingoTeamContainer teams;

    public LockoutTaskCard(@NotNull CardMenu menu, CardSize size, BingoSession session, BingoTeamContainer teams) {
        super(menu, size);
        this.currentMaxTasks = size.fullCardSize;
        this.teamCount = teams.teamCount();
        this.session = session;
        this.teams = teams;
        menu.setInfo(BingoMessage.INFO_LOCKOUT_NAME.asPhrase(new Component[0]), BingoMessage.INFO_LOCKOUT_DESC.asMultiline(new Component[0]));
    }

    @Override
    public boolean hasTeamWon(BingoTeam team) {
        BingoTeam leadingTeam = this.teams.getLeadingTeam();
        BingoTeam losingTeam = this.teams.getLosingTeam();
        int itemsLeft = this.size.fullCardSize - this.teams.getTotalCompleteCount();
        if (itemsLeft + losingTeam.getCompleteCount() < leadingTeam.getCompleteCount()) {
            this.dropTeam(losingTeam, this.session);
        }
        if (this.teamCount < 2) {
            return true;
        }
        if (this.teamCount > 2) {
            return false;
        }
        int completeCount = team.getCompleteCount();
        return completeCount > this.currentMaxTasks / 2;
    }

    @Override
    public TaskCard copy(@Nullable Component alternateTitle) {
        return this;
    }

    @Override
    public boolean canGenerateSeparateCards() {
        return false;
    }

    public void dropTeam(BingoTeam team, BingoSession session) {
        if (team.outOfTheGame) {
            return;
        }
        BingoMessage.DROPPED.sendToAudience((Audience)session, team.getColoredName());
        team.outOfTheGame = true;
        for (GameTask task : this.getTasks()) {
            if (!task.isCompletedByTeam(team)) continue;
            task.setVoided(true);
            --this.currentMaxTasks;
        }
        --this.teamCount;
    }
}

